/**
 * <h1>Amazon Elastic Load Balancing Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * The <code>&#64;aws-cdk/aws-elasticloadbalancing</code> package provides constructs for configuring
 * classic load balancers.
 * <p>
 * <h2>Configuring a Load Balancer</h2>
 * <p>
 * Load balancers send traffic to one or more AutoScalingGroups. Create a load
 * balancer, set up listeners and a health check, and supply the fleet(s) you want
 * to load balance to in the <code>targets</code> property.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object lb = LoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .healthCheck(Map.of(
 *                 "port", 80))
 *         .build();
 * 
 * lb.addTarget(myAutoScalingGroup);
 * lb.addListener(Map.of(
 *         "externalPort", 80));
 * </pre></blockquote>
 * <p>
 * The load balancer allows all connections by default. If you want to change that,
 * pass the <code>allowConnectionsFrom</code> property while setting up the listener:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * lb.addListener(Map.of(
 *         "externalPort", 80,
 *         "allowConnectionsFrom", asList(mySecurityGroup)));
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.elasticloadbalancing;
