package software.amazon.awscdk.services.elasticsearch;

/**
 * (experimental) Configures Amazon ES to use Amazon Cognito authentication for Kibana.
 * <p>
 * @see https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:34.969Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CognitoOptions")
@software.amazon.jsii.Jsii.Proxy(CognitoOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CognitoOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The Amazon Cognito identity pool ID that you want Amazon ES to use for Kibana authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId();

    /**
     * (experimental) A role that allows Amazon ES to configure your user pool and identity pool.
     * <p>
     * It must have the <code>AmazonESCognitoAccess</code> policy attached to it.
     * <p>
     * @see https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html#es-cognito-auth-prereq
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * (experimental) The Amazon Cognito user pool ID that you want Amazon ES to use for Kibana authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * @return a {@link Builder} of {@link CognitoOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CognitoOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CognitoOptions> {
        private java.lang.String identityPoolId;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.lang.String userPoolId;

        /**
         * Sets the value of {@link CognitoOptions#getIdentityPoolId}
         * @param identityPoolId The Amazon Cognito identity pool ID that you want Amazon ES to use for Kibana authentication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identityPoolId(java.lang.String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CognitoOptions#getRole}
         * @param role A role that allows Amazon ES to configure your user pool and identity pool. This parameter is required.
         *             It must have the <code>AmazonESCognitoAccess</code> policy attached to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CognitoOptions#getUserPoolId}
         * @param userPoolId The Amazon Cognito user pool ID that you want Amazon ES to use for Kibana authentication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CognitoOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CognitoOptions build() {
            return new Jsii$Proxy(identityPoolId, role, userPoolId);
        }
    }

    /**
     * An implementation for {@link CognitoOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoOptions {
        private final java.lang.String identityPoolId;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String userPoolId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityPoolId = software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String identityPoolId, final software.amazon.awscdk.services.iam.IRole role, final java.lang.String userPoolId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityPoolId = java.util.Objects.requireNonNull(identityPoolId, "identityPoolId is required");
            this.role = java.util.Objects.requireNonNull(role, "role is required");
            this.userPoolId = java.util.Objects.requireNonNull(userPoolId, "userPoolId is required");
        }

        @Override
        public final java.lang.String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
            data.set("role", om.valueToTree(this.getRole()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CognitoOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CognitoOptions.Jsii$Proxy that = (CognitoOptions.Jsii$Proxy) o;

            if (!identityPoolId.equals(that.identityPoolId)) return false;
            if (!role.equals(that.role)) return false;
            return this.userPoolId.equals(that.userPoolId);
        }

        @Override
        public final int hashCode() {
            int result = this.identityPoolId.hashCode();
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.userPoolId.hashCode());
            return result;
        }
    }
}
