package software.amazon.awscdk.services.elasticsearch;

/**
 * (experimental) An interface that represents an Elasticsearch domain - either created with the CDK, or an existing one.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:34.972Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.IDomain")
@software.amazon.jsii.Jsii.Proxy(IDomain.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IDomain extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource {

    /**
     * (experimental) Arn of the Elasticsearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainArn();

    /**
     * (experimental) Endpoint of the Elasticsearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainEndpoint();

    /**
     * (experimental) Domain name of the Elasticsearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * (experimental) Grant read permissions for an index in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param index The index to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexRead(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant read/write permissions for an index in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param index The index to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant write permissions for an index in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param index The index to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant read permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param path The path to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathRead(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant read/write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param path The path to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
     * <p>
     * @param path The path to grant permissions for. This parameter is required.
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant read permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant read/write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Grant write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * (experimental) Return the given named metric for this Domain.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Return the given named metric for this Domain.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * (experimental) Metric for automated snapshot failures.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAutomatedSnapshotFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for automated snapshot failures.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAutomatedSnapshotFailure();

    /**
     * (experimental) Metric for the cluster blocking index writes.
     * <p>
     * Default: maximum over 1 minute
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterIndexWritesBlocked(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for the cluster blocking index writes.
     * <p>
     * Default: maximum over 1 minute
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterIndexWritesBlocked();

    /**
     * (experimental) Metric for the time the cluster status is red.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusRed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for the time the cluster status is red.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusRed();

    /**
     * (experimental) Metric for the time the cluster status is yellow.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusYellow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for the time the cluster status is yellow.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusYellow();

    /**
     * (experimental) Metric for CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization();

    /**
     * (experimental) Metric for the storage space of nodes in the cluster.
     * <p>
     * Default: minimum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeStorageSpace(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for the storage space of nodes in the cluster.
     * <p>
     * Default: minimum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeStorageSpace();

    /**
     * (experimental) Metric for indexing latency.
     * <p>
     * Default: p99 over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIndexingLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for indexing latency.
     * <p>
     * Default: p99 over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIndexingLatency();

    /**
     * (experimental) Metric for JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricJVMMemoryPressure();

    /**
     * (experimental) Metric for KMS key errors.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for KMS key errors.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyError();

    /**
     * (experimental) Metric for KMS key being inaccessible.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyInaccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for KMS key being inaccessible.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyInaccessible();

    /**
     * (experimental) Metric for master CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for master CPU utilization.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterCPUUtilization();

    /**
     * (experimental) Metric for master JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for master JVM memory pressure.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterJVMMemoryPressure();

    /**
     * (experimental) Metric for the number of nodes.
     * <p>
     * Default: minimum over 1 hour
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNodes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for the number of nodes.
     * <p>
     * Default: minimum over 1 hour
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNodes();

    /**
     * (experimental) Metric for number of searchable documents.
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchableDocuments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for number of searchable documents.
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchableDocuments();

    /**
     * (experimental) Metric for search latency.
     * <p>
     * Default: p99 over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Metric for search latency.
     * <p>
     * Default: p99 over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchLatency();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticsearch.IDomain.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * (experimental) Arn of the Elasticsearch domain.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDomainArn() {
            return software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Endpoint of the Elasticsearch domain.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDomainEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "domainEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Domain name of the Elasticsearch domain.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
            return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Grant read permissions for an index in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param index The index to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexRead(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantIndexRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read/write permissions for an index in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param index The index to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantIndexReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant write permissions for an index in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param index The index to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantIndexWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read permissions for a specific path in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param path The path to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathRead(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPathRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read/write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param path The path to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPathReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param path The path to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPathWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read permissions for this domain and its contents to an IAM principal (Role/Group/User).
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read/write permissions for this domain and its contents to an IAM principal (Role/Group/User).
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant write permissions for this domain and its contents to an IAM principal (Role/Group/User).
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Return the given named metric for this Domain.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * (experimental) Return the given named metric for this Domain.
         * <p>
         * @param metricName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * (experimental) Metric for automated snapshot failures.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAutomatedSnapshotFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricAutomatedSnapshotFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for automated snapshot failures.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAutomatedSnapshotFailure() {
            return software.amazon.jsii.Kernel.call(this, "metricAutomatedSnapshotFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for the cluster blocking index writes.
         * <p>
         * Default: maximum over 1 minute
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterIndexWritesBlocked(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricClusterIndexWritesBlocked", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the cluster blocking index writes.
         * <p>
         * Default: maximum over 1 minute
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterIndexWritesBlocked() {
            return software.amazon.jsii.Kernel.call(this, "metricClusterIndexWritesBlocked", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for the time the cluster status is red.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusRed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricClusterStatusRed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the time the cluster status is red.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusRed() {
            return software.amazon.jsii.Kernel.call(this, "metricClusterStatusRed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for the time the cluster status is yellow.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusYellow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricClusterStatusYellow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the time the cluster status is yellow.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusYellow() {
            return software.amazon.jsii.Kernel.call(this, "metricClusterStatusYellow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for CPU utilization.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for CPU utilization.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization() {
            return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for the storage space of nodes in the cluster.
         * <p>
         * Default: minimum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeStorageSpace(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFreeStorageSpace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the storage space of nodes in the cluster.
         * <p>
         * Default: minimum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeStorageSpace() {
            return software.amazon.jsii.Kernel.call(this, "metricFreeStorageSpace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for indexing latency.
         * <p>
         * Default: p99 over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIndexingLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIndexingLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for indexing latency.
         * <p>
         * Default: p99 over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIndexingLatency() {
            return software.amazon.jsii.Kernel.call(this, "metricIndexingLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for JVM memory pressure.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for JVM memory pressure.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricJVMMemoryPressure() {
            return software.amazon.jsii.Kernel.call(this, "metricJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for KMS key errors.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricKMSKeyError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for KMS key errors.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyError() {
            return software.amazon.jsii.Kernel.call(this, "metricKMSKeyError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for KMS key being inaccessible.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyInaccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricKMSKeyInaccessible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for KMS key being inaccessible.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyInaccessible() {
            return software.amazon.jsii.Kernel.call(this, "metricKMSKeyInaccessible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for master CPU utilization.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricMasterCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for master CPU utilization.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterCPUUtilization() {
            return software.amazon.jsii.Kernel.call(this, "metricMasterCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for master JVM memory pressure.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricMasterJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for master JVM memory pressure.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterJVMMemoryPressure() {
            return software.amazon.jsii.Kernel.call(this, "metricMasterJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for the number of nodes.
         * <p>
         * Default: minimum over 1 hour
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNodes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNodes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the number of nodes.
         * <p>
         * Default: minimum over 1 hour
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNodes() {
            return software.amazon.jsii.Kernel.call(this, "metricNodes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for number of searchable documents.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchableDocuments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSearchableDocuments", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for number of searchable documents.
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchableDocuments() {
            return software.amazon.jsii.Kernel.call(this, "metricSearchableDocuments", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Metric for search latency.
         * <p>
         * Default: p99 over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSearchLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for search latency.
         * <p>
         * Default: p99 over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchLatency() {
            return software.amazon.jsii.Kernel.call(this, "metricSearchLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }
    }

    /**
     * Internal default implementation for {@link IDomain}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IDomain, software.amazon.awscdk.IResource.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * (experimental) Arn of the Elasticsearch domain.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getDomainArn() {
            return software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Endpoint of the Elasticsearch domain.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getDomainEndpoint() {
            return software.amazon.jsii.Kernel.get(this, "domainEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Domain name of the Elasticsearch domain.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
            return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Grant read permissions for an index in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param index The index to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexRead(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantIndexRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read/write permissions for an index in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param index The index to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantIndexReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant write permissions for an index in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param index The index to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantIndexWrite(final @org.jetbrains.annotations.NotNull java.lang.String index, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantIndexWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(index, "index is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read permissions for a specific path in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param path The path to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathRead(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPathRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read/write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param path The path to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathReadWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPathReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant write permissions for a specific path in this domain to an IAM principal (Role/Group/User).
         * <p>
         * @param path The path to grant permissions for. This parameter is required.
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPathWrite(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantPathWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read permissions for this domain and its contents to an IAM principal (Role/Group/User).
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant read/write permissions for this domain and its contents to an IAM principal (Role/Group/User).
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Grant write permissions for this domain and its contents to an IAM principal (Role/Group/User).
         * <p>
         * @param identity The principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * (experimental) Return the given named metric for this Domain.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * (experimental) Metric for automated snapshot failures.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAutomatedSnapshotFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricAutomatedSnapshotFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the cluster blocking index writes.
         * <p>
         * Default: maximum over 1 minute
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterIndexWritesBlocked(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricClusterIndexWritesBlocked", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the time the cluster status is red.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusRed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricClusterStatusRed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the time the cluster status is yellow.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClusterStatusYellow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricClusterStatusYellow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for CPU utilization.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the storage space of nodes in the cluster.
         * <p>
         * Default: minimum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFreeStorageSpace(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFreeStorageSpace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for indexing latency.
         * <p>
         * Default: p99 over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIndexingLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIndexingLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for JVM memory pressure.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for KMS key errors.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricKMSKeyError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for KMS key being inaccessible.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKMSKeyInaccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricKMSKeyInaccessible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for master CPU utilization.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterCPUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricMasterCPUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for master JVM memory pressure.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMasterJVMMemoryPressure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricMasterJVMMemoryPressure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for the number of nodes.
         * <p>
         * Default: minimum over 1 hour
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNodes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNodes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for number of searchable documents.
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchableDocuments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSearchableDocuments", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Metric for search latency.
         * <p>
         * Default: p99 over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSearchLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSearchLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }
    }
}
