/**
 * <h1>AWS Key Management Service Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define a KMS key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_kms;
 * 
 * 
 * new Key(this, "MyKey", new KeyProps()
 *         .enableKeyRotation(true));
 * </pre></blockquote>
 * <p>
 * Define a KMS key with waiting period:
 * <p>
 * Specifies the number of days in the waiting period before AWS KMS deletes a CMK that has been removed from a CloudFormation stack.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object key = Key.Builder.create(this, "MyKey")
 *         .pendingWindow(10)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Add a couple of aliases:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object key = new Key(this, "MyKey");
 * key.addAlias("alias/foo");
 * key.addAlias("alias/bar");
 * </pre></blockquote>
 * <p>
 * Define a key with specific key spec and key usage:
 * <p>
 * Valid <code>keySpec</code> values depends on <code>keyUsage</code> value.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object key = Key.Builder.create(this, "MyKey")
 *         .keySpec(kms.KeySpec.getECC_SECG_P256K1())// Default to SYMMETRIC_DEFAULT
 *         .keyUsage(kms.KeyUsage.getSIGN_VERIFY())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Sharing keys between stacks</h2>
 * <p>
 * To use a KMS key in a different stack in the same CDK application,
 * pass the construct to the other stack:
 * <p>
 * <a href="test/integ.key-sharing.lit.ts">sharing key between stacks</a>
 * <p>
 * <h2>Importing existing keys</h2>
 * <p>
 * To use a KMS key that is not defined in this CDK app, but is created through other means, use
 * <code>Key.fromKeyArn(parent, name, ref)</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object myKeyImported = kms.Key.fromKeyArn(this, "MyImportedKey", "arn:aws:...");
 * 
 * // you can do stuff with this imported key.
 * myKeyImported.addAlias("alias/foo");
 * </pre></blockquote>
 * <p>
 * Note that a call to <code>.addToPolicy(statement)</code> on <code>myKeyImported</code> will not have
 * an affect on the key's policy because it is not owned by your stack. The call
 * will be a no-op.
 * <p>
 * If a Key has an associated Alias, the Alias can be imported by name and used in place
 * of the Key as a reference. A common scenario for this is in referencing AWS managed keys.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object myKeyAlias = kms.Alias.fromAliasName(this, "myKey", "alias/aws/s3");
 * Object trail = Trail.Builder.create(this, "myCloudTrail")
 *         .sendToCloudWatchLogs(true)
 *         .kmsKey(myKeyAlias)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Note that calls to <code>addToResourcePolicy</code> and <code>grant*</code> methods on <code>myKeyAlias</code> will be
 * no-ops, and <code>addAlias</code> and <code>aliasTargetKey</code> will fail, as the imported alias does not
 * have a reference to the underlying KMS Key.
 * <p>
 * <h2>Key Policies</h2>
 * <p>
 * Controlling access and usage of KMS Keys requires the use of key policies (resource-based policies attached to the key);
 * this is in contrast to most other AWS resources where access can be entirely controlled with IAM policies,
 * and optionally complemented with resource policies. For more in-depth understanding of KMS key access and policies, see
 * <p>
 * <ul>
 * <li>https://docs.aws.amazon.com/kms/latest/developerguide/control-access-overview.html</li>
 * <li>https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html</li>
 * </ul>
 * <p>
 * KMS keys can be created to trust IAM policies. This is the default behavior for both the KMS APIs and in
 * the console. This behavior is enabled by the '&#64;aws-cdk/aws-kms:defaultKeyPolicies' feature flag,
 * which is set for all new projects; for existing projects, this same behavior can be enabled by
 * passing the <code>trustAccountIdentities</code> property as <code>true</code> when creating the key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Key.Builder.create(stack, "MyKey").trustAccountIdentities(true).build();
 * </pre></blockquote>
 * <p>
 * With either the <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> feature flag set,
 * or the <code>trustAccountIdentities</code> prop set, the Key will be given the following default key policy:
 * <p>
 * <blockquote><pre>
 * {
 *   "Effect": "Allow",
 *   "Principal": {"AWS": "arn:aws:iam::111122223333:root"},
 *   "Action": "kms:*",
 *   "Resource": "*"
 * }
 * </pre></blockquote>
 * <p>
 * This policy grants full access to the key to the root account user.
 * This enables the root account user -- via IAM policies -- to grant access to other IAM principals.
 * With the above default policy, future permissions can be added to either the key policy or IAM principal policy.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object key = new Key(stack, "MyKey");
 * User user = new User(stack, "MyUser");
 * key.grantEncrypt(user);
 * </pre></blockquote>
 * <p>
 * Adopting the default KMS key policy (and so trusting account identities)
 * solves many issues around cyclic dependencies between stacks.
 * Without this default key policy, future permissions must be added to both the key policy and IAM principal policy,
 * which can cause cyclic dependencies if the permissions cross stack boundaries.
 * (For example, an encrypted bucket in one stack, and Lambda function that accesses it in another.)
 * <p>
 * <h3>Appending to or replacing the default key policy</h3>
 * <p>
 * The default key policy can be amended or replaced entirely, depending on your use case and requirements.
 * A common addition to the key policy would be to add other key admins that are allowed to administer the key
 * (e.g., change permissions, revoke, delete). Additional key admins can be specified at key creation or after
 * via the <code>grantAdmin</code> method.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * IRole myTrustedAdminRole = iam.Role.fromRoleArn(stack, "TrustedRole", "arn:aws:iam:....");
 * Object key = Key.Builder.create(stack, "MyKey")
 *         .admins(asList(myTrustedAdminRole))
 *         .build();
 * 
 * Object secondKey = new Key(stack, "MyKey2");
 * secondKey.grantAdmin(myTrustedAdminRole);
 * </pre></blockquote>
 * <p>
 * Alternatively, a custom key policy can be specified, which will replace the default key policy.
 * <p>
 * <blockquote>
 * <p>
 * <strong>Note</strong>: In applications without the '&#64;aws-cdk/aws-kms:defaultKeyPolicies' feature flag set
 * and with <code>trustedAccountIdentities</code> set to false (the default), specifying a policy at key creation <em>appends</em> the
 * provided policy to the default key policy, rather than <em>replacing</em> the default policy.
 * <p>
 * </blockquote>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * IRole myTrustedAdminRole = iam.Role.fromRoleArn(stack, "TrustedRole", "arn:aws:iam:....");
 * // Creates a limited admin policy and assigns to the account root.
 * PolicyDocument myCustomPolicy = new PolicyDocument(new PolicyDocumentProps()
 *         .statements(asList(new PolicyStatement(new PolicyStatementProps()
 *                 .actions(asList("kms:Create*", "kms:Describe*", "kms:Enable*", "kms:List*", "kms:Put*"))
 *                 .principals(asList(new AccountRootPrincipal()))
 *                 .resources(asList("*"))))));
 * Object key = Key.Builder.create(stack, "MyKey")
 *         .policy(myCustomPolicy)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <blockquote>
 * <p>
 * <strong>Warning:</strong> Replacing the default key policy with one that only grants access to a specific user or role
 * runs the risk of the key becoming unmanageable if that user or role is deleted.
 * It is highly recommended that the key policy grants access to the account root, rather than specific principals.
 * See https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html for more information.
 * <p>
 * </blockquote>
 */
package software.amazon.awscdk.services.kms;
