package software.amazon.awscdk.services.logs;

/**
 * (experimental) Creates a custom resource to control the retention policy of a CloudWatch Logs log group.
 * <p>
 * The log group is created if it doesn't already exist. The policy
 * is removed when <code>retentionDays</code> is <code>undefined</code> or equal to <code>Infinity</code>.
 * Log group can be created in the region that is different from stack region by
 * specifying <code>logGroupRegion</code>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:35.527Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogRetention")
public class LogRetention extends software.constructs.Construct {

    protected LogRetention(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogRetention(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LogRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogRetentionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The ARN of the LogGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.logs.LogRetention}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.LogRetention> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.LogRetentionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.LogRetentionProps.Builder();
        }

        /**
         * (experimental) The log group name.
         * <p>
         * @return {@code this}
         * @param logGroupName The log group name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroupName(final java.lang.String logGroupName) {
            this.props.logGroupName(logGroupName);
            return this;
        }

        /**
         * (experimental) The number of days log events are kept in CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @param retention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retention(final software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.props.retention(retention);
            return this;
        }

        /**
         * (experimental) The region where the log group should be created.
         * <p>
         * Default: - same region as the stack
         * <p>
         * @return {@code this}
         * @param logGroupRegion The region where the log group should be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroupRegion(final java.lang.String logGroupRegion) {
            this.props.logGroupRegion(logGroupRegion);
            return this;
        }

        /**
         * (experimental) Retry options for all AWS API calls.
         * <p>
         * Default: - AWS SDK default retry options
         * <p>
         * @return {@code this}
         * @param logRetentionRetryOptions Retry options for all AWS API calls. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logRetentionRetryOptions(final software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        /**
         * (experimental) The IAM role for the Lambda function associated with the custom resource.
         * <p>
         * Default: - A new role is created
         * <p>
         * @return {@code this}
         * @param role The IAM role for the Lambda function associated with the custom resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.LogRetention}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.logs.LogRetention build() {
            return new software.amazon.awscdk.services.logs.LogRetention(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
