package software.amazon.awscdk.services.opsworks;

/**
 * A CloudFormation `AWS::OpsWorks::Stack`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:35.666Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack")
public class CfnStack extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opsworks.CfnStack.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::OpsWorks::Stack`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opsworks.CfnStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::OpsWorks::Stack.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::OpsWorks::Stack.CustomJson`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCustomJson() {
        return software.amazon.jsii.Kernel.get(this, "customJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.CustomJson`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomJson(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "customJson", java.util.Objects.requireNonNull(value, "customJson is required"));
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefaultInstanceProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "defaultInstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultInstanceProfileArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultInstanceProfileArn", java.util.Objects.requireNonNull(value, "defaultInstanceProfileArn is required"));
    }

    /**
     * `AWS::OpsWorks::Stack.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::OpsWorks::Stack.ServiceRoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.ServiceRoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRoleArn", java.util.Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    /**
     * `AWS::OpsWorks::Stack.AgentVersion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAgentVersion() {
        return software.amazon.jsii.Kernel.get(this, "agentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.AgentVersion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentVersion", value);
    }

    /**
     * `AWS::OpsWorks::Stack.Attributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.Attributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * `AWS::OpsWorks::Stack.Attributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ChefConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getChefConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "chefConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.ChefConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChefConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnStack.ChefConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "chefConfiguration", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ChefConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChefConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "chefConfiguration", value);
    }

    /**
     * `AWS::OpsWorks::Stack.CloneAppIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCloneAppIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "cloneAppIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::OpsWorks::Stack.CloneAppIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloneAppIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "cloneAppIds", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ClonePermissions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClonePermissions() {
        return software.amazon.jsii.Kernel.get(this, "clonePermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.ClonePermissions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClonePermissions(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "clonePermissions", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ClonePermissions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClonePermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clonePermissions", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ConfigurationManager`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationManager() {
        return software.amazon.jsii.Kernel.get(this, "configurationManager", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.ConfigurationManager`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationManager(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnStack.StackConfigurationManagerProperty value) {
        software.amazon.jsii.Kernel.set(this, "configurationManager", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ConfigurationManager`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationManager(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationManager", value);
    }

    /**
     * `AWS::OpsWorks::Stack.CustomCookbooksSource`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomCookbooksSource() {
        return software.amazon.jsii.Kernel.get(this, "customCookbooksSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.CustomCookbooksSource`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomCookbooksSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnStack.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "customCookbooksSource", value);
    }

    /**
     * `AWS::OpsWorks::Stack.CustomCookbooksSource`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomCookbooksSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customCookbooksSource", value);
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultAvailabilityZone`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "defaultAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultAvailabilityZone`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultAvailabilityZone", value);
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultOs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultOs() {
        return software.amazon.jsii.Kernel.get(this, "defaultOs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultOs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultOs(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultOs", value);
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultRootDeviceType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootDeviceType() {
        return software.amazon.jsii.Kernel.get(this, "defaultRootDeviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultRootDeviceType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRootDeviceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultRootDeviceType", value);
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultSshKeyName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultSshKeyName() {
        return software.amazon.jsii.Kernel.get(this, "defaultSshKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultSshKeyName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSshKeyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultSshKeyName", value);
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultSubnetId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultSubnetId() {
        return software.amazon.jsii.Kernel.get(this, "defaultSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.DefaultSubnetId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSubnetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultSubnetId", value);
    }

    /**
     * `AWS::OpsWorks::Stack.EcsClusterArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEcsClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "ecsClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.EcsClusterArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEcsClusterArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ecsClusterArn", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ElasticIps`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticIps() {
        return software.amazon.jsii.Kernel.get(this, "elasticIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.ElasticIps`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticIps(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticIps", value);
    }

    /**
     * `AWS::OpsWorks::Stack.ElasticIps`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticIps(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "elasticIps", value);
    }

    /**
     * `AWS::OpsWorks::Stack.HostnameTheme`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostnameTheme() {
        return software.amazon.jsii.Kernel.get(this, "hostnameTheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.HostnameTheme`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostnameTheme(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostnameTheme", value);
    }

    /**
     * `AWS::OpsWorks::Stack.RdsDbInstances`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRdsDbInstances() {
        return software.amazon.jsii.Kernel.get(this, "rdsDbInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.RdsDbInstances`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRdsDbInstances(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rdsDbInstances", value);
    }

    /**
     * `AWS::OpsWorks::Stack.RdsDbInstances`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRdsDbInstances(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "rdsDbInstances", value);
    }

    /**
     * `AWS::OpsWorks::Stack.SourceStackId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceStackId() {
        return software.amazon.jsii.Kernel.get(this, "sourceStackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.SourceStackId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceStackId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceStackId", value);
    }

    /**
     * `AWS::OpsWorks::Stack.UseCustomCookbooks`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseCustomCookbooks() {
        return software.amazon.jsii.Kernel.get(this, "useCustomCookbooks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.UseCustomCookbooks`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseCustomCookbooks(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useCustomCookbooks", value);
    }

    /**
     * `AWS::OpsWorks::Stack.UseCustomCookbooks`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseCustomCookbooks(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useCustomCookbooks", value);
    }

    /**
     * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseOpsworksSecurityGroups() {
        return software.amazon.jsii.Kernel.get(this, "useOpsworksSecurityGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseOpsworksSecurityGroups(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useOpsworksSecurityGroups", value);
    }

    /**
     * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseOpsworksSecurityGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useOpsworksSecurityGroups", value);
    }

    /**
     * `AWS::OpsWorks::Stack.VpcId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::OpsWorks::Stack.VpcId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", value);
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.ChefConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ChefConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChefConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStack.ChefConfigurationProperty.BerkshelfVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBerkshelfVersion() {
            return null;
        }

        /**
         * `CfnStack.ChefConfigurationProperty.ManageBerkshelf`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManageBerkshelf() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChefConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChefConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChefConfigurationProperty> {
            private java.lang.String berkshelfVersion;
            private java.lang.Object manageBerkshelf;

            /**
             * Sets the value of {@link ChefConfigurationProperty#getBerkshelfVersion}
             * @param berkshelfVersion `CfnStack.ChefConfigurationProperty.BerkshelfVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder berkshelfVersion(java.lang.String berkshelfVersion) {
                this.berkshelfVersion = berkshelfVersion;
                return this;
            }

            /**
             * Sets the value of {@link ChefConfigurationProperty#getManageBerkshelf}
             * @param manageBerkshelf `CfnStack.ChefConfigurationProperty.ManageBerkshelf`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manageBerkshelf(java.lang.Boolean manageBerkshelf) {
                this.manageBerkshelf = manageBerkshelf;
                return this;
            }

            /**
             * Sets the value of {@link ChefConfigurationProperty#getManageBerkshelf}
             * @param manageBerkshelf `CfnStack.ChefConfigurationProperty.ManageBerkshelf`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manageBerkshelf(software.amazon.awscdk.IResolvable manageBerkshelf) {
                this.manageBerkshelf = manageBerkshelf;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChefConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChefConfigurationProperty build() {
                return new Jsii$Proxy(berkshelfVersion, manageBerkshelf);
            }
        }

        /**
         * An implementation for {@link ChefConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChefConfigurationProperty {
            private final java.lang.String berkshelfVersion;
            private final java.lang.Object manageBerkshelf;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.berkshelfVersion = software.amazon.jsii.Kernel.get(this, "berkshelfVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manageBerkshelf = software.amazon.jsii.Kernel.get(this, "manageBerkshelf", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String berkshelfVersion, final java.lang.Object manageBerkshelf) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.berkshelfVersion = berkshelfVersion;
                this.manageBerkshelf = manageBerkshelf;
            }

            @Override
            public final java.lang.String getBerkshelfVersion() {
                return this.berkshelfVersion;
            }

            @Override
            public final java.lang.Object getManageBerkshelf() {
                return this.manageBerkshelf;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBerkshelfVersion() != null) {
                    data.set("berkshelfVersion", om.valueToTree(this.getBerkshelfVersion()));
                }
                if (this.getManageBerkshelf() != null) {
                    data.set("manageBerkshelf", om.valueToTree(this.getManageBerkshelf()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.ChefConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChefConfigurationProperty.Jsii$Proxy that = (ChefConfigurationProperty.Jsii$Proxy) o;

                if (this.berkshelfVersion != null ? !this.berkshelfVersion.equals(that.berkshelfVersion) : that.berkshelfVersion != null) return false;
                return this.manageBerkshelf != null ? this.manageBerkshelf.equals(that.manageBerkshelf) : that.manageBerkshelf == null;
            }

            @Override
            public final int hashCode() {
                int result = this.berkshelfVersion != null ? this.berkshelfVersion.hashCode() : 0;
                result = 31 * result + (this.manageBerkshelf != null ? this.manageBerkshelf.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.ElasticIpProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticIpProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticIpProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStack.ElasticIpProperty.Ip`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIp();

        /**
         * `CfnStack.ElasticIpProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticIpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticIpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticIpProperty> {
            private java.lang.String ip;
            private java.lang.String name;

            /**
             * Sets the value of {@link ElasticIpProperty#getIp}
             * @param ip `CfnStack.ElasticIpProperty.Ip`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ip(java.lang.String ip) {
                this.ip = ip;
                return this;
            }

            /**
             * Sets the value of {@link ElasticIpProperty#getName}
             * @param name `CfnStack.ElasticIpProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticIpProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticIpProperty build() {
                return new Jsii$Proxy(ip, name);
            }
        }

        /**
         * An implementation for {@link ElasticIpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticIpProperty {
            private final java.lang.String ip;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ip = software.amazon.jsii.Kernel.get(this, "ip", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String ip, final java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ip = java.util.Objects.requireNonNull(ip, "ip is required");
                this.name = name;
            }

            @Override
            public final java.lang.String getIp() {
                return this.ip;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ip", om.valueToTree(this.getIp()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.ElasticIpProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticIpProperty.Jsii$Proxy that = (ElasticIpProperty.Jsii$Proxy) o;

                if (!ip.equals(that.ip)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ip.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.RdsDbInstanceProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsDbInstanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsDbInstanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStack.RdsDbInstanceProperty.DbPassword`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbPassword();

        /**
         * `CfnStack.RdsDbInstanceProperty.DbUser`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbUser();

        /**
         * `CfnStack.RdsDbInstanceProperty.RdsDbInstanceArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRdsDbInstanceArn();

        /**
         * @return a {@link Builder} of {@link RdsDbInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsDbInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsDbInstanceProperty> {
            private java.lang.String dbPassword;
            private java.lang.String dbUser;
            private java.lang.String rdsDbInstanceArn;

            /**
             * Sets the value of {@link RdsDbInstanceProperty#getDbPassword}
             * @param dbPassword `CfnStack.RdsDbInstanceProperty.DbPassword`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbPassword(java.lang.String dbPassword) {
                this.dbPassword = dbPassword;
                return this;
            }

            /**
             * Sets the value of {@link RdsDbInstanceProperty#getDbUser}
             * @param dbUser `CfnStack.RdsDbInstanceProperty.DbUser`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbUser(java.lang.String dbUser) {
                this.dbUser = dbUser;
                return this;
            }

            /**
             * Sets the value of {@link RdsDbInstanceProperty#getRdsDbInstanceArn}
             * @param rdsDbInstanceArn `CfnStack.RdsDbInstanceProperty.RdsDbInstanceArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsDbInstanceArn(java.lang.String rdsDbInstanceArn) {
                this.rdsDbInstanceArn = rdsDbInstanceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsDbInstanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsDbInstanceProperty build() {
                return new Jsii$Proxy(dbPassword, dbUser, rdsDbInstanceArn);
            }
        }

        /**
         * An implementation for {@link RdsDbInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsDbInstanceProperty {
            private final java.lang.String dbPassword;
            private final java.lang.String dbUser;
            private final java.lang.String rdsDbInstanceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dbPassword = software.amazon.jsii.Kernel.get(this, "dbPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbUser = software.amazon.jsii.Kernel.get(this, "dbUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rdsDbInstanceArn = software.amazon.jsii.Kernel.get(this, "rdsDbInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String dbPassword, final java.lang.String dbUser, final java.lang.String rdsDbInstanceArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dbPassword = java.util.Objects.requireNonNull(dbPassword, "dbPassword is required");
                this.dbUser = java.util.Objects.requireNonNull(dbUser, "dbUser is required");
                this.rdsDbInstanceArn = java.util.Objects.requireNonNull(rdsDbInstanceArn, "rdsDbInstanceArn is required");
            }

            @Override
            public final java.lang.String getDbPassword() {
                return this.dbPassword;
            }

            @Override
            public final java.lang.String getDbUser() {
                return this.dbUser;
            }

            @Override
            public final java.lang.String getRdsDbInstanceArn() {
                return this.rdsDbInstanceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dbPassword", om.valueToTree(this.getDbPassword()));
                data.set("dbUser", om.valueToTree(this.getDbUser()));
                data.set("rdsDbInstanceArn", om.valueToTree(this.getRdsDbInstanceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.RdsDbInstanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsDbInstanceProperty.Jsii$Proxy that = (RdsDbInstanceProperty.Jsii$Proxy) o;

                if (!dbPassword.equals(that.dbPassword)) return false;
                if (!dbUser.equals(that.dbUser)) return false;
                return this.rdsDbInstanceArn.equals(that.rdsDbInstanceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.dbPassword.hashCode();
                result = 31 * result + (this.dbUser.hashCode());
                result = 31 * result + (this.rdsDbInstanceArn.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStack.SourceProperty.Password`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * `CfnStack.SourceProperty.Revision`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRevision() {
            return null;
        }

        /**
         * `CfnStack.SourceProperty.SshKey`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSshKey() {
            return null;
        }

        /**
         * `CfnStack.SourceProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * `CfnStack.SourceProperty.Url`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * `CfnStack.SourceProperty.Username`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            private java.lang.String password;
            private java.lang.String revision;
            private java.lang.String sshKey;
            private java.lang.String type;
            private java.lang.String url;
            private java.lang.String username;

            /**
             * Sets the value of {@link SourceProperty#getPassword}
             * @param password `CfnStack.SourceProperty.Password`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getRevision}
             * @param revision `CfnStack.SourceProperty.Revision`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(java.lang.String revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSshKey}
             * @param sshKey `CfnStack.SourceProperty.SshKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sshKey(java.lang.String sshKey) {
                this.sshKey = sshKey;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getType}
             * @param type `CfnStack.SourceProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getUrl}
             * @param url `CfnStack.SourceProperty.Url`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getUsername}
             * @param username `CfnStack.SourceProperty.Username`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(password, revision, sshKey, type, url, username);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String password;
            private final java.lang.String revision;
            private final java.lang.String sshKey;
            private final java.lang.String type;
            private final java.lang.String url;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.revision = software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sshKey = software.amazon.jsii.Kernel.get(this, "sshKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String password, final java.lang.String revision, final java.lang.String sshKey, final java.lang.String type, final java.lang.String url, final java.lang.String username) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = password;
                this.revision = revision;
                this.sshKey = sshKey;
                this.type = type;
                this.url = url;
                this.username = username;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getRevision() {
                return this.revision;
            }

            @Override
            public final java.lang.String getSshKey() {
                return this.sshKey;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getRevision() != null) {
                    data.set("revision", om.valueToTree(this.getRevision()));
                }
                if (this.getSshKey() != null) {
                    data.set("sshKey", om.valueToTree(this.getSshKey()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) return false;
                if (this.sshKey != null ? !this.sshKey.equals(that.sshKey) : that.sshKey != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                if (this.url != null ? !this.url.equals(that.url) : that.url != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.password != null ? this.password.hashCode() : 0;
                result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
                result = 31 * result + (this.sshKey != null ? this.sshKey.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.StackConfigurationManagerProperty")
    @software.amazon.jsii.Jsii.Proxy(StackConfigurationManagerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StackConfigurationManagerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStack.StackConfigurationManagerProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * `CfnStack.StackConfigurationManagerProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StackConfigurationManagerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StackConfigurationManagerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StackConfigurationManagerProperty> {
            private java.lang.String name;
            private java.lang.String version;

            /**
             * Sets the value of {@link StackConfigurationManagerProperty#getName}
             * @param name `CfnStack.StackConfigurationManagerProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StackConfigurationManagerProperty#getVersion}
             * @param version `CfnStack.StackConfigurationManagerProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StackConfigurationManagerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StackConfigurationManagerProperty build() {
                return new Jsii$Proxy(name, version);
            }
        }

        /**
         * An implementation for {@link StackConfigurationManagerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackConfigurationManagerProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String name, final java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = name;
                this.version = version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.StackConfigurationManagerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StackConfigurationManagerProperty.Jsii$Proxy that = (StackConfigurationManagerProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.opsworks.CfnStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.opsworks.CfnStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.opsworks.CfnStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.opsworks.CfnStackProps.Builder();
        }

        /**
         * `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`.
         * <p>
         * @return {@code this}
         * @param defaultInstanceProfileArn `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceProfileArn(final java.lang.String defaultInstanceProfileArn) {
            this.props.defaultInstanceProfileArn(defaultInstanceProfileArn);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::OpsWorks::Stack.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.ServiceRoleArn`.
         * <p>
         * @return {@code this}
         * @param serviceRoleArn `AWS::OpsWorks::Stack.ServiceRoleArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(final java.lang.String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.AgentVersion`.
         * <p>
         * @return {@code this}
         * @param agentVersion `AWS::OpsWorks::Stack.AgentVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentVersion(final java.lang.String agentVersion) {
            this.props.agentVersion(agentVersion);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.Attributes`.
         * <p>
         * @return {@code this}
         * @param attributes `AWS::OpsWorks::Stack.Attributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.IResolvable attributes) {
            this.props.attributes(attributes);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.Attributes`.
         * <p>
         * @return {@code this}
         * @param attributes `AWS::OpsWorks::Stack.Attributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.props.attributes(attributes);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.ChefConfiguration`.
         * <p>
         * @return {@code this}
         * @param chefConfiguration `AWS::OpsWorks::Stack.ChefConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chefConfiguration(final software.amazon.awscdk.services.opsworks.CfnStack.ChefConfigurationProperty chefConfiguration) {
            this.props.chefConfiguration(chefConfiguration);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.ChefConfiguration`.
         * <p>
         * @return {@code this}
         * @param chefConfiguration `AWS::OpsWorks::Stack.ChefConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chefConfiguration(final software.amazon.awscdk.IResolvable chefConfiguration) {
            this.props.chefConfiguration(chefConfiguration);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.CloneAppIds`.
         * <p>
         * @return {@code this}
         * @param cloneAppIds `AWS::OpsWorks::Stack.CloneAppIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneAppIds(final java.util.List<java.lang.String> cloneAppIds) {
            this.props.cloneAppIds(cloneAppIds);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.ClonePermissions`.
         * <p>
         * @return {@code this}
         * @param clonePermissions `AWS::OpsWorks::Stack.ClonePermissions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clonePermissions(final java.lang.Boolean clonePermissions) {
            this.props.clonePermissions(clonePermissions);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.ClonePermissions`.
         * <p>
         * @return {@code this}
         * @param clonePermissions `AWS::OpsWorks::Stack.ClonePermissions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clonePermissions(final software.amazon.awscdk.IResolvable clonePermissions) {
            this.props.clonePermissions(clonePermissions);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.ConfigurationManager`.
         * <p>
         * @return {@code this}
         * @param configurationManager `AWS::OpsWorks::Stack.ConfigurationManager`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationManager(final software.amazon.awscdk.services.opsworks.CfnStack.StackConfigurationManagerProperty configurationManager) {
            this.props.configurationManager(configurationManager);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.ConfigurationManager`.
         * <p>
         * @return {@code this}
         * @param configurationManager `AWS::OpsWorks::Stack.ConfigurationManager`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationManager(final software.amazon.awscdk.IResolvable configurationManager) {
            this.props.configurationManager(configurationManager);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.CustomCookbooksSource`.
         * <p>
         * @return {@code this}
         * @param customCookbooksSource `AWS::OpsWorks::Stack.CustomCookbooksSource`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCookbooksSource(final software.amazon.awscdk.services.opsworks.CfnStack.SourceProperty customCookbooksSource) {
            this.props.customCookbooksSource(customCookbooksSource);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.CustomCookbooksSource`.
         * <p>
         * @return {@code this}
         * @param customCookbooksSource `AWS::OpsWorks::Stack.CustomCookbooksSource`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCookbooksSource(final software.amazon.awscdk.IResolvable customCookbooksSource) {
            this.props.customCookbooksSource(customCookbooksSource);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.CustomJson`.
         * <p>
         * @return {@code this}
         * @param customJson `AWS::OpsWorks::Stack.CustomJson`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customJson(final java.lang.Object customJson) {
            this.props.customJson(customJson);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.DefaultAvailabilityZone`.
         * <p>
         * @return {@code this}
         * @param defaultAvailabilityZone `AWS::OpsWorks::Stack.DefaultAvailabilityZone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAvailabilityZone(final java.lang.String defaultAvailabilityZone) {
            this.props.defaultAvailabilityZone(defaultAvailabilityZone);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.DefaultOs`.
         * <p>
         * @return {@code this}
         * @param defaultOs `AWS::OpsWorks::Stack.DefaultOs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultOs(final java.lang.String defaultOs) {
            this.props.defaultOs(defaultOs);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.DefaultRootDeviceType`.
         * <p>
         * @return {@code this}
         * @param defaultRootDeviceType `AWS::OpsWorks::Stack.DefaultRootDeviceType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRootDeviceType(final java.lang.String defaultRootDeviceType) {
            this.props.defaultRootDeviceType(defaultRootDeviceType);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.DefaultSshKeyName`.
         * <p>
         * @return {@code this}
         * @param defaultSshKeyName `AWS::OpsWorks::Stack.DefaultSshKeyName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSshKeyName(final java.lang.String defaultSshKeyName) {
            this.props.defaultSshKeyName(defaultSshKeyName);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.DefaultSubnetId`.
         * <p>
         * @return {@code this}
         * @param defaultSubnetId `AWS::OpsWorks::Stack.DefaultSubnetId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSubnetId(final java.lang.String defaultSubnetId) {
            this.props.defaultSubnetId(defaultSubnetId);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.EcsClusterArn`.
         * <p>
         * @return {@code this}
         * @param ecsClusterArn `AWS::OpsWorks::Stack.EcsClusterArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsClusterArn(final java.lang.String ecsClusterArn) {
            this.props.ecsClusterArn(ecsClusterArn);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.ElasticIps`.
         * <p>
         * @return {@code this}
         * @param elasticIps `AWS::OpsWorks::Stack.ElasticIps`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIps(final software.amazon.awscdk.IResolvable elasticIps) {
            this.props.elasticIps(elasticIps);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.ElasticIps`.
         * <p>
         * @return {@code this}
         * @param elasticIps `AWS::OpsWorks::Stack.ElasticIps`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIps(final java.util.List<? extends java.lang.Object> elasticIps) {
            this.props.elasticIps(elasticIps);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.HostnameTheme`.
         * <p>
         * @return {@code this}
         * @param hostnameTheme `AWS::OpsWorks::Stack.HostnameTheme`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostnameTheme(final java.lang.String hostnameTheme) {
            this.props.hostnameTheme(hostnameTheme);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.RdsDbInstances`.
         * <p>
         * @return {@code this}
         * @param rdsDbInstances `AWS::OpsWorks::Stack.RdsDbInstances`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsDbInstances(final software.amazon.awscdk.IResolvable rdsDbInstances) {
            this.props.rdsDbInstances(rdsDbInstances);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.RdsDbInstances`.
         * <p>
         * @return {@code this}
         * @param rdsDbInstances `AWS::OpsWorks::Stack.RdsDbInstances`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsDbInstances(final java.util.List<? extends java.lang.Object> rdsDbInstances) {
            this.props.rdsDbInstances(rdsDbInstances);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.SourceStackId`.
         * <p>
         * @return {@code this}
         * @param sourceStackId `AWS::OpsWorks::Stack.SourceStackId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceStackId(final java.lang.String sourceStackId) {
            this.props.sourceStackId(sourceStackId);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::OpsWorks::Stack.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.UseCustomCookbooks`.
         * <p>
         * @return {@code this}
         * @param useCustomCookbooks `AWS::OpsWorks::Stack.UseCustomCookbooks`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCustomCookbooks(final java.lang.Boolean useCustomCookbooks) {
            this.props.useCustomCookbooks(useCustomCookbooks);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.UseCustomCookbooks`.
         * <p>
         * @return {@code this}
         * @param useCustomCookbooks `AWS::OpsWorks::Stack.UseCustomCookbooks`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCustomCookbooks(final software.amazon.awscdk.IResolvable useCustomCookbooks) {
            this.props.useCustomCookbooks(useCustomCookbooks);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`.
         * <p>
         * @return {@code this}
         * @param useOpsworksSecurityGroups `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOpsworksSecurityGroups(final java.lang.Boolean useOpsworksSecurityGroups) {
            this.props.useOpsworksSecurityGroups(useOpsworksSecurityGroups);
            return this;
        }
        /**
         * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`.
         * <p>
         * @return {@code this}
         * @param useOpsworksSecurityGroups `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOpsworksSecurityGroups(final software.amazon.awscdk.IResolvable useOpsworksSecurityGroups) {
            this.props.useOpsworksSecurityGroups(useOpsworksSecurityGroups);
            return this;
        }

        /**
         * `AWS::OpsWorks::Stack.VpcId`.
         * <p>
         * @return {@code this}
         * @param vpcId `AWS::OpsWorks::Stack.VpcId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.opsworks.CfnStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.opsworks.CfnStack build() {
            return new software.amazon.awscdk.services.opsworks.CfnStack(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
