package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:35.737Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBCluster")
public class CfnDBCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReadEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrReadEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::RDS::DBCluster.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::RDS::DBCluster.Engine`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.Engine`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", java.util.Objects.requireNonNull(value, "engine is required"));
    }

    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZones(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZones", value);
    }

    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBacktrackWindow() {
        return software.amazon.jsii.Kernel.get(this, "backtrackWindow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBacktrackWindow(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backtrackWindow", value);
    }

    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backupRetentionPeriod", value);
    }

    /**
     * `AWS::RDS::DBCluster.CopyTagsToSnapshot`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.CopyTagsToSnapshot`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * `AWS::RDS::DBCluster.CopyTagsToSnapshot`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * `AWS::RDS::DBCluster.DatabaseName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.DatabaseName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifier", value);
    }

    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterParameterGroupName", value);
    }

    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSubnetGroupName", value);
    }

    /**
     * `AWS::RDS::DBCluster.DeletionProtection`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.DeletionProtection`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * `AWS::RDS::DBCluster.DeletionProtection`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableCloudwatchLogsExports(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "enableCloudwatchLogsExports", value);
    }

    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableHttpEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "enableHttpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableHttpEndpoint(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableHttpEndpoint", value);
    }

    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableHttpEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableHttpEndpoint", value);
    }

    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * `AWS::RDS::DBCluster.EngineMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineMode() {
        return software.amazon.jsii.Kernel.get(this, "engineMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.EngineMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineMode", value);
    }

    /**
     * `AWS::RDS::DBCluster.EngineVersion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.EngineVersion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * `AWS::RDS::DBCluster.GlobalClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlobalClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.GlobalClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "globalClusterIdentifier", value);
    }

    /**
     * `AWS::RDS::DBCluster.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * `AWS::RDS::DBCluster.MasterUsername`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.MasterUsername`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", value);
    }

    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", value);
    }

    /**
     * `AWS::RDS::DBCluster.Port`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::RDS::DBCluster.Port`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReplicationSourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "replicationSourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationSourceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicationSourceIdentifier", value);
    }

    /**
     * `AWS::RDS::DBCluster.RestoreType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRestoreType() {
        return software.amazon.jsii.Kernel.get(this, "restoreType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.RestoreType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restoreType", value);
    }

    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotIdentifier", value);
    }

    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbClusterIdentifier", value);
    }

    /**
     * `AWS::RDS::DBCluster.SourceRegion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::RDS::DBCluster.SourceRegion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceRegion", value);
    }

    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroupIds", value);
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBCluster.DBClusterRoleProperty")
    @software.amazon.jsii.Jsii.Proxy(DBClusterRoleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DBClusterRoleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDBCluster.DBClusterRoleProperty.RoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * `CfnDBCluster.DBClusterRoleProperty.FeatureName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFeatureName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DBClusterRoleProperty> {
            private java.lang.String roleArn;
            private java.lang.String featureName;

            /**
             * Sets the value of {@link DBClusterRoleProperty#getRoleArn}
             * @param roleArn `CfnDBCluster.DBClusterRoleProperty.RoleArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DBClusterRoleProperty#getFeatureName}
             * @param featureName `CfnDBCluster.DBClusterRoleProperty.FeatureName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureName(java.lang.String featureName) {
                this.featureName = featureName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DBClusterRoleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DBClusterRoleProperty build() {
                return new Jsii$Proxy(roleArn, featureName);
            }
        }

        /**
         * An implementation for {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBClusterRoleProperty {
            private final java.lang.String roleArn;
            private final java.lang.String featureName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureName = software.amazon.jsii.Kernel.get(this, "featureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String roleArn, final java.lang.String featureName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
                this.featureName = featureName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getFeatureName() {
                return this.featureName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getFeatureName() != null) {
                    data.set("featureName", om.valueToTree(this.getFeatureName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBCluster.DBClusterRoleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DBClusterRoleProperty.Jsii$Proxy that = (DBClusterRoleProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.featureName != null ? this.featureName.equals(that.featureName) : that.featureName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.featureName != null ? this.featureName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBCluster.ScalingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDBCluster.ScalingConfigurationProperty.AutoPause`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoPause() {
            return null;
        }

        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MaxCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MinCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
            return null;
        }

        /**
         * `CfnDBCluster.ScalingConfigurationProperty.SecondsUntilAutoPause`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondsUntilAutoPause() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConfigurationProperty> {
            private java.lang.Object autoPause;
            private java.lang.Number maxCapacity;
            private java.lang.Number minCapacity;
            private java.lang.Number secondsUntilAutoPause;

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getAutoPause}
             * @param autoPause `CfnDBCluster.ScalingConfigurationProperty.AutoPause`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoPause(java.lang.Boolean autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getAutoPause}
             * @param autoPause `CfnDBCluster.ScalingConfigurationProperty.AutoPause`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoPause(software.amazon.awscdk.IResolvable autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getMaxCapacity}
             * @param maxCapacity `CfnDBCluster.ScalingConfigurationProperty.MaxCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getMinCapacity}
             * @param minCapacity `CfnDBCluster.ScalingConfigurationProperty.MinCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getSecondsUntilAutoPause}
             * @param secondsUntilAutoPause `CfnDBCluster.ScalingConfigurationProperty.SecondsUntilAutoPause`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondsUntilAutoPause(java.lang.Number secondsUntilAutoPause) {
                this.secondsUntilAutoPause = secondsUntilAutoPause;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingConfigurationProperty build() {
                return new Jsii$Proxy(autoPause, maxCapacity, minCapacity, secondsUntilAutoPause);
            }
        }

        /**
         * An implementation for {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConfigurationProperty {
            private final java.lang.Object autoPause;
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;
            private final java.lang.Number secondsUntilAutoPause;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoPause = software.amazon.jsii.Kernel.get(this, "autoPause", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secondsUntilAutoPause = software.amazon.jsii.Kernel.get(this, "secondsUntilAutoPause", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object autoPause, final java.lang.Number maxCapacity, final java.lang.Number minCapacity, final java.lang.Number secondsUntilAutoPause) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoPause = autoPause;
                this.maxCapacity = maxCapacity;
                this.minCapacity = minCapacity;
                this.secondsUntilAutoPause = secondsUntilAutoPause;
            }

            @Override
            public final java.lang.Object getAutoPause() {
                return this.autoPause;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public final java.lang.Number getSecondsUntilAutoPause() {
                return this.secondsUntilAutoPause;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoPause() != null) {
                    data.set("autoPause", om.valueToTree(this.getAutoPause()));
                }
                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getMinCapacity() != null) {
                    data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                }
                if (this.getSecondsUntilAutoPause() != null) {
                    data.set("secondsUntilAutoPause", om.valueToTree(this.getSecondsUntilAutoPause()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBCluster.ScalingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConfigurationProperty.Jsii$Proxy that = (ScalingConfigurationProperty.Jsii$Proxy) o;

                if (this.autoPause != null ? !this.autoPause.equals(that.autoPause) : that.autoPause != null) return false;
                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
                return this.secondsUntilAutoPause != null ? this.secondsUntilAutoPause.equals(that.secondsUntilAutoPause) : that.secondsUntilAutoPause == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoPause != null ? this.autoPause.hashCode() : 0;
                result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
                result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
                result = 31 * result + (this.secondsUntilAutoPause != null ? this.secondsUntilAutoPause.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBClusterProps.Builder();
        }

        /**
         * `AWS::RDS::DBCluster.Engine`.
         * <p>
         * @return {@code this}
         * @param engine `AWS::RDS::DBCluster.Engine`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.AssociatedRoles`.
         * <p>
         * @return {@code this}
         * @param associatedRoles `AWS::RDS::DBCluster.AssociatedRoles`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final software.amazon.awscdk.IResolvable associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.AssociatedRoles`.
         * <p>
         * @return {@code this}
         * @param associatedRoles `AWS::RDS::DBCluster.AssociatedRoles`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final java.util.List<? extends java.lang.Object> associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.AvailabilityZones`.
         * <p>
         * @return {@code this}
         * @param availabilityZones `AWS::RDS::DBCluster.AvailabilityZones`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(final java.util.List<java.lang.String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.BacktrackWindow`.
         * <p>
         * @return {@code this}
         * @param backtrackWindow `AWS::RDS::DBCluster.BacktrackWindow`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(final java.lang.Number backtrackWindow) {
            this.props.backtrackWindow(backtrackWindow);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.BackupRetentionPeriod`.
         * <p>
         * @return {@code this}
         * @param backupRetentionPeriod `AWS::RDS::DBCluster.BackupRetentionPeriod`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(final java.lang.Number backupRetentionPeriod) {
            this.props.backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.CopyTagsToSnapshot`.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot `AWS::RDS::DBCluster.CopyTagsToSnapshot`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.CopyTagsToSnapshot`.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot `AWS::RDS::DBCluster.CopyTagsToSnapshot`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.DatabaseName`.
         * <p>
         * @return {@code this}
         * @param databaseName `AWS::RDS::DBCluster.DatabaseName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.DBClusterIdentifier`.
         * <p>
         * @return {@code this}
         * @param dbClusterIdentifier `AWS::RDS::DBCluster.DBClusterIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(final java.lang.String dbClusterIdentifier) {
            this.props.dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.DBClusterParameterGroupName`.
         * <p>
         * @return {@code this}
         * @param dbClusterParameterGroupName `AWS::RDS::DBCluster.DBClusterParameterGroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterParameterGroupName(final java.lang.String dbClusterParameterGroupName) {
            this.props.dbClusterParameterGroupName(dbClusterParameterGroupName);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.DBSubnetGroupName`.
         * <p>
         * @return {@code this}
         * @param dbSubnetGroupName `AWS::RDS::DBCluster.DBSubnetGroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(final java.lang.String dbSubnetGroupName) {
            this.props.dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.DeletionProtection`.
         * <p>
         * @return {@code this}
         * @param deletionProtection `AWS::RDS::DBCluster.DeletionProtection`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.DeletionProtection`.
         * <p>
         * @return {@code this}
         * @param deletionProtection `AWS::RDS::DBCluster.DeletionProtection`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`.
         * <p>
         * @return {@code this}
         * @param enableCloudwatchLogsExports `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(final java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.props.enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
         * <p>
         * @return {@code this}
         * @param enableHttpEndpoint `AWS::RDS::DBCluster.EnableHttpEndpoint`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(final java.lang.Boolean enableHttpEndpoint) {
            this.props.enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
         * <p>
         * @return {@code this}
         * @param enableHttpEndpoint `AWS::RDS::DBCluster.EnableHttpEndpoint`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(final software.amazon.awscdk.IResolvable enableHttpEndpoint) {
            this.props.enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final java.lang.Boolean enableIamDatabaseAuthentication) {
            this.props.enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final software.amazon.awscdk.IResolvable enableIamDatabaseAuthentication) {
            this.props.enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.EngineMode`.
         * <p>
         * @return {@code this}
         * @param engineMode `AWS::RDS::DBCluster.EngineMode`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineMode(final java.lang.String engineMode) {
            this.props.engineMode(engineMode);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.EngineVersion`.
         * <p>
         * @return {@code this}
         * @param engineVersion `AWS::RDS::DBCluster.EngineVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.GlobalClusterIdentifier`.
         * <p>
         * @return {@code this}
         * @param globalClusterIdentifier `AWS::RDS::DBCluster.GlobalClusterIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalClusterIdentifier(final java.lang.String globalClusterIdentifier) {
            this.props.globalClusterIdentifier(globalClusterIdentifier);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.KmsKeyId`.
         * <p>
         * @return {@code this}
         * @param kmsKeyId `AWS::RDS::DBCluster.KmsKeyId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.MasterUsername`.
         * <p>
         * @return {@code this}
         * @param masterUsername `AWS::RDS::DBCluster.MasterUsername`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props.masterUsername(masterUsername);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.MasterUserPassword`.
         * <p>
         * @return {@code this}
         * @param masterUserPassword `AWS::RDS::DBCluster.MasterUserPassword`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props.masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.Port`.
         * <p>
         * @return {@code this}
         * @param port `AWS::RDS::DBCluster.Port`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.PreferredBackupWindow`.
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow `AWS::RDS::DBCluster.PreferredBackupWindow`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`.
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow `AWS::RDS::DBCluster.PreferredMaintenanceWindow`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`.
         * <p>
         * @return {@code this}
         * @param replicationSourceIdentifier `AWS::RDS::DBCluster.ReplicationSourceIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSourceIdentifier(final java.lang.String replicationSourceIdentifier) {
            this.props.replicationSourceIdentifier(replicationSourceIdentifier);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.RestoreType`.
         * <p>
         * @return {@code this}
         * @param restoreType `AWS::RDS::DBCluster.RestoreType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreType(final java.lang.String restoreType) {
            this.props.restoreType(restoreType);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.ScalingConfiguration`.
         * <p>
         * @return {@code this}
         * @param scalingConfiguration `AWS::RDS::DBCluster.ScalingConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty scalingConfiguration) {
            this.props.scalingConfiguration(scalingConfiguration);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.ScalingConfiguration`.
         * <p>
         * @return {@code this}
         * @param scalingConfiguration `AWS::RDS::DBCluster.ScalingConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.IResolvable scalingConfiguration) {
            this.props.scalingConfiguration(scalingConfiguration);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.SnapshotIdentifier`.
         * <p>
         * @return {@code this}
         * @param snapshotIdentifier `AWS::RDS::DBCluster.SnapshotIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(final java.lang.String snapshotIdentifier) {
            this.props.snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`.
         * <p>
         * @return {@code this}
         * @param sourceDbClusterIdentifier `AWS::RDS::DBCluster.SourceDBClusterIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(final java.lang.String sourceDbClusterIdentifier) {
            this.props.sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.SourceRegion`.
         * <p>
         * @return {@code this}
         * @param sourceRegion `AWS::RDS::DBCluster.SourceRegion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(final java.lang.String sourceRegion) {
            this.props.sourceRegion(sourceRegion);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.StorageEncrypted`.
         * <p>
         * @return {@code this}
         * @param storageEncrypted `AWS::RDS::DBCluster.StorageEncrypted`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.StorageEncrypted`.
         * <p>
         * @return {@code this}
         * @param storageEncrypted `AWS::RDS::DBCluster.StorageEncrypted`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final software.amazon.awscdk.IResolvable storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::RDS::DBCluster.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
         * <p>
         * @return {@code this}
         * @param useLatestRestorableTime `AWS::RDS::DBCluster.UseLatestRestorableTime`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final java.lang.Boolean useLatestRestorableTime) {
            this.props.useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }
        /**
         * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
         * <p>
         * @return {@code this}
         * @param useLatestRestorableTime `AWS::RDS::DBCluster.UseLatestRestorableTime`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final software.amazon.awscdk.IResolvable useLatestRestorableTime) {
            this.props.useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        /**
         * `AWS::RDS::DBCluster.VpcSecurityGroupIds`.
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroupIds `AWS::RDS::DBCluster.VpcSecurityGroupIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(final java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBCluster build() {
            return new software.amazon.awscdk.services.rds.CfnDBCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
