package software.amazon.awscdk.services.rds;

/**
 * (experimental) Properties for a new database cluster.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:35.770Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseClusterProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DatabaseClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) What kind of database to start.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine getEngine();

    /**
     * (experimental) Settings for the individual instances that are launched.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceProps getInstanceProps();

    /**
     * (experimental) Backup settings.
     * <p>
     * Default: - Backup retention period for automated backups is 1 day.
     * Backup preferred window is set to a 30-minute window selected at random from an
     * 8-hour block of time for each AWS Region, occurring on a random day of the week.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.BackupProps getBackup() {
        return null;
    }

    /**
     * (experimental) The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * Default: - no log exports
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCloudwatchLogsExports() {
        return null;
    }

    /**
     * (experimental) The number of days log events are kept in CloudWatch Logs.
     * <p>
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>Infinity</code>.
     * <p>
     * Default: - logs never expire
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getCloudwatchLogsRetention() {
        return null;
    }

    /**
     * (experimental) The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * <p>
     * Default: - a new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCloudwatchLogsRetentionRole() {
        return null;
    }

    /**
     * (experimental) An optional identifier for the cluster.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterIdentifier() {
        return null;
    }

    /**
     * (experimental) Credentials for the administrative user.
     * <p>
     * Default: - A username of 'admin' (or 'postgres' for PostgreSQL) and SecretsManager-generated password
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.Credentials getCredentials() {
        return null;
    }

    /**
     * (experimental) Name of a database which is automatically created inside the cluster.
     * <p>
     * Default: - Database is not created in cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultDatabaseName() {
        return null;
    }

    /**
     * (experimental) Indicates whether the DB cluster should have deletion protection enabled.
     * <p>
     * Default: - true if ``removalPolicy`` is RETAIN, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeletionProtection() {
        return null;
    }

    /**
     * (experimental) Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIamAuthentication() {
        return null;
    }

    /**
     * (experimental) Base identifier for instances.
     * <p>
     * Every replica is named by appending the replica number to this string, 1-based.
     * <p>
     * Default: - clusterIdentifier is used with the word "Instance" appended.
     * If clusterIdentifier is not provided, the identifier is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceIdentifierBase() {
        return null;
    }

    /**
     * (experimental) How many replicas/instances to create.
     * <p>
     * Has to be at least 1.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInstances() {
        return null;
    }

    /**
     * (experimental) The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances.
     * <p>
     * Default: no enhanced monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMonitoringInterval() {
        return null;
    }

    /**
     * (experimental) Role that will be used to manage DB instances monitoring.
     * <p>
     * Default: - A role is automatically created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
        return null;
    }

    /**
     * (experimental) Additional parameters to pass to the database engine.
     * <p>
     * Default: - No parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * (experimental) What port to listen on.
     * <p>
     * Default: - The default for the engine is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
     * <p>
     * Example: 'Sun:23:45-Mon:00:15'
     * <p>
     * Default: - 30-minute window selected at random from an 8-hour block of time for
     * each AWS Region, occurring on a random day of the week.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * (experimental) The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
     * <p>
     * Default: - RemovalPolicy.SNAPSHOT (remove the cluster and instances, but retain a snapshot of the data)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ExportRole</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - None
     * <p>
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ExportBuckets() {
        return null;
    }

    /**
     * (experimental) Role that will be associated with this DB cluster to enable S3 export.
     * <p>
     * This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ExportBuckets</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - New role is created if `s3ExportBuckets` is set, no role is defined otherwise
     * <p>
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
        return null;
    }

    /**
     * (experimental) S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ImportRole</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - None
     * <p>
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ImportBuckets() {
        return null;
    }

    /**
     * (experimental) Role that will be associated with this DB cluster to enable S3 import.
     * <p>
     * This feature is only supported by the Aurora database engine.
     * <p>
     * This property must not be used if <code>s3ImportBuckets</code> is used.
     * <p>
     * For MySQL:
     * <p>
     * Default: - New role is created if `s3ImportBuckets` is set, no role is defined otherwise
     * <p>
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
        return null;
    }

    /**
     * (experimental) Whether to enable storage encryption.
     * <p>
     * Default: - true if storageEncryptionKey is provided, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStorageEncrypted() {
        return null;
    }

    /**
     * (experimental) The KMS key for storage encryption.
     * <p>
     * If specified, {&#64;link storageEncrypted} will be set to <code>true</code>.
     * <p>
     * Default: - if storageEncrypted is true then the default master key, no key otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getStorageEncryptionKey() {
        return null;
    }

    /**
     * (experimental) Existing subnet group for the cluster.
     * <p>
     * Default: - a new subnet group will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseClusterProps> {
        private software.amazon.awscdk.services.rds.IClusterEngine engine;
        private software.amazon.awscdk.services.rds.InstanceProps instanceProps;
        private software.amazon.awscdk.services.rds.BackupProps backup;
        private java.util.List<java.lang.String> cloudwatchLogsExports;
        private software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        private software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        private java.lang.String clusterIdentifier;
        private software.amazon.awscdk.services.rds.Credentials credentials;
        private java.lang.String defaultDatabaseName;
        private java.lang.Boolean deletionProtection;
        private java.lang.Boolean iamAuthentication;
        private java.lang.String instanceIdentifierBase;
        private java.lang.Number instances;
        private software.amazon.awscdk.Duration monitoringInterval;
        private software.amazon.awscdk.services.iam.IRole monitoringRole;
        private software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        private java.lang.Number port;
        private java.lang.String preferredMaintenanceWindow;
        private software.amazon.awscdk.RemovalPolicy removalPolicy;
        private java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        private software.amazon.awscdk.services.iam.IRole s3ExportRole;
        private java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        private software.amazon.awscdk.services.iam.IRole s3ImportRole;
        private java.lang.Boolean storageEncrypted;
        private software.amazon.awscdk.services.kms.IKey storageEncryptionKey;
        private software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;

        /**
         * Sets the value of {@link DatabaseClusterProps#getEngine}
         * @param engine What kind of database to start. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder engine(software.amazon.awscdk.services.rds.IClusterEngine engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstanceProps}
         * @param instanceProps Settings for the individual instances that are launched. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceProps(software.amazon.awscdk.services.rds.InstanceProps instanceProps) {
            this.instanceProps = instanceProps;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getBackup}
         * @param backup Backup settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backup(software.amazon.awscdk.services.rds.BackupProps backup) {
            this.backup = backup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCloudwatchLogsExports}
         * @param cloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudwatchLogsExports(java.util.List<java.lang.String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCloudwatchLogsRetention}
         * @param cloudwatchLogsRetention The number of days log events are kept in CloudWatch Logs.
         *                                When updating
         *                                this property, unsetting it doesn't remove the log retention policy. To
         *                                remove the retention policy, set the value to <code>Infinity</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudwatchLogsRetention(software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCloudwatchLogsRetentionRole}
         * @param cloudwatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudwatchLogsRetentionRole(software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getClusterIdentifier}
         * @param clusterIdentifier An optional identifier for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCredentials}
         * @param credentials Credentials for the administrative user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder credentials(software.amazon.awscdk.services.rds.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getDefaultDatabaseName}
         * @param defaultDatabaseName Name of a database which is automatically created inside the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultDatabaseName(java.lang.String defaultDatabaseName) {
            this.defaultDatabaseName = defaultDatabaseName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getDeletionProtection}
         * @param deletionProtection Indicates whether the DB cluster should have deletion protection enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getIamAuthentication}
         * @param iamAuthentication Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iamAuthentication(java.lang.Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstanceIdentifierBase}
         * @param instanceIdentifierBase Base identifier for instances.
         *                               Every replica is named by appending the replica number to this string, 1-based.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceIdentifierBase(java.lang.String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstances}
         * @param instances How many replicas/instances to create.
         *                  Has to be at least 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instances(java.lang.Number instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getMonitoringInterval}
         * @param monitoringInterval The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder monitoringInterval(software.amazon.awscdk.Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getMonitoringRole}
         * @param monitoringRole Role that will be used to manage DB instances monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder monitoringRole(software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getParameterGroup}
         * @param parameterGroup Additional parameters to pass to the database engine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroup(software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getPort}
         * @param port What port to listen on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
         *                                   Example: 'Sun:23:45-Mon:00:15'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getS3ExportBuckets}
         * @param s3ExportBuckets S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine.
         *                        This property must not be used if <code>s3ExportRole</code> is used.
         *                        <p>
         *                        For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder s3ExportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets) {
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ExportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getS3ExportRole}
         * @param s3ExportRole Role that will be associated with this DB cluster to enable S3 export.
         *                     This feature is only supported by the Aurora database engine.
         *                     <p>
         *                     This property must not be used if <code>s3ExportBuckets</code> is used.
         *                     <p>
         *                     For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3ExportRole(software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getS3ImportBuckets}
         * @param s3ImportBuckets S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine.
         *                        This property must not be used if <code>s3ImportRole</code> is used.
         *                        <p>
         *                        For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder s3ImportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets) {
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ImportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getS3ImportRole}
         * @param s3ImportRole Role that will be associated with this DB cluster to enable S3 import.
         *                     This feature is only supported by the Aurora database engine.
         *                     <p>
         *                     This property must not be used if <code>s3ImportBuckets</code> is used.
         *                     <p>
         *                     For MySQL:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3ImportRole(software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getStorageEncrypted}
         * @param storageEncrypted Whether to enable storage encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getStorageEncryptionKey}
         * @param storageEncryptionKey The KMS key for storage encryption.
         *                             If specified, {&#64;link storageEncrypted} will be set to <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageEncryptionKey(software.amazon.awscdk.services.kms.IKey storageEncryptionKey) {
            this.storageEncryptionKey = storageEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getSubnetGroup}
         * @param subnetGroup Existing subnet group for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetGroup(software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DatabaseClusterProps build() {
            return new Jsii$Proxy(engine, instanceProps, backup, cloudwatchLogsExports, cloudwatchLogsRetention, cloudwatchLogsRetentionRole, clusterIdentifier, credentials, defaultDatabaseName, deletionProtection, iamAuthentication, instanceIdentifierBase, instances, monitoringInterval, monitoringRole, parameterGroup, port, preferredMaintenanceWindow, removalPolicy, s3ExportBuckets, s3ExportRole, s3ImportBuckets, s3ImportRole, storageEncrypted, storageEncryptionKey, subnetGroup);
        }
    }

    /**
     * An implementation for {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseClusterProps {
        private final software.amazon.awscdk.services.rds.IClusterEngine engine;
        private final software.amazon.awscdk.services.rds.InstanceProps instanceProps;
        private final software.amazon.awscdk.services.rds.BackupProps backup;
        private final java.util.List<java.lang.String> cloudwatchLogsExports;
        private final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        private final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        private final java.lang.String clusterIdentifier;
        private final software.amazon.awscdk.services.rds.Credentials credentials;
        private final java.lang.String defaultDatabaseName;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.Boolean iamAuthentication;
        private final java.lang.String instanceIdentifierBase;
        private final java.lang.Number instances;
        private final software.amazon.awscdk.Duration monitoringInterval;
        private final software.amazon.awscdk.services.iam.IRole monitoringRole;
        private final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        private final java.lang.Number port;
        private final java.lang.String preferredMaintenanceWindow;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ExportRole;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ImportRole;
        private final java.lang.Boolean storageEncrypted;
        private final software.amazon.awscdk.services.kms.IKey storageEncryptionKey;
        private final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
            this.instanceProps = software.amazon.jsii.Kernel.get(this, "instanceProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.InstanceProps.class));
            this.backup = software.amazon.jsii.Kernel.get(this, "backup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.BackupProps.class));
            this.cloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cloudwatchLogsRetention = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.cloudwatchLogsRetentionRole = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetentionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Credentials.class));
            this.defaultDatabaseName = software.amazon.jsii.Kernel.get(this, "defaultDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.iamAuthentication = software.amazon.jsii.Kernel.get(this, "iamAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceIdentifierBase = software.amazon.jsii.Kernel.get(this, "instanceIdentifierBase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.monitoringInterval = software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.monitoringRole = software.amazon.jsii.Kernel.get(this, "monitoringRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IParameterGroup.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.s3ExportBuckets = software.amazon.jsii.Kernel.get(this, "s3ExportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ExportRole = software.amazon.jsii.Kernel.get(this, "s3ExportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.s3ImportBuckets = software.amazon.jsii.Kernel.get(this, "s3ImportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ImportRole = software.amazon.jsii.Kernel.get(this, "s3ImportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.storageEncryptionKey = software.amazon.jsii.Kernel.get(this, "storageEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.subnetGroup = software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ISubnetGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.rds.IClusterEngine engine, final software.amazon.awscdk.services.rds.InstanceProps instanceProps, final software.amazon.awscdk.services.rds.BackupProps backup, final java.util.List<java.lang.String> cloudwatchLogsExports, final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention, final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole, final java.lang.String clusterIdentifier, final software.amazon.awscdk.services.rds.Credentials credentials, final java.lang.String defaultDatabaseName, final java.lang.Boolean deletionProtection, final java.lang.Boolean iamAuthentication, final java.lang.String instanceIdentifierBase, final java.lang.Number instances, final software.amazon.awscdk.Duration monitoringInterval, final software.amazon.awscdk.services.iam.IRole monitoringRole, final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup, final java.lang.Number port, final java.lang.String preferredMaintenanceWindow, final software.amazon.awscdk.RemovalPolicy removalPolicy, final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets, final software.amazon.awscdk.services.iam.IRole s3ExportRole, final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets, final software.amazon.awscdk.services.iam.IRole s3ImportRole, final java.lang.Boolean storageEncrypted, final software.amazon.awscdk.services.kms.IKey storageEncryptionKey, final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engine = java.util.Objects.requireNonNull(engine, "engine is required");
            this.instanceProps = java.util.Objects.requireNonNull(instanceProps, "instanceProps is required");
            this.backup = backup;
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            this.clusterIdentifier = clusterIdentifier;
            this.credentials = credentials;
            this.defaultDatabaseName = defaultDatabaseName;
            this.deletionProtection = deletionProtection;
            this.iamAuthentication = iamAuthentication;
            this.instanceIdentifierBase = instanceIdentifierBase;
            this.instances = instances;
            this.monitoringInterval = monitoringInterval;
            this.monitoringRole = monitoringRole;
            this.parameterGroup = parameterGroup;
            this.port = port;
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            this.removalPolicy = removalPolicy;
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ExportBuckets;
            this.s3ExportRole = s3ExportRole;
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ImportBuckets;
            this.s3ImportRole = s3ImportRole;
            this.storageEncrypted = storageEncrypted;
            this.storageEncryptionKey = storageEncryptionKey;
            this.subnetGroup = subnetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
            return this.engine;
        }

        @Override
        public final software.amazon.awscdk.services.rds.InstanceProps getInstanceProps() {
            return this.instanceProps;
        }

        @Override
        public final software.amazon.awscdk.services.rds.BackupProps getBackup() {
            return this.backup;
        }

        @Override
        public final java.util.List<java.lang.String> getCloudwatchLogsExports() {
            return this.cloudwatchLogsExports;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getCloudwatchLogsRetention() {
            return this.cloudwatchLogsRetention;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCloudwatchLogsRetentionRole() {
            return this.cloudwatchLogsRetentionRole;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final software.amazon.awscdk.services.rds.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final java.lang.String getDefaultDatabaseName() {
            return this.defaultDatabaseName;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.Boolean getIamAuthentication() {
            return this.iamAuthentication;
        }

        @Override
        public final java.lang.String getInstanceIdentifierBase() {
            return this.instanceIdentifierBase;
        }

        @Override
        public final java.lang.Number getInstances() {
            return this.instances;
        }

        @Override
        public final software.amazon.awscdk.Duration getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
            return this.monitoringRole;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ExportBuckets() {
            return this.s3ExportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
            return this.s3ExportRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ImportBuckets() {
            return this.s3ImportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
            return this.s3ImportRole;
        }

        @Override
        public final java.lang.Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getStorageEncryptionKey() {
            return this.storageEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engine", om.valueToTree(this.getEngine()));
            data.set("instanceProps", om.valueToTree(this.getInstanceProps()));
            if (this.getBackup() != null) {
                data.set("backup", om.valueToTree(this.getBackup()));
            }
            if (this.getCloudwatchLogsExports() != null) {
                data.set("cloudwatchLogsExports", om.valueToTree(this.getCloudwatchLogsExports()));
            }
            if (this.getCloudwatchLogsRetention() != null) {
                data.set("cloudwatchLogsRetention", om.valueToTree(this.getCloudwatchLogsRetention()));
            }
            if (this.getCloudwatchLogsRetentionRole() != null) {
                data.set("cloudwatchLogsRetentionRole", om.valueToTree(this.getCloudwatchLogsRetentionRole()));
            }
            if (this.getClusterIdentifier() != null) {
                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getDefaultDatabaseName() != null) {
                data.set("defaultDatabaseName", om.valueToTree(this.getDefaultDatabaseName()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getIamAuthentication() != null) {
                data.set("iamAuthentication", om.valueToTree(this.getIamAuthentication()));
            }
            if (this.getInstanceIdentifierBase() != null) {
                data.set("instanceIdentifierBase", om.valueToTree(this.getInstanceIdentifierBase()));
            }
            if (this.getInstances() != null) {
                data.set("instances", om.valueToTree(this.getInstances()));
            }
            if (this.getMonitoringInterval() != null) {
                data.set("monitoringInterval", om.valueToTree(this.getMonitoringInterval()));
            }
            if (this.getMonitoringRole() != null) {
                data.set("monitoringRole", om.valueToTree(this.getMonitoringRole()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getS3ExportBuckets() != null) {
                data.set("s3ExportBuckets", om.valueToTree(this.getS3ExportBuckets()));
            }
            if (this.getS3ExportRole() != null) {
                data.set("s3ExportRole", om.valueToTree(this.getS3ExportRole()));
            }
            if (this.getS3ImportBuckets() != null) {
                data.set("s3ImportBuckets", om.valueToTree(this.getS3ImportBuckets()));
            }
            if (this.getS3ImportRole() != null) {
                data.set("s3ImportRole", om.valueToTree(this.getS3ImportRole()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getStorageEncryptionKey() != null) {
                data.set("storageEncryptionKey", om.valueToTree(this.getStorageEncryptionKey()));
            }
            if (this.getSubnetGroup() != null) {
                data.set("subnetGroup", om.valueToTree(this.getSubnetGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseClusterProps.Jsii$Proxy that = (DatabaseClusterProps.Jsii$Proxy) o;

            if (!engine.equals(that.engine)) return false;
            if (!instanceProps.equals(that.instanceProps)) return false;
            if (this.backup != null ? !this.backup.equals(that.backup) : that.backup != null) return false;
            if (this.cloudwatchLogsExports != null ? !this.cloudwatchLogsExports.equals(that.cloudwatchLogsExports) : that.cloudwatchLogsExports != null) return false;
            if (this.cloudwatchLogsRetention != null ? !this.cloudwatchLogsRetention.equals(that.cloudwatchLogsRetention) : that.cloudwatchLogsRetention != null) return false;
            if (this.cloudwatchLogsRetentionRole != null ? !this.cloudwatchLogsRetentionRole.equals(that.cloudwatchLogsRetentionRole) : that.cloudwatchLogsRetentionRole != null) return false;
            if (this.clusterIdentifier != null ? !this.clusterIdentifier.equals(that.clusterIdentifier) : that.clusterIdentifier != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.defaultDatabaseName != null ? !this.defaultDatabaseName.equals(that.defaultDatabaseName) : that.defaultDatabaseName != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.iamAuthentication != null ? !this.iamAuthentication.equals(that.iamAuthentication) : that.iamAuthentication != null) return false;
            if (this.instanceIdentifierBase != null ? !this.instanceIdentifierBase.equals(that.instanceIdentifierBase) : that.instanceIdentifierBase != null) return false;
            if (this.instances != null ? !this.instances.equals(that.instances) : that.instances != null) return false;
            if (this.monitoringInterval != null ? !this.monitoringInterval.equals(that.monitoringInterval) : that.monitoringInterval != null) return false;
            if (this.monitoringRole != null ? !this.monitoringRole.equals(that.monitoringRole) : that.monitoringRole != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.s3ExportBuckets != null ? !this.s3ExportBuckets.equals(that.s3ExportBuckets) : that.s3ExportBuckets != null) return false;
            if (this.s3ExportRole != null ? !this.s3ExportRole.equals(that.s3ExportRole) : that.s3ExportRole != null) return false;
            if (this.s3ImportBuckets != null ? !this.s3ImportBuckets.equals(that.s3ImportBuckets) : that.s3ImportBuckets != null) return false;
            if (this.s3ImportRole != null ? !this.s3ImportRole.equals(that.s3ImportRole) : that.s3ImportRole != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.storageEncryptionKey != null ? !this.storageEncryptionKey.equals(that.storageEncryptionKey) : that.storageEncryptionKey != null) return false;
            return this.subnetGroup != null ? this.subnetGroup.equals(that.subnetGroup) : that.subnetGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engine.hashCode();
            result = 31 * result + (this.instanceProps.hashCode());
            result = 31 * result + (this.backup != null ? this.backup.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsExports != null ? this.cloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetention != null ? this.cloudwatchLogsRetention.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetentionRole != null ? this.cloudwatchLogsRetentionRole.hashCode() : 0);
            result = 31 * result + (this.clusterIdentifier != null ? this.clusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.defaultDatabaseName != null ? this.defaultDatabaseName.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.iamAuthentication != null ? this.iamAuthentication.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifierBase != null ? this.instanceIdentifierBase.hashCode() : 0);
            result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
            result = 31 * result + (this.monitoringInterval != null ? this.monitoringInterval.hashCode() : 0);
            result = 31 * result + (this.monitoringRole != null ? this.monitoringRole.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.s3ExportBuckets != null ? this.s3ExportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ExportRole != null ? this.s3ExportRole.hashCode() : 0);
            result = 31 * result + (this.s3ImportBuckets != null ? this.s3ImportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ImportRole != null ? this.s3ImportRole.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.storageEncryptionKey != null ? this.storageEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.subnetGroup != null ? this.subnetGroup.hashCode() : 0);
            return result;
        }
    }
}
