/**
 * <h1>CDK Construct library for higher-level Route 53 Constructs</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library provides higher-level Amazon Route 53 constructs which follow common
 * architectural patterns.
 * <p>
 * <h2>HTTPS Redirect</h2>
 * <p>
 * If you want to speed up delivery of your web content, you can use Amazon CloudFront,
 * the AWS content delivery network (CDN). CloudFront can deliver your entire website
 * —including dynamic, static, streaming, and interactive content—by using a global
 * network of edge locations. Requests for your content are automatically routed to the
 * edge location that gives your users the lowest latency.
 * <p>
 * This construct allows creating a redirect from domainA to domainB using Amazon
 * CloudFront and Amazon S3. You can specify multiple domains to be redirected.
 * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Learn more</a> about routing traffic to a CloudFront web distribution.
 * <p>
 * The <code>HttpsRedirect</code> constructs creates:
 * <p>
 * <ul>
 * <li>Amazon CloudFront distribution - makes website available from data centres
 * around the world</li>
 * <li>Amazon S3 bucket - empty bucket used for website hosting redirect (<code>websiteRedirect</code>) capabilities.</li>
 * <li>Amazon Route 53 A/AAAA Alias records - routes traffic to the CloudFront distribution</li>
 * <li>AWS Certificate Manager certificate - SSL/TLS certificate used by
 * CloudFront for your domain</li>
 * </ul>
 * <p>
 * ⚠️ The stack/construct can be used in any region for configuring an HTTPS redirect.
 * The certificate created in Amazon Certificate Manager (ACM) will be in US East (N. Virginia)
 * region. If you use an existing certificate, the AWS region of the certificate
 * must be in US East (N. Virginia).
 * <p>
 * The following example creates an HTTPS redirect from <code>foo.example.com</code> to <code>bar.example.com</code>
 * As an existing certificate is not provided, one will be created in <code>us-east-1</code> by the CDK.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * HttpsRedirect.Builder.create(stack, "Redirect")
 *         .recordNames(asList("foo.example.com"))
 *         .targetDomain("bar.example.com")
 *         .zone(HostedZone.fromHostedZoneAttributes(stack, "HostedZone", Map.of(
 *                 "hostedZoneId", "ID",
 *                 "zoneName", "example.com")))
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.route53.patterns;
