package software.amazon.awscdk.services.ses.actions;

/**
 * (experimental) Construction properties for a bounce action.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:52.690Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.BounceProps")
@software.amazon.jsii.Jsii.Proxy(BounceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BounceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The email address of the sender of the bounced email.
     * <p>
     * This is the address
     * from which the bounce message will be sent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSender();

    /**
     * (experimental) The template containing the message, reply code and status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.BounceTemplate getTemplate();

    /**
     * (experimental) The SNS topic to notify when the bounce action is taken.
     * <p>
     * Default: no notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BounceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BounceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BounceProps> {
        private java.lang.String sender;
        private software.amazon.awscdk.services.ses.actions.BounceTemplate template;
        private software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Sets the value of {@link BounceProps#getSender}
         * @param sender The email address of the sender of the bounced email. This parameter is required.
         *               This is the address
         *               from which the bounce message will be sent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sender(java.lang.String sender) {
            this.sender = sender;
            return this;
        }

        /**
         * Sets the value of {@link BounceProps#getTemplate}
         * @param template The template containing the message, reply code and status code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder template(software.amazon.awscdk.services.ses.actions.BounceTemplate template) {
            this.template = template;
            return this;
        }

        /**
         * Sets the value of {@link BounceProps#getTopic}
         * @param topic The SNS topic to notify when the bounce action is taken.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BounceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BounceProps build() {
            return new Jsii$Proxy(sender, template, topic);
        }
    }

    /**
     * An implementation for {@link BounceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BounceProps {
        private final java.lang.String sender;
        private final software.amazon.awscdk.services.ses.actions.BounceTemplate template;
        private final software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sender = software.amazon.jsii.Kernel.get(this, "sender", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.template = software.amazon.jsii.Kernel.get(this, "template", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.actions.BounceTemplate.class));
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String sender, final software.amazon.awscdk.services.ses.actions.BounceTemplate template, final software.amazon.awscdk.services.sns.ITopic topic) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sender = java.util.Objects.requireNonNull(sender, "sender is required");
            this.template = java.util.Objects.requireNonNull(template, "template is required");
            this.topic = topic;
        }

        @Override
        public final java.lang.String getSender() {
            return this.sender;
        }

        @Override
        public final software.amazon.awscdk.services.ses.actions.BounceTemplate getTemplate() {
            return this.template;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sender", om.valueToTree(this.getSender()));
            data.set("template", om.valueToTree(this.getTemplate()));
            if (this.getTopic() != null) {
                data.set("topic", om.valueToTree(this.getTopic()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses_actions.BounceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BounceProps.Jsii$Proxy that = (BounceProps.Jsii$Proxy) o;

            if (!sender.equals(that.sender)) return false;
            if (!template.equals(that.template)) return false;
            return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sender.hashCode();
            result = 31 * result + (this.template.hashCode());
            result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
            return result;
        }
    }
}
