/**
 * <h1>Amazon Simple Email Service Actions Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module contains integration classes to add action to SES email receiving rules.
 * Instances of these classes should be passed to the <code>rule.addAction()</code> method.
 * <p>
 * Currently supported are:
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html">Add header</a></li>
 * <li><a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html">Bounce</a></li>
 * <li><a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html">Lambda</a></li>
 * <li><a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-s3.html">S3</a></li>
 * <li><a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-sns.html">SNS</a></li>
 * <li><a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-stop.html">Stop</a></li>
 * </ul>
 * <p>
 * See the README of <code>&#64;aws-cdk/aws-ses</code> for more information.
 */
package software.amazon.awscdk.services.ses.actions;
