package software.amazon.awscdk.services.sns;

/**
 * (experimental) A new subscription.
 * <p>
 * Prefer to use the <code>ITopic.addSubscription()</code> methods to create instances of
 * this class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:52.709Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.Subscription")
public class Subscription extends software.amazon.awscdk.Resource {

    protected Subscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Subscription(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The DLQ associated with this subscription if present.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.sns.Subscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.Subscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sns.SubscriptionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sns.SubscriptionProps.Builder();
        }

        /**
         * (experimental) The subscription endpoint.
         * <p>
         * The meaning of this value depends on the value for 'protocol'.
         * <p>
         * @return {@code this}
         * @param endpoint The subscription endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endpoint(final java.lang.String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * (experimental) What type of subscription to add.
         * <p>
         * @return {@code this}
         * @param protocol What type of subscription to add. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocol(final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * (experimental) Queue to be used as dead letter queue.
         * <p>
         * If not passed no dead letter queue is enabled.
         * <p>
         * Default: - No dead letter queue enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * (experimental) The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder filterPolicy(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props.filterPolicy(filterPolicy);
            return this;
        }

        /**
         * (experimental) true if raw message delivery is enabled for the subscription.
         * <p>
         * Raw messages are free of JSON formatting and can be
         * sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
         * Notification Service API Reference.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param rawMessageDelivery true if raw message delivery is enabled for the subscription. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rawMessageDelivery(final java.lang.Boolean rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        /**
         * (experimental) The region where the topic resides, in the case of cross-region subscriptions.
         * <p>
         * Default: - the region where the CloudFormation stack is being deployed.
         * <p>
         * @return {@code this}
         * @param region The region where the topic resides, in the case of cross-region subscriptions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * (experimental) The topic to subscribe to.
         * <p>
         * @return {@code this}
         * @param topic The topic to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sns.Subscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.sns.Subscription build() {
            return new software.amazon.awscdk.services.sns.Subscription(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
