/**
 * <h1>AWS Systems Manager Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Install the module:
 * <p>
 * <blockquote><pre>
 * $ npm i &#64;aws-cdk/aws-ssm
 * </pre></blockquote>
 * <p>
 * Import it into your code:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_ssm;
 * </pre></blockquote>
 * <p>
 * <h2>Using existing SSM Parameters in your CDK app</h2>
 * <p>
 * You can reference existing SSM Parameter Store values that you want to use in
 * your CDK app by using <code>ssm.ParameterStoreString</code>:
 * <p>
 * <a href="test/integ.parameter-store-string.lit.ts">using SSM parameter</a>
 * <p>
 * <h2>Creating new SSM Parameters in your CDK app</h2>
 * <p>
 * You can create either <code>ssm.StringParameter</code> or <code>ssm.StringListParameter</code>s in
 * a CDK app. These are public (not secret) values. Parameters of type
 * <em>SecretString</em> cannot be created directly from a CDK application; if you want
 * to provision secrets automatically, use Secrets Manager Secrets (see the
 * <code>&#64;aws-cdk/aws-secretsmanager</code> package).
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * StringParameter.Builder.create(stack, "Parameter")
 *         .allowedPattern(".*")
 *         .description("The value Foo")
 *         .parameterName("FooParameter")
 *         .stringValue("Foo")
 *         .tier(ssm.ParameterTier.getADVANCED())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <a href="test/integ.parameter.lit.ts">creating SSM parameters</a>
 * <p>
 * When specifying an <code>allowedPattern</code>, the values provided as string literals
 * are validated against the pattern and an exception is raised if a value
 * provided does not comply.
 */
package software.amazon.awscdk.services.ssm;
