/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appflow;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.appflow.CfnConnectorProfile;
import software.amazon.awscdk.services.appflow.CfnConnectorProfileProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile")
public class CfnConnectorProfile
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConnectorProfile.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConnectorProfile(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnectorProfile(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConnectorProfile(@NotNull Construct scope, @NotNull String id, @NotNull CfnConnectorProfileProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrConnectorProfileArn() {
        return (String)Kernel.get((Object)this, (String)"attrConnectorProfileArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCredentialsArn() {
        return (String)Kernel.get((Object)this, (String)"attrCredentialsArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getConnectionMode() {
        return (String)Kernel.get((Object)this, (String)"connectionMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setConnectionMode(@NotNull String value) {
        Kernel.set((Object)this, (String)"connectionMode", (Object)Objects.requireNonNull(value, "connectionMode is required"));
    }

    @NotNull
    public String getConnectorProfileName() {
        return (String)Kernel.get((Object)this, (String)"connectorProfileName", (NativeType)NativeType.forClass(String.class));
    }

    public void setConnectorProfileName(@NotNull String value) {
        Kernel.set((Object)this, (String)"connectorProfileName", (Object)Objects.requireNonNull(value, "connectorProfileName is required"));
    }

    @NotNull
    public String getConnectorType() {
        return (String)Kernel.get((Object)this, (String)"connectorType", (NativeType)NativeType.forClass(String.class));
    }

    public void setConnectorType(@NotNull String value) {
        Kernel.set((Object)this, (String)"connectorType", (Object)Objects.requireNonNull(value, "connectorType is required"));
    }

    @Nullable
    public Object getConnectorProfileConfig() {
        return Kernel.get((Object)this, (String)"connectorProfileConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConnectorProfileConfig(@Nullable ConnectorProfileConfigProperty value) {
        Kernel.set((Object)this, (String)"connectorProfileConfig", (Object)value);
    }

    public void setConnectorProfileConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"connectorProfileConfig", (Object)value);
    }

    @Nullable
    public String getKmsArn() {
        return (String)Kernel.get((Object)this, (String)"kmsArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsArn", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConnectorProfile> {
        private final Construct scope;
        private final String id;
        private final CfnConnectorProfileProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConnectorProfileProps.Builder();
        }

        public Builder connectionMode(String connectionMode) {
            this.props.connectionMode(connectionMode);
            return this;
        }

        public Builder connectorProfileName(String connectorProfileName) {
            this.props.connectorProfileName(connectorProfileName);
            return this;
        }

        public Builder connectorType(String connectorType) {
            this.props.connectorType(connectorType);
            return this;
        }

        public Builder connectorProfileConfig(ConnectorProfileConfigProperty connectorProfileConfig) {
            this.props.connectorProfileConfig(connectorProfileConfig);
            return this;
        }

        public Builder connectorProfileConfig(IResolvable connectorProfileConfig) {
            this.props.connectorProfileConfig(connectorProfileConfig);
            return this;
        }

        public Builder kmsArn(String kmsArn) {
            this.props.kmsArn(kmsArn);
            return this;
        }

        public CfnConnectorProfile build() {
            return new CfnConnectorProfile(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ZendeskConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ZendeskConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public ZendeskConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ZendeskConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getClientId();

        @NotNull
        public String getClientSecret();

        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public Object getConnectorOAuthRequest() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ZendeskConnectorProfileCredentialsProperty> {
            private String clientId;
            private String clientSecret;
            private String accessToken;
            private Object connectorOAuthRequest;

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder clientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder connectorOAuthRequest(ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public Builder connectorOAuthRequest(IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public ZendeskConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.clientId, this.clientSecret, this.accessToken, this.connectorOAuthRequest);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VeevaConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VeevaConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public VeevaConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VeevaConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getPassword();

        @NotNull
        public String getUsername();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VeevaConnectorProfileCredentialsProperty> {
            private String password;
            private String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public VeevaConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.password, this.username);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrendmicroConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getApiSecretKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrendmicroConnectorProfileCredentialsProperty> {
            private String apiSecretKey;

            public Builder apiSecretKey(String apiSecretKey) {
                this.apiSecretKey = apiSecretKey;
                return this;
            }

            public TrendmicroConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.apiSecretKey);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnowflakeConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @NotNull
        public String getStage();

        @NotNull
        public String getWarehouse();

        @Nullable
        default public String getAccountName() {
            return null;
        }

        @Nullable
        default public String getBucketPrefix() {
            return null;
        }

        @Nullable
        default public String getPrivateLinkServiceName() {
            return null;
        }

        @Nullable
        default public String getRegion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnowflakeConnectorProfilePropertiesProperty> {
            private String bucketName;
            private String stage;
            private String warehouse;
            private String accountName;
            private String bucketPrefix;
            private String privateLinkServiceName;
            private String region;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder stage(String stage) {
                this.stage = stage;
                return this;
            }

            public Builder warehouse(String warehouse) {
                this.warehouse = warehouse;
                return this;
            }

            public Builder accountName(String accountName) {
                this.accountName = accountName;
                return this;
            }

            public Builder bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public Builder privateLinkServiceName(String privateLinkServiceName) {
                this.privateLinkServiceName = privateLinkServiceName;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public SnowflakeConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.bucketName, this.stage, this.warehouse, this.accountName, this.bucketPrefix, this.privateLinkServiceName, this.region);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnowflakeConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getPassword();

        @NotNull
        public String getUsername();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnowflakeConnectorProfileCredentialsProperty> {
            private String password;
            private String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public SnowflakeConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.password, this.username);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlackConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlackConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public SlackConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlackConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getClientId();

        @NotNull
        public String getClientSecret();

        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public Object getConnectorOAuthRequest() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlackConnectorProfileCredentialsProperty> {
            private String clientId;
            private String clientSecret;
            private String accessToken;
            private Object connectorOAuthRequest;

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder clientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder connectorOAuthRequest(ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public Builder connectorOAuthRequest(IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public SlackConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.clientId, this.clientSecret, this.accessToken, this.connectorOAuthRequest);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.SingularConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SingularConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getApiKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SingularConnectorProfileCredentialsProperty> {
            private String apiKey;

            public Builder apiKey(String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            public SingularConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.apiKey);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public ServiceNowConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getPassword();

        @NotNull
        public String getUsername();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowConnectorProfileCredentialsProperty> {
            private String password;
            private String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public ServiceNowConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.password, this.username);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInstanceUrl() {
            return null;
        }

        @Nullable
        default public Object getIsSandboxEnvironment() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceConnectorProfilePropertiesProperty> {
            private String instanceUrl;
            private Object isSandboxEnvironment;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public Builder isSandboxEnvironment(Boolean isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            public Builder isSandboxEnvironment(IResolvable isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            public SalesforceConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl, this.isSandboxEnvironment);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public String getClientCredentialsArn() {
            return null;
        }

        @Nullable
        default public Object getConnectorOAuthRequest() {
            return null;
        }

        @Nullable
        default public String getRefreshToken() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceConnectorProfileCredentialsProperty> {
            private String accessToken;
            private String clientCredentialsArn;
            private Object connectorOAuthRequest;
            private String refreshToken;

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder clientCredentialsArn(String clientCredentialsArn) {
                this.clientCredentialsArn = clientCredentialsArn;
                return this;
            }

            public Builder connectorOAuthRequest(ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public Builder connectorOAuthRequest(IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public Builder refreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            public SalesforceConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.accessToken, this.clientCredentialsArn, this.connectorOAuthRequest, this.refreshToken);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @NotNull
        public String getDatabaseUrl();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getBucketPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftConnectorProfilePropertiesProperty> {
            private String bucketName;
            private String databaseUrl;
            private String roleArn;
            private String bucketPrefix;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder databaseUrl(String databaseUrl) {
                this.databaseUrl = databaseUrl;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public RedshiftConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.bucketName, this.databaseUrl, this.roleArn, this.bucketPrefix);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getPassword();

        @NotNull
        public String getUsername();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftConnectorProfileCredentialsProperty> {
            private String password;
            private String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public RedshiftConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.password, this.username);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MarketoConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MarketoConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public MarketoConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MarketoConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getClientId();

        @NotNull
        public String getClientSecret();

        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public Object getConnectorOAuthRequest() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MarketoConnectorProfileCredentialsProperty> {
            private String clientId;
            private String clientSecret;
            private String accessToken;
            private Object connectorOAuthRequest;

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder clientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder connectorOAuthRequest(ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public Builder connectorOAuthRequest(IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public MarketoConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.clientId, this.clientSecret, this.accessToken, this.connectorOAuthRequest);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InforNexusConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InforNexusConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public InforNexusConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InforNexusConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getAccessKeyId();

        @NotNull
        public String getDatakey();

        @NotNull
        public String getSecretAccessKey();

        @NotNull
        public String getUserId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InforNexusConnectorProfileCredentialsProperty> {
            private String accessKeyId;
            private String datakey;
            private String secretAccessKey;
            private String userId;

            public Builder accessKeyId(String accessKeyId) {
                this.accessKeyId = accessKeyId;
                return this;
            }

            public Builder datakey(String datakey) {
                this.datakey = datakey;
                return this;
            }

            public Builder secretAccessKey(String secretAccessKey) {
                this.secretAccessKey = secretAccessKey;
                return this;
            }

            public Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public InforNexusConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.accessKeyId, this.datakey, this.secretAccessKey, this.userId);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GoogleAnalyticsConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getClientId();

        @NotNull
        public String getClientSecret();

        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public Object getConnectorOAuthRequest() {
            return null;
        }

        @Nullable
        default public String getRefreshToken() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GoogleAnalyticsConnectorProfileCredentialsProperty> {
            private String clientId;
            private String clientSecret;
            private String accessToken;
            private Object connectorOAuthRequest;
            private String refreshToken;

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder clientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder connectorOAuthRequest(ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public Builder connectorOAuthRequest(IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            public Builder refreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            public GoogleAnalyticsConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.clientId, this.clientSecret, this.accessToken, this.connectorOAuthRequest, this.refreshToken);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynatraceConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynatraceConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public DynatraceConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynatraceConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getApiToken();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynatraceConnectorProfileCredentialsProperty> {
            private String apiToken;

            public Builder apiToken(String apiToken) {
                this.apiToken = apiToken;
                return this;
            }

            public DynatraceConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.apiToken);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatadogConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatadogConnectorProfilePropertiesProperty> {
            private String instanceUrl;

            public Builder instanceUrl(String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            public DatadogConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.instanceUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatadogConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getApiKey();

        @NotNull
        public String getApplicationKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatadogConnectorProfileCredentialsProperty> {
            private String apiKey;
            private String applicationKey;

            public Builder apiKey(String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            public Builder applicationKey(String applicationKey) {
                this.applicationKey = applicationKey;
                return this;
            }

            public DatadogConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.apiKey, this.applicationKey);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectorProfilePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDatadog() {
            return null;
        }

        @Nullable
        default public Object getDynatrace() {
            return null;
        }

        @Nullable
        default public Object getInforNexus() {
            return null;
        }

        @Nullable
        default public Object getMarketo() {
            return null;
        }

        @Nullable
        default public Object getRedshift() {
            return null;
        }

        @Nullable
        default public Object getSalesforce() {
            return null;
        }

        @Nullable
        default public Object getServiceNow() {
            return null;
        }

        @Nullable
        default public Object getSlack() {
            return null;
        }

        @Nullable
        default public Object getSnowflake() {
            return null;
        }

        @Nullable
        default public Object getVeeva() {
            return null;
        }

        @Nullable
        default public Object getZendesk() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectorProfilePropertiesProperty> {
            private Object datadog;
            private Object dynatrace;
            private Object inforNexus;
            private Object marketo;
            private Object redshift;
            private Object salesforce;
            private Object serviceNow;
            private Object slack;
            private Object snowflake;
            private Object veeva;
            private Object zendesk;

            public Builder datadog(DatadogConnectorProfilePropertiesProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            public Builder datadog(IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            public Builder dynatrace(DynatraceConnectorProfilePropertiesProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            public Builder dynatrace(IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            public Builder inforNexus(InforNexusConnectorProfilePropertiesProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            public Builder inforNexus(IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            public Builder marketo(MarketoConnectorProfilePropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            public Builder marketo(IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            public Builder redshift(RedshiftConnectorProfilePropertiesProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            public Builder redshift(IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            public Builder salesforce(SalesforceConnectorProfilePropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            public Builder salesforce(IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            public Builder serviceNow(ServiceNowConnectorProfilePropertiesProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            public Builder serviceNow(IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            public Builder slack(SlackConnectorProfilePropertiesProperty slack) {
                this.slack = slack;
                return this;
            }

            public Builder slack(IResolvable slack) {
                this.slack = slack;
                return this;
            }

            public Builder snowflake(SnowflakeConnectorProfilePropertiesProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            public Builder snowflake(IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            public Builder veeva(VeevaConnectorProfilePropertiesProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            public Builder veeva(IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            public Builder zendesk(ZendeskConnectorProfilePropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            public Builder zendesk(IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            public ConnectorProfilePropertiesProperty build() {
                return new Jsii.Proxy(this.datadog, this.dynatrace, this.inforNexus, this.marketo, this.redshift, this.salesforce, this.serviceNow, this.slack, this.snowflake, this.veeva, this.zendesk);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAmplitude() {
            return null;
        }

        @Nullable
        default public Object getDatadog() {
            return null;
        }

        @Nullable
        default public Object getDynatrace() {
            return null;
        }

        @Nullable
        default public Object getGoogleAnalytics() {
            return null;
        }

        @Nullable
        default public Object getInforNexus() {
            return null;
        }

        @Nullable
        default public Object getMarketo() {
            return null;
        }

        @Nullable
        default public Object getRedshift() {
            return null;
        }

        @Nullable
        default public Object getSalesforce() {
            return null;
        }

        @Nullable
        default public Object getServiceNow() {
            return null;
        }

        @Nullable
        default public Object getSingular() {
            return null;
        }

        @Nullable
        default public Object getSlack() {
            return null;
        }

        @Nullable
        default public Object getSnowflake() {
            return null;
        }

        @Nullable
        default public Object getTrendmicro() {
            return null;
        }

        @Nullable
        default public Object getVeeva() {
            return null;
        }

        @Nullable
        default public Object getZendesk() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectorProfileCredentialsProperty> {
            private Object amplitude;
            private Object datadog;
            private Object dynatrace;
            private Object googleAnalytics;
            private Object inforNexus;
            private Object marketo;
            private Object redshift;
            private Object salesforce;
            private Object serviceNow;
            private Object singular;
            private Object slack;
            private Object snowflake;
            private Object trendmicro;
            private Object veeva;
            private Object zendesk;

            public Builder amplitude(AmplitudeConnectorProfileCredentialsProperty amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            public Builder amplitude(IResolvable amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            public Builder datadog(DatadogConnectorProfileCredentialsProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            public Builder datadog(IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            public Builder dynatrace(DynatraceConnectorProfileCredentialsProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            public Builder dynatrace(IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            public Builder googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            public Builder googleAnalytics(IResolvable googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            public Builder inforNexus(InforNexusConnectorProfileCredentialsProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            public Builder inforNexus(IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            public Builder marketo(MarketoConnectorProfileCredentialsProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            public Builder marketo(IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            public Builder redshift(RedshiftConnectorProfileCredentialsProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            public Builder redshift(IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            public Builder salesforce(SalesforceConnectorProfileCredentialsProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            public Builder salesforce(IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            public Builder serviceNow(ServiceNowConnectorProfileCredentialsProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            public Builder serviceNow(IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            public Builder singular(SingularConnectorProfileCredentialsProperty singular) {
                this.singular = singular;
                return this;
            }

            public Builder singular(IResolvable singular) {
                this.singular = singular;
                return this;
            }

            public Builder slack(SlackConnectorProfileCredentialsProperty slack) {
                this.slack = slack;
                return this;
            }

            public Builder slack(IResolvable slack) {
                this.slack = slack;
                return this;
            }

            public Builder snowflake(SnowflakeConnectorProfileCredentialsProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            public Builder snowflake(IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            public Builder trendmicro(TrendmicroConnectorProfileCredentialsProperty trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            public Builder trendmicro(IResolvable trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            public Builder veeva(VeevaConnectorProfileCredentialsProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            public Builder veeva(IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            public Builder zendesk(ZendeskConnectorProfileCredentialsProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            public Builder zendesk(IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            public ConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.amplitude, this.datadog, this.dynatrace, this.googleAnalytics, this.inforNexus, this.marketo, this.redshift, this.salesforce, this.serviceNow, this.singular, this.slack, this.snowflake, this.trendmicro, this.veeva, this.zendesk);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectorProfileConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConnectorProfileCredentials();

        @Nullable
        default public Object getConnectorProfileProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectorProfileConfigProperty> {
            private Object connectorProfileCredentials;
            private Object connectorProfileProperties;

            public Builder connectorProfileCredentials(ConnectorProfileCredentialsProperty connectorProfileCredentials) {
                this.connectorProfileCredentials = connectorProfileCredentials;
                return this;
            }

            public Builder connectorProfileCredentials(IResolvable connectorProfileCredentials) {
                this.connectorProfileCredentials = connectorProfileCredentials;
                return this;
            }

            public Builder connectorProfileProperties(ConnectorProfilePropertiesProperty connectorProfileProperties) {
                this.connectorProfileProperties = connectorProfileProperties;
                return this;
            }

            public Builder connectorProfileProperties(IResolvable connectorProfileProperties) {
                this.connectorProfileProperties = connectorProfileProperties;
                return this;
            }

            public ConnectorProfileConfigProperty build() {
                return new Jsii.Proxy(this.connectorProfileCredentials, this.connectorProfileProperties);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectorOAuthRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthCode() {
            return null;
        }

        @Nullable
        default public String getRedirectUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectorOAuthRequestProperty> {
            private String authCode;
            private String redirectUri;

            public Builder authCode(String authCode) {
                this.authCode = authCode;
                return this;
            }

            public Builder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            public ConnectorOAuthRequestProperty build() {
                return new Jsii.Proxy(this.authCode, this.redirectUri);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appflow.CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AmplitudeConnectorProfileCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getApiKey();

        @NotNull
        public String getSecretKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AmplitudeConnectorProfileCredentialsProperty> {
            private String apiKey;
            private String secretKey;

            public Builder apiKey(String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            public Builder secretKey(String secretKey) {
                this.secretKey = secretKey;
                return this;
            }

            public AmplitudeConnectorProfileCredentialsProperty build() {
                return new Jsii.Proxy(this.apiKey, this.secretKey);
            }
        }
    }
}

