/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.batch.CfnComputeEnvironment;
import software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnComputeEnvironment")
public class CfnComputeEnvironment
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnComputeEnvironment.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnComputeEnvironment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComputeEnvironment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnComputeEnvironment(@NotNull Construct scope, @NotNull String id, @NotNull CfnComputeEnvironmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public String getComputeEnvironmentName() {
        return (String)Kernel.get((Object)this, (String)"computeEnvironmentName", (NativeType)NativeType.forClass(String.class));
    }

    public void setComputeEnvironmentName(@Nullable String value) {
        Kernel.set((Object)this, (String)"computeEnvironmentName", (Object)value);
    }

    @Nullable
    public Object getComputeResources() {
        return Kernel.get((Object)this, (String)"computeResources", (NativeType)NativeType.forClass(Object.class));
    }

    public void setComputeResources(@Nullable ComputeResourcesProperty value) {
        Kernel.set((Object)this, (String)"computeResources", (Object)value);
    }

    public void setComputeResources(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"computeResources", (Object)value);
    }

    @Nullable
    public String getServiceRole() {
        return (String)Kernel.get((Object)this, (String)"serviceRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"serviceRole", (Object)value);
    }

    @Nullable
    public String getState() {
        return (String)Kernel.get((Object)this, (String)"state", (NativeType)NativeType.forClass(String.class));
    }

    public void setState(@Nullable String value) {
        Kernel.set((Object)this, (String)"state", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnComputeEnvironment> {
        private final Construct scope;
        private final String id;
        private final CfnComputeEnvironmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnComputeEnvironmentProps.Builder();
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder computeEnvironmentName(String computeEnvironmentName) {
            this.props.computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        public Builder computeResources(ComputeResourcesProperty computeResources) {
            this.props.computeResources(computeResources);
            return this;
        }

        public Builder computeResources(IResolvable computeResources) {
            this.props.computeResources(computeResources);
            return this;
        }

        public Builder serviceRole(String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        public Builder state(String state) {
            this.props.state(state);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnComputeEnvironment build() {
            return new CfnComputeEnvironment(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnComputeEnvironment.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateSpecificationProperty> {
            private String launchTemplateId;
            private String launchTemplateName;
            private String version;

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public LaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this.launchTemplateId, this.launchTemplateName, this.version);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnComputeEnvironment.Ec2ConfigurationObjectProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Ec2ConfigurationObjectProperty
    extends JsiiSerializable {
        @NotNull
        public String getImageType();

        @Nullable
        default public String getImageIdOverride() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Ec2ConfigurationObjectProperty> {
            private String imageType;
            private String imageIdOverride;

            public Builder imageType(String imageType) {
                this.imageType = imageType;
                return this;
            }

            public Builder imageIdOverride(String imageIdOverride) {
                this.imageIdOverride = imageIdOverride;
                return this;
            }

            public Ec2ConfigurationObjectProperty build() {
                return new Jsii.Proxy(this.imageType, this.imageIdOverride);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnComputeEnvironment.ComputeResourcesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComputeResourcesProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxvCpus();

        @NotNull
        public List<String> getSubnets();

        @NotNull
        public String getType();

        @Nullable
        default public String getAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getBidPercentage() {
            return null;
        }

        @Nullable
        default public Number getDesiredvCpus() {
            return null;
        }

        @Nullable
        default public Object getEc2Configuration() {
            return null;
        }

        @Nullable
        default public String getEc2KeyPair() {
            return null;
        }

        @Nullable
        default public String getImageId() {
            return null;
        }

        @Nullable
        default public String getInstanceRole() {
            return null;
        }

        @Nullable
        default public List<String> getInstanceTypes() {
            return null;
        }

        @Nullable
        default public Object getLaunchTemplate() {
            return null;
        }

        @Nullable
        default public Number getMinvCpus() {
            return null;
        }

        @Nullable
        default public String getPlacementGroup() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public String getSpotIamFleetRole() {
            return null;
        }

        @Nullable
        default public Object getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComputeResourcesProperty> {
            private Number maxvCpus;
            private List<String> subnets;
            private String type;
            private String allocationStrategy;
            private Number bidPercentage;
            private Number desiredvCpus;
            private Object ec2Configuration;
            private String ec2KeyPair;
            private String imageId;
            private String instanceRole;
            private List<String> instanceTypes;
            private Object launchTemplate;
            private Number minvCpus;
            private String placementGroup;
            private List<String> securityGroupIds;
            private String spotIamFleetRole;
            private Object tags;

            public Builder maxvCpus(Number maxvCpus) {
                this.maxvCpus = maxvCpus;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder bidPercentage(Number bidPercentage) {
                this.bidPercentage = bidPercentage;
                return this;
            }

            public Builder desiredvCpus(Number desiredvCpus) {
                this.desiredvCpus = desiredvCpus;
                return this;
            }

            public Builder ec2Configuration(IResolvable ec2Configuration) {
                this.ec2Configuration = ec2Configuration;
                return this;
            }

            public Builder ec2Configuration(List<? extends Object> ec2Configuration) {
                this.ec2Configuration = ec2Configuration;
                return this;
            }

            public Builder ec2KeyPair(String ec2KeyPair) {
                this.ec2KeyPair = ec2KeyPair;
                return this;
            }

            public Builder imageId(String imageId) {
                this.imageId = imageId;
                return this;
            }

            public Builder instanceRole(String instanceRole) {
                this.instanceRole = instanceRole;
                return this;
            }

            public Builder instanceTypes(List<String> instanceTypes) {
                this.instanceTypes = instanceTypes;
                return this;
            }

            public Builder launchTemplate(LaunchTemplateSpecificationProperty launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder launchTemplate(IResolvable launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder minvCpus(Number minvCpus) {
                this.minvCpus = minvCpus;
                return this;
            }

            public Builder placementGroup(String placementGroup) {
                this.placementGroup = placementGroup;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder spotIamFleetRole(String spotIamFleetRole) {
                this.spotIamFleetRole = spotIamFleetRole;
                return this;
            }

            public Builder tags(Object tags) {
                this.tags = tags;
                return this;
            }

            public ComputeResourcesProperty build() {
                return new Jsii.Proxy(this.maxvCpus, this.subnets, this.type, this.allocationStrategy, this.bidPercentage, this.desiredvCpus, this.ec2Configuration, this.ec2KeyPair, this.imageId, this.instanceRole, this.instanceTypes, this.launchTemplate, this.minvCpus, this.placementGroup, this.securityGroupIds, this.spotIamFleetRole, this.tags);
            }
        }
    }
}

