/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.budgets;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.budgets.CfnBudgetsAction;
import software.amazon.awscdk.services.budgets.CfnBudgetsActionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_budgets.CfnBudgetsAction")
public class CfnBudgetsAction
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBudgetsAction.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnBudgetsAction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBudgetsAction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnBudgetsAction(@NotNull Construct scope, @NotNull String id, @NotNull CfnBudgetsActionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrActionId() {
        return (String)Kernel.get((Object)this, (String)"attrActionId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getActionThreshold() {
        return Kernel.get((Object)this, (String)"actionThreshold", (NativeType)NativeType.forClass(Object.class));
    }

    public void setActionThreshold(@NotNull ActionThresholdProperty value) {
        Kernel.set((Object)this, (String)"actionThreshold", (Object)Objects.requireNonNull(value, "actionThreshold is required"));
    }

    public void setActionThreshold(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"actionThreshold", (Object)Objects.requireNonNull(value, "actionThreshold is required"));
    }

    @NotNull
    public String getActionType() {
        return (String)Kernel.get((Object)this, (String)"actionType", (NativeType)NativeType.forClass(String.class));
    }

    public void setActionType(@NotNull String value) {
        Kernel.set((Object)this, (String)"actionType", (Object)Objects.requireNonNull(value, "actionType is required"));
    }

    @NotNull
    public String getBudgetName() {
        return (String)Kernel.get((Object)this, (String)"budgetName", (NativeType)NativeType.forClass(String.class));
    }

    public void setBudgetName(@NotNull String value) {
        Kernel.set((Object)this, (String)"budgetName", (Object)Objects.requireNonNull(value, "budgetName is required"));
    }

    @NotNull
    public Object getDefinition() {
        return Kernel.get((Object)this, (String)"definition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinition(@NotNull DefinitionProperty value) {
        Kernel.set((Object)this, (String)"definition", (Object)Objects.requireNonNull(value, "definition is required"));
    }

    public void setDefinition(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"definition", (Object)Objects.requireNonNull(value, "definition is required"));
    }

    @NotNull
    public String getExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutionRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"executionRoleArn", (Object)Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    @NotNull
    public String getNotificationType() {
        return (String)Kernel.get((Object)this, (String)"notificationType", (NativeType)NativeType.forClass(String.class));
    }

    public void setNotificationType(@NotNull String value) {
        Kernel.set((Object)this, (String)"notificationType", (Object)Objects.requireNonNull(value, "notificationType is required"));
    }

    @Nullable
    public String getApprovalModel() {
        return (String)Kernel.get((Object)this, (String)"approvalModel", (NativeType)NativeType.forClass(String.class));
    }

    public void setApprovalModel(@Nullable String value) {
        Kernel.set((Object)this, (String)"approvalModel", (Object)value);
    }

    @Nullable
    public Object getSubscribers() {
        return Kernel.get((Object)this, (String)"subscribers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSubscribers(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"subscribers", (Object)value);
    }

    public void setSubscribers(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"subscribers", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnBudgetsAction> {
        private final Construct scope;
        private final String id;
        private final CfnBudgetsActionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnBudgetsActionProps.Builder();
        }

        public Builder actionThreshold(ActionThresholdProperty actionThreshold) {
            this.props.actionThreshold(actionThreshold);
            return this;
        }

        public Builder actionThreshold(IResolvable actionThreshold) {
            this.props.actionThreshold(actionThreshold);
            return this;
        }

        public Builder actionType(String actionType) {
            this.props.actionType(actionType);
            return this;
        }

        public Builder budgetName(String budgetName) {
            this.props.budgetName(budgetName);
            return this;
        }

        public Builder definition(DefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder definition(IResolvable definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder notificationType(String notificationType) {
            this.props.notificationType(notificationType);
            return this;
        }

        public Builder approvalModel(String approvalModel) {
            this.props.approvalModel(approvalModel);
            return this;
        }

        public Builder subscribers(IResolvable subscribers) {
            this.props.subscribers(subscribers);
            return this;
        }

        public Builder subscribers(List<? extends Object> subscribers) {
            this.props.subscribers(subscribers);
            return this;
        }

        public CfnBudgetsAction build() {
            return new CfnBudgetsAction(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_budgets.CfnBudgetsAction.SubscriberProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SubscriberProperty
    extends JsiiSerializable {
        @NotNull
        public String getAddress();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SubscriberProperty> {
            private String address;
            private String type;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public SubscriberProperty build() {
                return new Jsii.Proxy(this.address, this.type);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_budgets.CfnBudgetsAction.SsmActionDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SsmActionDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getInstanceIds();

        @NotNull
        public String getRegion();

        @NotNull
        public String getSubtype();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SsmActionDefinitionProperty> {
            private List<String> instanceIds;
            private String region;
            private String subtype;

            public Builder instanceIds(List<String> instanceIds) {
                this.instanceIds = instanceIds;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder subtype(String subtype) {
                this.subtype = subtype;
                return this;
            }

            public SsmActionDefinitionProperty build() {
                return new Jsii.Proxy(this.instanceIds, this.region, this.subtype);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_budgets.CfnBudgetsAction.ScpActionDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScpActionDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getPolicyId();

        @NotNull
        public List<String> getTargetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScpActionDefinitionProperty> {
            private String policyId;
            private List<String> targetIds;

            public Builder policyId(String policyId) {
                this.policyId = policyId;
                return this;
            }

            public Builder targetIds(List<String> targetIds) {
                this.targetIds = targetIds;
                return this;
            }

            public ScpActionDefinitionProperty build() {
                return new Jsii.Proxy(this.policyId, this.targetIds);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_budgets.CfnBudgetsAction.IamActionDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamActionDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getPolicyArn();

        @Nullable
        default public List<String> getGroups() {
            return null;
        }

        @Nullable
        default public List<String> getRoles() {
            return null;
        }

        @Nullable
        default public List<String> getUsers() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamActionDefinitionProperty> {
            private String policyArn;
            private List<String> groups;
            private List<String> roles;
            private List<String> users;

            public Builder policyArn(String policyArn) {
                this.policyArn = policyArn;
                return this;
            }

            public Builder groups(List<String> groups) {
                this.groups = groups;
                return this;
            }

            public Builder roles(List<String> roles) {
                this.roles = roles;
                return this;
            }

            public Builder users(List<String> users) {
                this.users = users;
                return this;
            }

            public IamActionDefinitionProperty build() {
                return new Jsii.Proxy(this.policyArn, this.groups, this.roles, this.users);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_budgets.CfnBudgetsAction.DefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIamActionDefinition() {
            return null;
        }

        @Nullable
        default public Object getScpActionDefinition() {
            return null;
        }

        @Nullable
        default public Object getSsmActionDefinition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefinitionProperty> {
            private Object iamActionDefinition;
            private Object scpActionDefinition;
            private Object ssmActionDefinition;

            public Builder iamActionDefinition(IamActionDefinitionProperty iamActionDefinition) {
                this.iamActionDefinition = iamActionDefinition;
                return this;
            }

            public Builder iamActionDefinition(IResolvable iamActionDefinition) {
                this.iamActionDefinition = iamActionDefinition;
                return this;
            }

            public Builder scpActionDefinition(ScpActionDefinitionProperty scpActionDefinition) {
                this.scpActionDefinition = scpActionDefinition;
                return this;
            }

            public Builder scpActionDefinition(IResolvable scpActionDefinition) {
                this.scpActionDefinition = scpActionDefinition;
                return this;
            }

            public Builder ssmActionDefinition(SsmActionDefinitionProperty ssmActionDefinition) {
                this.ssmActionDefinition = ssmActionDefinition;
                return this;
            }

            public Builder ssmActionDefinition(IResolvable ssmActionDefinition) {
                this.ssmActionDefinition = ssmActionDefinition;
                return this;
            }

            public DefinitionProperty build() {
                return new Jsii.Proxy(this.iamActionDefinition, this.scpActionDefinition, this.ssmActionDefinition);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_budgets.CfnBudgetsAction.ActionThresholdProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionThresholdProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public Number getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionThresholdProperty> {
            private String type;
            private Number value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public ActionThresholdProperty build() {
                return new Jsii.Proxy(this.type, this.value);
            }
        }
    }
}

