/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.MathExpressionOptions;
import software.amazon.awscdk.services.cloudwatch.MathExpressionProps;
import software.amazon.awscdk.services.cloudwatch.MetricConfig;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudwatch.MathExpression")
public class MathExpression
extends JsiiObject
implements IMetric {
    protected MathExpression(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MathExpression(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public MathExpression(@NotNull MathExpressionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Alarm createAlarm(@NotNull Construct scope, @NotNull String id, @NotNull CreateAlarmOptions props) {
        return (Alarm)Kernel.call((Object)this, (String)"createAlarm", (NativeType)NativeType.forClass(Alarm.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public MetricConfig toMetricConfig() {
        return (MetricConfig)Kernel.call((Object)this, (String)"toMetricConfig", (NativeType)NativeType.forClass(MetricConfig.class), (Object[])new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)Kernel.call((Object)this, (String)"toString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public MathExpression with(@NotNull MathExpressionOptions props) {
        return (MathExpression)Kernel.call((Object)this, (String)"with", (NativeType)NativeType.forClass(MathExpression.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public String getExpression() {
        return (String)Kernel.get((Object)this, (String)"expression", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Duration getPeriod() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"period", (NativeType)NativeType.forClass(Duration.class)));
    }

    @NotNull
    public Map<String, IMetric> getUsingMetrics() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"usingMetrics", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(IMetric.class))));
    }

    @Nullable
    public String getColor() {
        return (String)Kernel.get((Object)this, (String)"color", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getLabel() {
        return (String)Kernel.get((Object)this, (String)"label", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<MathExpression> {
        private final MathExpressionProps.Builder props = new MathExpressionProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder color(String color) {
            this.props.color(color);
            return this;
        }

        public Builder label(String label) {
            this.props.label(label);
            return this;
        }

        public Builder period(Duration period) {
            this.props.period(period);
            return this;
        }

        public Builder expression(String expression) {
            this.props.expression(expression);
            return this;
        }

        public Builder usingMetrics(Map<String, ? extends IMetric> usingMetrics) {
            this.props.usingMetrics(usingMetrics);
            return this;
        }

        public MathExpression build() {
            return new MathExpression(this.props.build());
        }
    }
}

