/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable;
import software.amazon.awscdk.services.codebuild.IProject;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.CodeBuildActionProps;
import software.amazon.awscdk.services.codepipeline.actions.CodeBuildActionType;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codepipeline_actions.CodeBuildActionProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface CodeBuildActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    @NotNull
    public Artifact getInput();

    @NotNull
    public IProject getProject();

    @Nullable
    default public Boolean getCheckSecretsInPlainTextEnvVariables() {
        return null;
    }

    @Nullable
    default public Boolean getCombineBatchBuildArtifacts() {
        return null;
    }

    @Nullable
    default public Map<String, BuildEnvironmentVariable> getEnvironmentVariables() {
        return null;
    }

    @Nullable
    default public Boolean getExecuteBatchBuild() {
        return null;
    }

    @Nullable
    default public List<Artifact> getExtraInputs() {
        return null;
    }

    @Nullable
    default public List<Artifact> getOutputs() {
        return null;
    }

    @Nullable
    default public CodeBuildActionType getType() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CodeBuildActionProps> {
        private Artifact input;
        private IProject project;
        private Boolean checkSecretsInPlainTextEnvVariables;
        private Boolean combineBatchBuildArtifacts;
        private Map<String, BuildEnvironmentVariable> environmentVariables;
        private Boolean executeBatchBuild;
        private List<Artifact> extraInputs;
        private List<Artifact> outputs;
        private CodeBuildActionType type;
        private IRole role;
        private String actionName;
        private Number runOrder;
        private String variablesNamespace;

        public Builder input(Artifact input) {
            this.input = input;
            return this;
        }

        public Builder project(IProject project) {
            this.project = project;
            return this;
        }

        public Builder checkSecretsInPlainTextEnvVariables(Boolean checkSecretsInPlainTextEnvVariables) {
            this.checkSecretsInPlainTextEnvVariables = checkSecretsInPlainTextEnvVariables;
            return this;
        }

        public Builder combineBatchBuildArtifacts(Boolean combineBatchBuildArtifacts) {
            this.combineBatchBuildArtifacts = combineBatchBuildArtifacts;
            return this;
        }

        public Builder environmentVariables(Map<String, ? extends BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public Builder executeBatchBuild(Boolean executeBatchBuild) {
            this.executeBatchBuild = executeBatchBuild;
            return this;
        }

        public Builder extraInputs(List<? extends Artifact> extraInputs) {
            this.extraInputs = extraInputs;
            return this;
        }

        public Builder outputs(List<? extends Artifact> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Builder type(CodeBuildActionType type) {
            this.type = type;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public Builder variablesNamespace(String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        public CodeBuildActionProps build() {
            return new Jsii.Proxy(this.input, this.project, this.checkSecretsInPlainTextEnvVariables, this.combineBatchBuildArtifacts, this.environmentVariables, this.executeBatchBuild, this.extraInputs, this.outputs, this.type, this.role, this.actionName, this.runOrder, this.variablesNamespace);
        }
    }
}

