/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Stack;
import software.amazon.awscdk.services.ec2.BastionHostLinuxProps;
import software.amazon.awscdk.services.ec2.BlockDevice;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IInstance;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.IPeer;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.Instance;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.BastionHostLinux")
public class BastionHostLinux
extends Resource
implements IInstance {
    protected BastionHostLinux(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BastionHostLinux(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public BastionHostLinux(@NotNull Construct scope, @NotNull String id, @NotNull BastionHostLinuxProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void allowSshAccessFrom(IPeer ... peer) {
        Kernel.call((Object)this, (String)"allowSshAccessFrom", (NativeType)NativeType.VOID, (Object[])Arrays.stream(peer).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public Instance getInstance() {
        return (Instance)Kernel.get((Object)this, (String)"instance", (NativeType)NativeType.forClass(Instance.class));
    }

    @Override
    @NotNull
    public String getInstanceAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"instanceAvailabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getInstanceId() {
        return (String)Kernel.get((Object)this, (String)"instanceId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getInstancePrivateDnsName() {
        return (String)Kernel.get((Object)this, (String)"instancePrivateDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getInstancePrivateIp() {
        return (String)Kernel.get((Object)this, (String)"instancePrivateIp", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getInstancePublicDnsName() {
        return (String)Kernel.get((Object)this, (String)"instancePublicDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getInstancePublicIp() {
        return (String)Kernel.get((Object)this, (String)"instancePublicIp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public Stack getStack() {
        return (Stack)Kernel.get((Object)this, (String)"stack", (NativeType)NativeType.forClass(Stack.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BastionHostLinux> {
        private final Construct scope;
        private final String id;
        private final BastionHostLinuxProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new BastionHostLinuxProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public BastionHostLinux build() {
            return new BastionHostLinux(this.scope, this.id, this.props.build());
        }
    }
}

