/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.ClusterOptions;
import software.amazon.awscdk.services.eks.ClusterProps;
import software.amazon.awscdk.services.eks.CoreDnsComputeType;
import software.amazon.awscdk.services.eks.DefaultCapacityType;
import software.amazon.awscdk.services.eks.EndpointAccess;
import software.amazon.awscdk.services.eks.KubernetesVersion;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.ILayerVersion;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_eks.ClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ClusterProps
extends JsiiSerializable,
ClusterOptions {
    @Nullable
    default public Number getDefaultCapacity() {
        return null;
    }

    @Nullable
    default public InstanceType getDefaultCapacityInstance() {
        return null;
    }

    @Nullable
    default public DefaultCapacityType getDefaultCapacityType() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ClusterProps> {
        private Number defaultCapacity;
        private InstanceType defaultCapacityInstance;
        private DefaultCapacityType defaultCapacityType;
        private Map<String, String> clusterHandlerEnvironment;
        private CoreDnsComputeType coreDnsComputeType;
        private EndpointAccess endpointAccess;
        private Map<String, String> kubectlEnvironment;
        private ILayerVersion kubectlLayer;
        private Size kubectlMemory;
        private IRole mastersRole;
        private Boolean outputMastersRoleArn;
        private Boolean placeClusterHandlerInVpc;
        private Boolean prune;
        private IKey secretsEncryptionKey;
        private KubernetesVersion version;
        private String clusterName;
        private Boolean outputClusterName;
        private Boolean outputConfigCommand;
        private IRole role;
        private ISecurityGroup securityGroup;
        private IVpc vpc;
        private List<SubnetSelection> vpcSubnets;

        public Builder defaultCapacity(Number defaultCapacity) {
            this.defaultCapacity = defaultCapacity;
            return this;
        }

        public Builder defaultCapacityInstance(InstanceType defaultCapacityInstance) {
            this.defaultCapacityInstance = defaultCapacityInstance;
            return this;
        }

        public Builder defaultCapacityType(DefaultCapacityType defaultCapacityType) {
            this.defaultCapacityType = defaultCapacityType;
            return this;
        }

        public Builder clusterHandlerEnvironment(Map<String, String> clusterHandlerEnvironment) {
            this.clusterHandlerEnvironment = clusterHandlerEnvironment;
            return this;
        }

        public Builder coreDnsComputeType(CoreDnsComputeType coreDnsComputeType) {
            this.coreDnsComputeType = coreDnsComputeType;
            return this;
        }

        public Builder endpointAccess(EndpointAccess endpointAccess) {
            this.endpointAccess = endpointAccess;
            return this;
        }

        public Builder kubectlEnvironment(Map<String, String> kubectlEnvironment) {
            this.kubectlEnvironment = kubectlEnvironment;
            return this;
        }

        public Builder kubectlLayer(ILayerVersion kubectlLayer) {
            this.kubectlLayer = kubectlLayer;
            return this;
        }

        public Builder kubectlMemory(Size kubectlMemory) {
            this.kubectlMemory = kubectlMemory;
            return this;
        }

        public Builder mastersRole(IRole mastersRole) {
            this.mastersRole = mastersRole;
            return this;
        }

        public Builder outputMastersRoleArn(Boolean outputMastersRoleArn) {
            this.outputMastersRoleArn = outputMastersRoleArn;
            return this;
        }

        public Builder placeClusterHandlerInVpc(Boolean placeClusterHandlerInVpc) {
            this.placeClusterHandlerInVpc = placeClusterHandlerInVpc;
            return this;
        }

        public Builder prune(Boolean prune) {
            this.prune = prune;
            return this;
        }

        public Builder secretsEncryptionKey(IKey secretsEncryptionKey) {
            this.secretsEncryptionKey = secretsEncryptionKey;
            return this;
        }

        public Builder version(KubernetesVersion version) {
            this.version = version;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder outputClusterName(Boolean outputClusterName) {
            this.outputClusterName = outputClusterName;
            return this;
        }

        public Builder outputConfigCommand(Boolean outputConfigCommand) {
            this.outputConfigCommand = outputConfigCommand;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder vpcSubnets(List<? extends SubnetSelection> vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public ClusterProps build() {
            return new Jsii.Proxy(this.defaultCapacity, this.defaultCapacityInstance, this.defaultCapacityType, this.clusterHandlerEnvironment, this.coreDnsComputeType, this.endpointAccess, this.kubectlEnvironment, this.kubectlLayer, this.kubectlMemory, this.mastersRole, this.outputMastersRoleArn, this.placeClusterHandlerInVpc, this.prune, this.secretsEncryptionKey, this.version, this.clusterName, this.outputClusterName, this.outputConfigCommand, this.role, this.securityGroup, this.vpc, this.vpcSubnets);
        }
    }
}

