/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.eks.KubernetesObjectValueProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_eks.KubernetesObjectValueProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface KubernetesObjectValueProps
extends JsiiSerializable {
    @NotNull
    public ICluster getCluster();

    @NotNull
    public String getJsonPath();

    @NotNull
    public String getObjectName();

    @NotNull
    public String getObjectType();

    @Nullable
    default public String getObjectNamespace() {
        return null;
    }

    @Nullable
    default public Duration getTimeout() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<KubernetesObjectValueProps> {
        private ICluster cluster;
        private String jsonPath;
        private String objectName;
        private String objectType;
        private String objectNamespace;
        private Duration timeout;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder objectNamespace(String objectNamespace) {
            this.objectNamespace = objectNamespace;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public KubernetesObjectValueProps build() {
            return new Jsii.Proxy(this.cluster, this.jsonPath, this.objectName, this.objectType, this.objectNamespace, this.timeout);
        }
    }
}

