/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.fms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.fms.CfnPolicy;
import software.amazon.awscdk.services.fms.CfnPolicyProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fms.CfnPolicy")
public class CfnPolicy
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnPolicy.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnPolicy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPolicy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnPolicy(@NotNull Construct scope, @NotNull String id, @NotNull CfnPolicyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getExcludeResourceTags() {
        return Kernel.get((Object)this, (String)"excludeResourceTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setExcludeResourceTags(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"excludeResourceTags", (Object)Objects.requireNonNull(value, "excludeResourceTags is required"));
    }

    public void setExcludeResourceTags(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"excludeResourceTags", (Object)Objects.requireNonNull(value, "excludeResourceTags is required"));
    }

    @NotNull
    public String getPolicyName() {
        return (String)Kernel.get((Object)this, (String)"policyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setPolicyName(@NotNull String value) {
        Kernel.set((Object)this, (String)"policyName", (Object)Objects.requireNonNull(value, "policyName is required"));
    }

    @NotNull
    public Object getRemediationEnabled() {
        return Kernel.get((Object)this, (String)"remediationEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRemediationEnabled(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"remediationEnabled", (Object)Objects.requireNonNull(value, "remediationEnabled is required"));
    }

    public void setRemediationEnabled(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"remediationEnabled", (Object)Objects.requireNonNull(value, "remediationEnabled is required"));
    }

    @NotNull
    public String getResourceType() {
        return (String)Kernel.get((Object)this, (String)"resourceType", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceType(@NotNull String value) {
        Kernel.set((Object)this, (String)"resourceType", (Object)Objects.requireNonNull(value, "resourceType is required"));
    }

    @NotNull
    public Object getSecurityServicePolicyData() {
        return Kernel.get((Object)this, (String)"securityServicePolicyData", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSecurityServicePolicyData(@NotNull Object value) {
        Kernel.set((Object)this, (String)"securityServicePolicyData", (Object)Objects.requireNonNull(value, "securityServicePolicyData is required"));
    }

    @Nullable
    public Object getDeleteAllPolicyResources() {
        return Kernel.get((Object)this, (String)"deleteAllPolicyResources", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeleteAllPolicyResources(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"deleteAllPolicyResources", (Object)value);
    }

    public void setDeleteAllPolicyResources(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deleteAllPolicyResources", (Object)value);
    }

    @Nullable
    public Object getExcludeMap() {
        return Kernel.get((Object)this, (String)"excludeMap", (NativeType)NativeType.forClass(Object.class));
    }

    public void setExcludeMap(@Nullable IEMapProperty value) {
        Kernel.set((Object)this, (String)"excludeMap", (Object)value);
    }

    public void setExcludeMap(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"excludeMap", (Object)value);
    }

    @Nullable
    public Object getIncludeMap() {
        return Kernel.get((Object)this, (String)"includeMap", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIncludeMap(@Nullable IEMapProperty value) {
        Kernel.set((Object)this, (String)"includeMap", (Object)value);
    }

    public void setIncludeMap(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"includeMap", (Object)value);
    }

    @Nullable
    public Object getResourceTags() {
        return Kernel.get((Object)this, (String)"resourceTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setResourceTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"resourceTags", (Object)value);
    }

    public void setResourceTags(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"resourceTags", value);
    }

    @Nullable
    public List<String> getResourceTypeList() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"resourceTypeList", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setResourceTypeList(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"resourceTypeList", value);
    }

    @Nullable
    public List<PolicyTagProperty> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyTagProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<PolicyTagProperty> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnPolicy> {
        private final Construct scope;
        private final String id;
        private final CfnPolicyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnPolicyProps.Builder();
        }

        public Builder excludeResourceTags(Boolean excludeResourceTags) {
            this.props.excludeResourceTags(excludeResourceTags);
            return this;
        }

        public Builder excludeResourceTags(IResolvable excludeResourceTags) {
            this.props.excludeResourceTags(excludeResourceTags);
            return this;
        }

        public Builder policyName(String policyName) {
            this.props.policyName(policyName);
            return this;
        }

        public Builder remediationEnabled(Boolean remediationEnabled) {
            this.props.remediationEnabled(remediationEnabled);
            return this;
        }

        public Builder remediationEnabled(IResolvable remediationEnabled) {
            this.props.remediationEnabled(remediationEnabled);
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        public Builder securityServicePolicyData(Object securityServicePolicyData) {
            this.props.securityServicePolicyData(securityServicePolicyData);
            return this;
        }

        public Builder deleteAllPolicyResources(Boolean deleteAllPolicyResources) {
            this.props.deleteAllPolicyResources(deleteAllPolicyResources);
            return this;
        }

        public Builder deleteAllPolicyResources(IResolvable deleteAllPolicyResources) {
            this.props.deleteAllPolicyResources(deleteAllPolicyResources);
            return this;
        }

        public Builder excludeMap(IEMapProperty excludeMap) {
            this.props.excludeMap(excludeMap);
            return this;
        }

        public Builder excludeMap(IResolvable excludeMap) {
            this.props.excludeMap(excludeMap);
            return this;
        }

        public Builder includeMap(IEMapProperty includeMap) {
            this.props.includeMap(includeMap);
            return this;
        }

        public Builder includeMap(IResolvable includeMap) {
            this.props.includeMap(includeMap);
            return this;
        }

        public Builder resourceTags(IResolvable resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        public Builder resourceTags(List<? extends Object> resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        public Builder resourceTypeList(List<String> resourceTypeList) {
            this.props.resourceTypeList(resourceTypeList);
            return this;
        }

        public Builder tags(List<? extends PolicyTagProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnPolicy build() {
            return new CfnPolicy(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fms.CfnPolicy.ResourceTagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceTagProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceTagProperty> {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ResourceTagProperty build() {
                return new Jsii.Proxy(this.key, this.value);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fms.CfnPolicy.PolicyTagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PolicyTagProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PolicyTagProperty> {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public PolicyTagProperty build() {
                return new Jsii.Proxy(this.key, this.value);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fms.CfnPolicy.IEMapProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IEMapProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAccount() {
            return null;
        }

        @Nullable
        default public List<String> getOrgunit() {
            return null;
        }
    }
}

