/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.fsx;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.fsx.CfnFileSystem;
import software.amazon.awscdk.services.fsx.CfnFileSystemProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fsx.CfnFileSystem")
public class CfnFileSystem
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFileSystem.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFileSystem(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFileSystem(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFileSystem(@NotNull Construct scope, @NotNull String id, @NotNull CfnFileSystemProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDnsName() {
        return (String)Kernel.get((Object)this, (String)"attrDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLustreMountName() {
        return (String)Kernel.get((Object)this, (String)"attrLustreMountName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getFileSystemType() {
        return (String)Kernel.get((Object)this, (String)"fileSystemType", (NativeType)NativeType.forClass(String.class));
    }

    public void setFileSystemType(@NotNull String value) {
        Kernel.set((Object)this, (String)"fileSystemType", (Object)Objects.requireNonNull(value, "fileSystemType is required"));
    }

    @NotNull
    public List<String> getSubnetIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"subnetIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setSubnetIds(@NotNull List<String> value) {
        Kernel.set((Object)this, (String)"subnetIds", Objects.requireNonNull(value, "subnetIds is required"));
    }

    @Nullable
    public String getBackupId() {
        return (String)Kernel.get((Object)this, (String)"backupId", (NativeType)NativeType.forClass(String.class));
    }

    public void setBackupId(@Nullable String value) {
        Kernel.set((Object)this, (String)"backupId", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public Object getLustreConfiguration() {
        return Kernel.get((Object)this, (String)"lustreConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLustreConfiguration(@Nullable LustreConfigurationProperty value) {
        Kernel.set((Object)this, (String)"lustreConfiguration", (Object)value);
    }

    public void setLustreConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lustreConfiguration", (Object)value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"securityGroupIds", value);
    }

    @Nullable
    public Number getStorageCapacity() {
        return (Number)Kernel.get((Object)this, (String)"storageCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setStorageCapacity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"storageCapacity", (Object)value);
    }

    @Nullable
    public String getStorageType() {
        return (String)Kernel.get((Object)this, (String)"storageType", (NativeType)NativeType.forClass(String.class));
    }

    public void setStorageType(@Nullable String value) {
        Kernel.set((Object)this, (String)"storageType", (Object)value);
    }

    @Nullable
    public Object getWindowsConfiguration() {
        return Kernel.get((Object)this, (String)"windowsConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setWindowsConfiguration(@Nullable WindowsConfigurationProperty value) {
        Kernel.set((Object)this, (String)"windowsConfiguration", (Object)value);
    }

    public void setWindowsConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"windowsConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFileSystem> {
        private final Construct scope;
        private final String id;
        private final CfnFileSystemProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFileSystemProps.Builder();
        }

        public Builder fileSystemType(String fileSystemType) {
            this.props.fileSystemType(fileSystemType);
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        public Builder backupId(String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder lustreConfiguration(LustreConfigurationProperty lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }

        public Builder lustreConfiguration(IResolvable lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder storageCapacity(Number storageCapacity) {
            this.props.storageCapacity(storageCapacity);
            return this;
        }

        public Builder storageType(String storageType) {
            this.props.storageType(storageType);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder windowsConfiguration(WindowsConfigurationProperty windowsConfiguration) {
            this.props.windowsConfiguration(windowsConfiguration);
            return this;
        }

        public Builder windowsConfiguration(IResolvable windowsConfiguration) {
            this.props.windowsConfiguration(windowsConfiguration);
            return this;
        }

        public CfnFileSystem build() {
            return new CfnFileSystem(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fsx.CfnFileSystem.WindowsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WindowsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getThroughputCapacity();

        @Nullable
        default public String getActiveDirectoryId() {
            return null;
        }

        @Nullable
        default public List<String> getAliases() {
            return null;
        }

        @Nullable
        default public Number getAutomaticBackupRetentionDays() {
            return null;
        }

        @Nullable
        default public Object getCopyTagsToBackups() {
            return null;
        }

        @Nullable
        default public String getDailyAutomaticBackupStartTime() {
            return null;
        }

        @Nullable
        default public String getDeploymentType() {
            return null;
        }

        @Nullable
        default public String getPreferredSubnetId() {
            return null;
        }

        @Nullable
        default public Object getSelfManagedActiveDirectoryConfiguration() {
            return null;
        }

        @Nullable
        default public String getWeeklyMaintenanceStartTime() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WindowsConfigurationProperty> {
            private Number throughputCapacity;
            private String activeDirectoryId;
            private List<String> aliases;
            private Number automaticBackupRetentionDays;
            private Object copyTagsToBackups;
            private String dailyAutomaticBackupStartTime;
            private String deploymentType;
            private String preferredSubnetId;
            private Object selfManagedActiveDirectoryConfiguration;
            private String weeklyMaintenanceStartTime;

            public Builder throughputCapacity(Number throughputCapacity) {
                this.throughputCapacity = throughputCapacity;
                return this;
            }

            public Builder activeDirectoryId(String activeDirectoryId) {
                this.activeDirectoryId = activeDirectoryId;
                return this;
            }

            public Builder aliases(List<String> aliases) {
                this.aliases = aliases;
                return this;
            }

            public Builder automaticBackupRetentionDays(Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            public Builder copyTagsToBackups(Boolean copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            public Builder copyTagsToBackups(IResolvable copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            public Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            public Builder deploymentType(String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            public Builder preferredSubnetId(String preferredSubnetId) {
                this.preferredSubnetId = preferredSubnetId;
                return this;
            }

            public Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationProperty selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            public Builder selfManagedActiveDirectoryConfiguration(IResolvable selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            public Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            public WindowsConfigurationProperty build() {
                return new Jsii.Proxy(this.throughputCapacity, this.activeDirectoryId, this.aliases, this.automaticBackupRetentionDays, this.copyTagsToBackups, this.dailyAutomaticBackupStartTime, this.deploymentType, this.preferredSubnetId, this.selfManagedActiveDirectoryConfiguration, this.weeklyMaintenanceStartTime);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fsx.CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SelfManagedActiveDirectoryConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getDnsIps() {
            return null;
        }

        @Nullable
        default public String getDomainName() {
            return null;
        }

        @Nullable
        default public String getFileSystemAdministratorsGroup() {
            return null;
        }

        @Nullable
        default public String getOrganizationalUnitDistinguishedName() {
            return null;
        }

        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public String getUserName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SelfManagedActiveDirectoryConfigurationProperty> {
            private List<String> dnsIps;
            private String domainName;
            private String fileSystemAdministratorsGroup;
            private String organizationalUnitDistinguishedName;
            private String password;
            private String userName;

            public Builder dnsIps(List<String> dnsIps) {
                this.dnsIps = dnsIps;
                return this;
            }

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public Builder fileSystemAdministratorsGroup(String fileSystemAdministratorsGroup) {
                this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
                return this;
            }

            public Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
                this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
                return this;
            }

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder userName(String userName) {
                this.userName = userName;
                return this;
            }

            public SelfManagedActiveDirectoryConfigurationProperty build() {
                return new Jsii.Proxy(this.dnsIps, this.domainName, this.fileSystemAdministratorsGroup, this.organizationalUnitDistinguishedName, this.password, this.userName);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_fsx.CfnFileSystem.LustreConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LustreConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAutoImportPolicy() {
            return null;
        }

        @Nullable
        default public Number getAutomaticBackupRetentionDays() {
            return null;
        }

        @Nullable
        default public Object getCopyTagsToBackups() {
            return null;
        }

        @Nullable
        default public String getDailyAutomaticBackupStartTime() {
            return null;
        }

        @Nullable
        default public String getDataCompressionType() {
            return null;
        }

        @Nullable
        default public String getDeploymentType() {
            return null;
        }

        @Nullable
        default public String getDriveCacheType() {
            return null;
        }

        @Nullable
        default public String getExportPath() {
            return null;
        }

        @Nullable
        default public Number getImportedFileChunkSize() {
            return null;
        }

        @Nullable
        default public String getImportPath() {
            return null;
        }

        @Nullable
        default public Number getPerUnitStorageThroughput() {
            return null;
        }

        @Nullable
        default public String getWeeklyMaintenanceStartTime() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LustreConfigurationProperty> {
            private String autoImportPolicy;
            private Number automaticBackupRetentionDays;
            private Object copyTagsToBackups;
            private String dailyAutomaticBackupStartTime;
            private String dataCompressionType;
            private String deploymentType;
            private String driveCacheType;
            private String exportPath;
            private Number importedFileChunkSize;
            private String importPath;
            private Number perUnitStorageThroughput;
            private String weeklyMaintenanceStartTime;

            public Builder autoImportPolicy(String autoImportPolicy) {
                this.autoImportPolicy = autoImportPolicy;
                return this;
            }

            public Builder automaticBackupRetentionDays(Number automaticBackupRetentionDays) {
                this.automaticBackupRetentionDays = automaticBackupRetentionDays;
                return this;
            }

            public Builder copyTagsToBackups(Boolean copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            public Builder copyTagsToBackups(IResolvable copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            public Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
                this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
                return this;
            }

            public Builder dataCompressionType(String dataCompressionType) {
                this.dataCompressionType = dataCompressionType;
                return this;
            }

            public Builder deploymentType(String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            public Builder driveCacheType(String driveCacheType) {
                this.driveCacheType = driveCacheType;
                return this;
            }

            public Builder exportPath(String exportPath) {
                this.exportPath = exportPath;
                return this;
            }

            public Builder importedFileChunkSize(Number importedFileChunkSize) {
                this.importedFileChunkSize = importedFileChunkSize;
                return this;
            }

            public Builder importPath(String importPath) {
                this.importPath = importPath;
                return this;
            }

            public Builder perUnitStorageThroughput(Number perUnitStorageThroughput) {
                this.perUnitStorageThroughput = perUnitStorageThroughput;
                return this;
            }

            public Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
                this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
                return this;
            }

            public LustreConfigurationProperty build() {
                return new Jsii.Proxy(this.autoImportPolicy, this.automaticBackupRetentionDays, this.copyTagsToBackups, this.dailyAutomaticBackupStartTime, this.dataCompressionType, this.deploymentType, this.driveCacheType, this.exportPath, this.importedFileChunkSize, this.importPath, this.perUnitStorageThroughput, this.weeklyMaintenanceStartTime);
            }
        }
    }
}

