/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.globalaccelerator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.globalaccelerator.CfnEndpointGroup;
import software.amazon.awscdk.services.globalaccelerator.CfnEndpointGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_globalaccelerator.CfnEndpointGroup")
public class CfnEndpointGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEndpointGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnEndpointGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpointGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEndpointGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnEndpointGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrEndpointGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getEndpointGroupRegion() {
        return (String)Kernel.get((Object)this, (String)"endpointGroupRegion", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpointGroupRegion(@NotNull String value) {
        Kernel.set((Object)this, (String)"endpointGroupRegion", (Object)Objects.requireNonNull(value, "endpointGroupRegion is required"));
    }

    @NotNull
    public String getListenerArn() {
        return (String)Kernel.get((Object)this, (String)"listenerArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setListenerArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"listenerArn", (Object)Objects.requireNonNull(value, "listenerArn is required"));
    }

    @Nullable
    public Object getEndpointConfigurations() {
        return Kernel.get((Object)this, (String)"endpointConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEndpointConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"endpointConfigurations", (Object)value);
    }

    public void setEndpointConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"endpointConfigurations", value);
    }

    @Nullable
    public Number getHealthCheckIntervalSeconds() {
        return (Number)Kernel.get((Object)this, (String)"healthCheckIntervalSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setHealthCheckIntervalSeconds(@Nullable Number value) {
        Kernel.set((Object)this, (String)"healthCheckIntervalSeconds", (Object)value);
    }

    @Nullable
    public String getHealthCheckPath() {
        return (String)Kernel.get((Object)this, (String)"healthCheckPath", (NativeType)NativeType.forClass(String.class));
    }

    public void setHealthCheckPath(@Nullable String value) {
        Kernel.set((Object)this, (String)"healthCheckPath", (Object)value);
    }

    @Nullable
    public Number getHealthCheckPort() {
        return (Number)Kernel.get((Object)this, (String)"healthCheckPort", (NativeType)NativeType.forClass(Number.class));
    }

    public void setHealthCheckPort(@Nullable Number value) {
        Kernel.set((Object)this, (String)"healthCheckPort", (Object)value);
    }

    @Nullable
    public String getHealthCheckProtocol() {
        return (String)Kernel.get((Object)this, (String)"healthCheckProtocol", (NativeType)NativeType.forClass(String.class));
    }

    public void setHealthCheckProtocol(@Nullable String value) {
        Kernel.set((Object)this, (String)"healthCheckProtocol", (Object)value);
    }

    @Nullable
    public Object getPortOverrides() {
        return Kernel.get((Object)this, (String)"portOverrides", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPortOverrides(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"portOverrides", (Object)value);
    }

    public void setPortOverrides(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"portOverrides", value);
    }

    @Nullable
    public Number getThresholdCount() {
        return (Number)Kernel.get((Object)this, (String)"thresholdCount", (NativeType)NativeType.forClass(Number.class));
    }

    public void setThresholdCount(@Nullable Number value) {
        Kernel.set((Object)this, (String)"thresholdCount", (Object)value);
    }

    @Nullable
    public Number getTrafficDialPercentage() {
        return (Number)Kernel.get((Object)this, (String)"trafficDialPercentage", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTrafficDialPercentage(@Nullable Number value) {
        Kernel.set((Object)this, (String)"trafficDialPercentage", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEndpointGroup> {
        private final Construct scope;
        private final String id;
        private final CfnEndpointGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEndpointGroupProps.Builder();
        }

        public Builder endpointGroupRegion(String endpointGroupRegion) {
            this.props.endpointGroupRegion(endpointGroupRegion);
            return this;
        }

        public Builder listenerArn(String listenerArn) {
            this.props.listenerArn(listenerArn);
            return this;
        }

        public Builder endpointConfigurations(IResolvable endpointConfigurations) {
            this.props.endpointConfigurations(endpointConfigurations);
            return this;
        }

        public Builder endpointConfigurations(List<? extends Object> endpointConfigurations) {
            this.props.endpointConfigurations(endpointConfigurations);
            return this;
        }

        public Builder healthCheckIntervalSeconds(Number healthCheckIntervalSeconds) {
            this.props.healthCheckIntervalSeconds(healthCheckIntervalSeconds);
            return this;
        }

        public Builder healthCheckPath(String healthCheckPath) {
            this.props.healthCheckPath(healthCheckPath);
            return this;
        }

        public Builder healthCheckPort(Number healthCheckPort) {
            this.props.healthCheckPort(healthCheckPort);
            return this;
        }

        public Builder healthCheckProtocol(String healthCheckProtocol) {
            this.props.healthCheckProtocol(healthCheckProtocol);
            return this;
        }

        public Builder portOverrides(IResolvable portOverrides) {
            this.props.portOverrides(portOverrides);
            return this;
        }

        public Builder portOverrides(List<? extends Object> portOverrides) {
            this.props.portOverrides(portOverrides);
            return this;
        }

        public Builder thresholdCount(Number thresholdCount) {
            this.props.thresholdCount(thresholdCount);
            return this;
        }

        public Builder trafficDialPercentage(Number trafficDialPercentage) {
            this.props.trafficDialPercentage(trafficDialPercentage);
            return this;
        }

        public CfnEndpointGroup build() {
            return new CfnEndpointGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_globalaccelerator.CfnEndpointGroup.PortOverrideProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PortOverrideProperty
    extends JsiiSerializable {
        @NotNull
        public Number getEndpointPort();

        @NotNull
        public Number getListenerPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PortOverrideProperty> {
            private Number endpointPort;
            private Number listenerPort;

            public Builder endpointPort(Number endpointPort) {
                this.endpointPort = endpointPort;
                return this;
            }

            public Builder listenerPort(Number listenerPort) {
                this.listenerPort = listenerPort;
                return this;
            }

            public PortOverrideProperty build() {
                return new Jsii.Proxy(this.endpointPort, this.listenerPort);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_globalaccelerator.CfnEndpointGroup.EndpointConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpointId();

        @Nullable
        default public Object getClientIpPreservationEnabled() {
            return null;
        }

        @Nullable
        default public Number getWeight() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointConfigurationProperty> {
            private String endpointId;
            private Object clientIpPreservationEnabled;
            private Number weight;

            public Builder endpointId(String endpointId) {
                this.endpointId = endpointId;
                return this;
            }

            public Builder clientIpPreservationEnabled(Boolean clientIpPreservationEnabled) {
                this.clientIpPreservationEnabled = clientIpPreservationEnabled;
                return this;
            }

            public Builder clientIpPreservationEnabled(IResolvable clientIpPreservationEnabled) {
                this.clientIpPreservationEnabled = clientIpPreservationEnabled;
                return this;
            }

            public Builder weight(Number weight) {
                this.weight = weight;
                return this;
            }

            public EndpointConfigurationProperty build() {
                return new Jsii.Proxy(this.endpointId, this.clientIpPreservationEnabled, this.weight);
            }
        }
    }
}

