/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisanalytics;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2Props;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputV2")
public class CfnApplicationOutputV2
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplicationOutputV2.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplicationOutputV2(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationOutputV2(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplicationOutputV2(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationOutputV2Props props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApplicationName() {
        return (String)Kernel.get((Object)this, (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationName(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationName", (Object)Objects.requireNonNull(value, "applicationName is required"));
    }

    @NotNull
    public Object getOutput() {
        return Kernel.get((Object)this, (String)"output", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOutput(@NotNull OutputProperty value) {
        Kernel.set((Object)this, (String)"output", (Object)Objects.requireNonNull(value, "output is required"));
    }

    public void setOutput(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"output", (Object)Objects.requireNonNull(value, "output is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplicationOutputV2> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationOutputV2Props.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationOutputV2Props.Builder();
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder output(OutputProperty output) {
            this.props.output(output);
            return this;
        }

        public Builder output(IResolvable output) {
            this.props.output(output);
            return this;
        }

        public CfnApplicationOutputV2 build() {
            return new CfnApplicationOutputV2(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputV2.OutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestinationSchema();

        @Nullable
        default public Object getKinesisFirehoseOutput() {
            return null;
        }

        @Nullable
        default public Object getKinesisStreamsOutput() {
            return null;
        }

        @Nullable
        default public Object getLambdaOutput() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputProperty> {
            private Object destinationSchema;
            private Object kinesisFirehoseOutput;
            private Object kinesisStreamsOutput;
            private Object lambdaOutput;
            private String name;

            public Builder destinationSchema(DestinationSchemaProperty destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            public Builder destinationSchema(IResolvable destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            public Builder kinesisFirehoseOutput(KinesisFirehoseOutputProperty kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            public Builder kinesisFirehoseOutput(IResolvable kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            public Builder kinesisStreamsOutput(KinesisStreamsOutputProperty kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            public Builder kinesisStreamsOutput(IResolvable kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            public Builder lambdaOutput(LambdaOutputProperty lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            public Builder lambdaOutput(IResolvable lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public OutputProperty build() {
                return new Jsii.Proxy(this.destinationSchema, this.kinesisFirehoseOutput, this.kinesisStreamsOutput, this.lambdaOutput, this.name);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputV2.LambdaOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaOutputProperty> {
            private String resourceArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public LambdaOutputProperty build() {
                return new Jsii.Proxy(this.resourceArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputV2.KinesisStreamsOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisStreamsOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisStreamsOutputProperty> {
            private String resourceArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public KinesisStreamsOutputProperty build() {
                return new Jsii.Proxy(this.resourceArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputV2.KinesisFirehoseOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisFirehoseOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisFirehoseOutputProperty> {
            private String resourceArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public KinesisFirehoseOutputProperty build() {
                return new Jsii.Proxy(this.resourceArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutputV2.DestinationSchemaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationSchemaProperty
    extends JsiiSerializable {
        @Nullable
        default public String getRecordFormatType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationSchemaProperty> {
            private String recordFormatType;

            public Builder recordFormatType(String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            public DestinationSchemaProperty build() {
                return new Jsii.Proxy(this.recordFormatType);
            }
        }
    }
}

