/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.pinpoint;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.pinpoint.CfnCampaign;
import software.amazon.awscdk.services.pinpoint.CfnCampaignProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign")
public class CfnCampaign
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCampaign.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCampaign(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCampaign(@NotNull Construct scope, @NotNull String id, @NotNull CfnCampaignProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCampaignId() {
        return (String)Kernel.get((Object)this, (String)"attrCampaignId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getApplicationId() {
        return (String)Kernel.get((Object)this, (String)"applicationId", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationId(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationId", (Object)Objects.requireNonNull(value, "applicationId is required"));
    }

    @NotNull
    public Object getMessageConfiguration() {
        return Kernel.get((Object)this, (String)"messageConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMessageConfiguration(@NotNull MessageConfigurationProperty value) {
        Kernel.set((Object)this, (String)"messageConfiguration", (Object)Objects.requireNonNull(value, "messageConfiguration is required"));
    }

    public void setMessageConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"messageConfiguration", (Object)Objects.requireNonNull(value, "messageConfiguration is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public Object getSchedule() {
        return Kernel.get((Object)this, (String)"schedule", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSchedule(@NotNull ScheduleProperty value) {
        Kernel.set((Object)this, (String)"schedule", (Object)Objects.requireNonNull(value, "schedule is required"));
    }

    public void setSchedule(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"schedule", (Object)Objects.requireNonNull(value, "schedule is required"));
    }

    @NotNull
    public String getSegmentId() {
        return (String)Kernel.get((Object)this, (String)"segmentId", (NativeType)NativeType.forClass(String.class));
    }

    public void setSegmentId(@NotNull String value) {
        Kernel.set((Object)this, (String)"segmentId", (Object)Objects.requireNonNull(value, "segmentId is required"));
    }

    @Nullable
    public Object getAdditionalTreatments() {
        return Kernel.get((Object)this, (String)"additionalTreatments", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAdditionalTreatments(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"additionalTreatments", (Object)value);
    }

    public void setAdditionalTreatments(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"additionalTreatments", value);
    }

    @Nullable
    public Object getCampaignHook() {
        return Kernel.get((Object)this, (String)"campaignHook", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCampaignHook(@Nullable CampaignHookProperty value) {
        Kernel.set((Object)this, (String)"campaignHook", (Object)value);
    }

    public void setCampaignHook(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"campaignHook", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Number getHoldoutPercent() {
        return (Number)Kernel.get((Object)this, (String)"holdoutPercent", (NativeType)NativeType.forClass(Number.class));
    }

    public void setHoldoutPercent(@Nullable Number value) {
        Kernel.set((Object)this, (String)"holdoutPercent", (Object)value);
    }

    @Nullable
    public Object getIsPaused() {
        return Kernel.get((Object)this, (String)"isPaused", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIsPaused(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"isPaused", (Object)value);
    }

    public void setIsPaused(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"isPaused", (Object)value);
    }

    @Nullable
    public Object getLimits() {
        return Kernel.get((Object)this, (String)"limits", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLimits(@Nullable LimitsProperty value) {
        Kernel.set((Object)this, (String)"limits", (Object)value);
    }

    public void setLimits(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"limits", (Object)value);
    }

    @Nullable
    public Number getSegmentVersion() {
        return (Number)Kernel.get((Object)this, (String)"segmentVersion", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSegmentVersion(@Nullable Number value) {
        Kernel.set((Object)this, (String)"segmentVersion", (Object)value);
    }

    @Nullable
    public String getTreatmentDescription() {
        return (String)Kernel.get((Object)this, (String)"treatmentDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setTreatmentDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"treatmentDescription", (Object)value);
    }

    @Nullable
    public String getTreatmentName() {
        return (String)Kernel.get((Object)this, (String)"treatmentName", (NativeType)NativeType.forClass(String.class));
    }

    public void setTreatmentName(@Nullable String value) {
        Kernel.set((Object)this, (String)"treatmentName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCampaign> {
        private final Construct scope;
        private final String id;
        private final CfnCampaignProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCampaignProps.Builder();
        }

        public Builder applicationId(String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        public Builder messageConfiguration(MessageConfigurationProperty messageConfiguration) {
            this.props.messageConfiguration(messageConfiguration);
            return this;
        }

        public Builder messageConfiguration(IResolvable messageConfiguration) {
            this.props.messageConfiguration(messageConfiguration);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder schedule(ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schedule(IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder segmentId(String segmentId) {
            this.props.segmentId(segmentId);
            return this;
        }

        public Builder additionalTreatments(IResolvable additionalTreatments) {
            this.props.additionalTreatments(additionalTreatments);
            return this;
        }

        public Builder additionalTreatments(List<? extends Object> additionalTreatments) {
            this.props.additionalTreatments(additionalTreatments);
            return this;
        }

        public Builder campaignHook(CampaignHookProperty campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        public Builder campaignHook(IResolvable campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder holdoutPercent(Number holdoutPercent) {
            this.props.holdoutPercent(holdoutPercent);
            return this;
        }

        public Builder isPaused(Boolean isPaused) {
            this.props.isPaused(isPaused);
            return this;
        }

        public Builder isPaused(IResolvable isPaused) {
            this.props.isPaused(isPaused);
            return this;
        }

        public Builder limits(LimitsProperty limits) {
            this.props.limits(limits);
            return this;
        }

        public Builder limits(IResolvable limits) {
            this.props.limits(limits);
            return this;
        }

        public Builder segmentVersion(Number segmentVersion) {
            this.props.segmentVersion(segmentVersion);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder treatmentDescription(String treatmentDescription) {
            this.props.treatmentDescription(treatmentDescription);
            return this;
        }

        public Builder treatmentName(String treatmentName) {
            this.props.treatmentName(treatmentName);
            return this;
        }

        public CfnCampaign build() {
            return new CfnCampaign(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.WriteTreatmentResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WriteTreatmentResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getMessageConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSchedule() {
            return null;
        }

        @Nullable
        default public Number getSizePercent() {
            return null;
        }

        @Nullable
        default public String getTreatmentDescription() {
            return null;
        }

        @Nullable
        default public String getTreatmentName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WriteTreatmentResourceProperty> {
            private Object messageConfiguration;
            private Object schedule;
            private Number sizePercent;
            private String treatmentDescription;
            private String treatmentName;

            public Builder messageConfiguration(MessageConfigurationProperty messageConfiguration) {
                this.messageConfiguration = messageConfiguration;
                return this;
            }

            public Builder messageConfiguration(IResolvable messageConfiguration) {
                this.messageConfiguration = messageConfiguration;
                return this;
            }

            public Builder schedule(ScheduleProperty schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder schedule(IResolvable schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder sizePercent(Number sizePercent) {
                this.sizePercent = sizePercent;
                return this;
            }

            public Builder treatmentDescription(String treatmentDescription) {
                this.treatmentDescription = treatmentDescription;
                return this;
            }

            public Builder treatmentName(String treatmentName) {
                this.treatmentName = treatmentName;
                return this;
            }

            public WriteTreatmentResourceProperty build() {
                return new Jsii.Proxy(this.messageConfiguration, this.schedule, this.sizePercent, this.treatmentDescription, this.treatmentName);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.SetDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SetDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDimensionType() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SetDimensionProperty> {
            private String dimensionType;
            private List<String> values;

            public Builder dimensionType(String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public SetDimensionProperty build() {
                return new Jsii.Proxy(this.dimensionType, this.values);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.ScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEndTime() {
            return null;
        }

        @Nullable
        default public Object getEventFilter() {
            return null;
        }

        @Nullable
        default public String getFrequency() {
            return null;
        }

        @Nullable
        default public Object getIsLocalTime() {
            return null;
        }

        @Nullable
        default public Object getQuietTime() {
            return null;
        }

        @Nullable
        default public String getStartTime() {
            return null;
        }

        @Nullable
        default public String getTimeZone() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleProperty> {
            private String endTime;
            private Object eventFilter;
            private String frequency;
            private Object isLocalTime;
            private Object quietTime;
            private String startTime;
            private String timeZone;

            public Builder endTime(String endTime) {
                this.endTime = endTime;
                return this;
            }

            public Builder eventFilter(CampaignEventFilterProperty eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            public Builder eventFilter(IResolvable eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            public Builder frequency(String frequency) {
                this.frequency = frequency;
                return this;
            }

            public Builder isLocalTime(Boolean isLocalTime) {
                this.isLocalTime = isLocalTime;
                return this;
            }

            public Builder isLocalTime(IResolvable isLocalTime) {
                this.isLocalTime = isLocalTime;
                return this;
            }

            public Builder quietTime(QuietTimeProperty quietTime) {
                this.quietTime = quietTime;
                return this;
            }

            public Builder quietTime(IResolvable quietTime) {
                this.quietTime = quietTime;
                return this;
            }

            public Builder startTime(String startTime) {
                this.startTime = startTime;
                return this;
            }

            public Builder timeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public ScheduleProperty build() {
                return new Jsii.Proxy(this.endTime, this.eventFilter, this.frequency, this.isLocalTime, this.quietTime, this.startTime, this.timeZone);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.QuietTimeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QuietTimeProperty
    extends JsiiSerializable {
        @NotNull
        public String getEnd();

        @NotNull
        public String getStart();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<QuietTimeProperty> {
            private String end;
            private String start;

            public Builder end(String end) {
                this.end = end;
                return this;
            }

            public Builder start(String start) {
                this.start = start;
                return this;
            }

            public QuietTimeProperty build() {
                return new Jsii.Proxy(this.end, this.start);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.MetricDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComparisonOperator() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            private String comparisonOperator;
            private Number value;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public MetricDimensionProperty build() {
                return new Jsii.Proxy(this.comparisonOperator, this.value);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.MessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MessageProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAction() {
            return null;
        }

        @Nullable
        default public String getBody() {
            return null;
        }

        @Nullable
        default public String getImageIconUrl() {
            return null;
        }

        @Nullable
        default public String getImageSmallIconUrl() {
            return null;
        }

        @Nullable
        default public String getImageUrl() {
            return null;
        }

        @Nullable
        default public String getJsonBody() {
            return null;
        }

        @Nullable
        default public String getMediaUrl() {
            return null;
        }

        @Nullable
        default public String getRawContent() {
            return null;
        }

        @Nullable
        default public Object getSilentPush() {
            return null;
        }

        @Nullable
        default public Number getTimeToLive() {
            return null;
        }

        @Nullable
        default public String getTitle() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MessageProperty> {
            private String action;
            private String body;
            private String imageIconUrl;
            private String imageSmallIconUrl;
            private String imageUrl;
            private String jsonBody;
            private String mediaUrl;
            private String rawContent;
            private Object silentPush;
            private Number timeToLive;
            private String title;
            private String url;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public Builder body(String body) {
                this.body = body;
                return this;
            }

            public Builder imageIconUrl(String imageIconUrl) {
                this.imageIconUrl = imageIconUrl;
                return this;
            }

            public Builder imageSmallIconUrl(String imageSmallIconUrl) {
                this.imageSmallIconUrl = imageSmallIconUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder jsonBody(String jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            public Builder mediaUrl(String mediaUrl) {
                this.mediaUrl = mediaUrl;
                return this;
            }

            public Builder rawContent(String rawContent) {
                this.rawContent = rawContent;
                return this;
            }

            public Builder silentPush(Boolean silentPush) {
                this.silentPush = silentPush;
                return this;
            }

            public Builder silentPush(IResolvable silentPush) {
                this.silentPush = silentPush;
                return this;
            }

            public Builder timeToLive(Number timeToLive) {
                this.timeToLive = timeToLive;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public MessageProperty build() {
                return new Jsii.Proxy(this.action, this.body, this.imageIconUrl, this.imageSmallIconUrl, this.imageUrl, this.jsonBody, this.mediaUrl, this.rawContent, this.silentPush, this.timeToLive, this.title, this.url);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.MessageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MessageConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAdmMessage() {
            return null;
        }

        @Nullable
        default public Object getApnsMessage() {
            return null;
        }

        @Nullable
        default public Object getBaiduMessage() {
            return null;
        }

        @Nullable
        default public Object getDefaultMessage() {
            return null;
        }

        @Nullable
        default public Object getEmailMessage() {
            return null;
        }

        @Nullable
        default public Object getGcmMessage() {
            return null;
        }

        @Nullable
        default public Object getSmsMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MessageConfigurationProperty> {
            private Object admMessage;
            private Object apnsMessage;
            private Object baiduMessage;
            private Object defaultMessage;
            private Object emailMessage;
            private Object gcmMessage;
            private Object smsMessage;

            public Builder admMessage(MessageProperty admMessage) {
                this.admMessage = admMessage;
                return this;
            }

            public Builder admMessage(IResolvable admMessage) {
                this.admMessage = admMessage;
                return this;
            }

            public Builder apnsMessage(MessageProperty apnsMessage) {
                this.apnsMessage = apnsMessage;
                return this;
            }

            public Builder apnsMessage(IResolvable apnsMessage) {
                this.apnsMessage = apnsMessage;
                return this;
            }

            public Builder baiduMessage(MessageProperty baiduMessage) {
                this.baiduMessage = baiduMessage;
                return this;
            }

            public Builder baiduMessage(IResolvable baiduMessage) {
                this.baiduMessage = baiduMessage;
                return this;
            }

            public Builder defaultMessage(MessageProperty defaultMessage) {
                this.defaultMessage = defaultMessage;
                return this;
            }

            public Builder defaultMessage(IResolvable defaultMessage) {
                this.defaultMessage = defaultMessage;
                return this;
            }

            public Builder emailMessage(CampaignEmailMessageProperty emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Builder emailMessage(IResolvable emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Builder gcmMessage(MessageProperty gcmMessage) {
                this.gcmMessage = gcmMessage;
                return this;
            }

            public Builder gcmMessage(IResolvable gcmMessage) {
                this.gcmMessage = gcmMessage;
                return this;
            }

            public Builder smsMessage(CampaignSmsMessageProperty smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            public Builder smsMessage(IResolvable smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            public MessageConfigurationProperty build() {
                return new Jsii.Proxy(this.admMessage, this.apnsMessage, this.baiduMessage, this.defaultMessage, this.emailMessage, this.gcmMessage, this.smsMessage);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.LimitsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LimitsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDaily() {
            return null;
        }

        @Nullable
        default public Number getMaximumDuration() {
            return null;
        }

        @Nullable
        default public Number getMessagesPerSecond() {
            return null;
        }

        @Nullable
        default public Number getTotal() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LimitsProperty> {
            private Number daily;
            private Number maximumDuration;
            private Number messagesPerSecond;
            private Number total;

            public Builder daily(Number daily) {
                this.daily = daily;
                return this;
            }

            public Builder maximumDuration(Number maximumDuration) {
                this.maximumDuration = maximumDuration;
                return this;
            }

            public Builder messagesPerSecond(Number messagesPerSecond) {
                this.messagesPerSecond = messagesPerSecond;
                return this;
            }

            public Builder total(Number total) {
                this.total = total;
                return this;
            }

            public LimitsProperty build() {
                return new Jsii.Proxy(this.daily, this.maximumDuration, this.messagesPerSecond, this.total);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.EventDimensionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventDimensionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAttributes() {
            return null;
        }

        @Nullable
        default public Object getEventType() {
            return null;
        }

        @Nullable
        default public Object getMetrics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventDimensionsProperty> {
            private Object attributes;
            private Object eventType;
            private Object metrics;

            public Builder attributes(Object attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder eventType(SetDimensionProperty eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder eventType(IResolvable eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder metrics(Object metrics) {
                this.metrics = metrics;
                return this;
            }

            public EventDimensionsProperty build() {
                return new Jsii.Proxy(this.attributes, this.eventType, this.metrics);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignSmsMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignSmsMessageProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBody() {
            return null;
        }

        @Nullable
        default public String getEntityId() {
            return null;
        }

        @Nullable
        default public String getMessageType() {
            return null;
        }

        @Nullable
        default public String getOriginationNumber() {
            return null;
        }

        @Nullable
        default public String getSenderId() {
            return null;
        }

        @Nullable
        default public String getTemplateId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignSmsMessageProperty> {
            private String body;
            private String entityId;
            private String messageType;
            private String originationNumber;
            private String senderId;
            private String templateId;

            public Builder body(String body) {
                this.body = body;
                return this;
            }

            public Builder entityId(String entityId) {
                this.entityId = entityId;
                return this;
            }

            public Builder messageType(String messageType) {
                this.messageType = messageType;
                return this;
            }

            public Builder originationNumber(String originationNumber) {
                this.originationNumber = originationNumber;
                return this;
            }

            public Builder senderId(String senderId) {
                this.senderId = senderId;
                return this;
            }

            public Builder templateId(String templateId) {
                this.templateId = templateId;
                return this;
            }

            public CampaignSmsMessageProperty build() {
                return new Jsii.Proxy(this.body, this.entityId, this.messageType, this.originationNumber, this.senderId, this.templateId);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignHookProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignHookProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLambdaFunctionName() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public String getWebUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignHookProperty> {
            private String lambdaFunctionName;
            private String mode;
            private String webUrl;

            public Builder lambdaFunctionName(String lambdaFunctionName) {
                this.lambdaFunctionName = lambdaFunctionName;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder webUrl(String webUrl) {
                this.webUrl = webUrl;
                return this;
            }

            public CampaignHookProperty build() {
                return new Jsii.Proxy(this.lambdaFunctionName, this.mode, this.webUrl);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignEventFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignEventFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDimensions() {
            return null;
        }

        @Nullable
        default public String getFilterType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignEventFilterProperty> {
            private Object dimensions;
            private String filterType;

            public Builder dimensions(EventDimensionsProperty dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder dimensions(IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder filterType(String filterType) {
                this.filterType = filterType;
                return this;
            }

            public CampaignEventFilterProperty build() {
                return new Jsii.Proxy(this.dimensions, this.filterType);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignEmailMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignEmailMessageProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBody() {
            return null;
        }

        @Nullable
        default public String getFromAddress() {
            return null;
        }

        @Nullable
        default public String getHtmlBody() {
            return null;
        }

        @Nullable
        default public String getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignEmailMessageProperty> {
            private String body;
            private String fromAddress;
            private String htmlBody;
            private String title;

            public Builder body(String body) {
                this.body = body;
                return this;
            }

            public Builder fromAddress(String fromAddress) {
                this.fromAddress = fromAddress;
                return this;
            }

            public Builder htmlBody(String htmlBody) {
                this.htmlBody = htmlBody;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public CampaignEmailMessageProperty build() {
                return new Jsii.Proxy(this.body, this.fromAddress, this.htmlBody, this.title);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pinpoint.CfnCampaign.AttributeDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AttributeDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAttributeType() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AttributeDimensionProperty> {
            private String attributeType;
            private List<String> values;

            public Builder attributeType(String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public AttributeDimensionProperty build() {
                return new Jsii.Proxy(this.attributeType, this.values);
            }
        }
    }
}

