package software.amazon.awscdk;

/**
 * (experimental) Uses conventionally named roles and reify asset storage locations.
 * <p>
 * This synthesizer is the only StackSynthesizer that generates
 * an asset manifest, and is required to deploy CDK applications using the
 * <code>&#64;aws-cdk/app-delivery</code> CI/CD library.
 * <p>
 * Requires the environment to have been bootstrapped with Bootstrap Stack V2.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:49.446Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.DefaultStackSynthesizer")
public class DefaultStackSynthesizer extends software.amazon.awscdk.StackSynthesizer {

    protected DefaultStackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DefaultStackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_CLOUDFORMATION_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_CLOUDFORMATION_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_DEPLOY_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_DEPLOY_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_PREFIX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_PREFIX", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSETS_BUCKET_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSETS_BUCKET_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_LOOKUP_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_LOOKUP_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_QUALIFIER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_QUALIFIER", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DefaultStackSynthesizer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.DefaultStackSynthesizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DefaultStackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * (experimental) Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * (experimental) Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * (experimental) Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * (experimental) Have the stack write out its template.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected void synthesizeStackTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesizeStackTemplate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * (experimental) Default bootstrap stack version SSM parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER;

    /**
     * (experimental) Default CloudFormation role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_CLOUDFORMATION_ROLE_ARN;

    /**
     * (experimental) Default deploy role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_DEPLOY_ROLE_ARN;

    /**
     * (experimental) Name of the CloudFormation Export with the asset key name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME;

    /**
     * (experimental) Default file asset prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_FILE_ASSET_PREFIX;

    /**
     * (experimental) Default asset publishing role ARN for file (S3) assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN;

    /**
     * (experimental) Default file assets bucket name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_FILE_ASSETS_BUCKET_NAME;

    /**
     * (experimental) Default asset publishing role ARN for image (ECR) assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN;

    /**
     * (experimental) Default image assets repository name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME;

    /**
     * (experimental) Default lookup role ARN for missing values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_LOOKUP_ROLE_ARN;

    /**
     * (experimental) Default ARN qualifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String DEFAULT_QUALIFIER;

    /**
     * (experimental) Returns the ARN of the CFN execution Role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCloudFormationExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns the ARN of the deploy Role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeployRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "deployRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.Stack getStack() {
        return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.DefaultStackSynthesizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.DefaultStackSynthesizer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.DefaultStackSynthesizerProps.Builder props;

        private Builder() {
        }

        /**
         * (experimental) Bootstrap stack version SSM parameter.
         * <p>
         * The placeholder <code>${Qualifier}</code> will be replaced with the value of qualifier.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER
         * <p>
         * @return {@code this}
         * @param bootstrapStackVersionSsmParameter Bootstrap stack version SSM parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bootstrapStackVersionSsmParameter(final java.lang.String bootstrapStackVersionSsmParameter) {
            this.props().bootstrapStackVersionSsmParameter(bootstrapStackVersionSsmParameter);
            return this;
        }

        /**
         * (experimental) bucketPrefix to use while storing S3 Assets.
         * <p>
         * Default: - DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX
         * <p>
         * @return {@code this}
         * @param bucketPrefix bucketPrefix to use while storing S3 Assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucketPrefix(final java.lang.String bucketPrefix) {
            this.props().bucketPrefix(bucketPrefix);
            return this;
        }

        /**
         * (experimental) The role CloudFormation will assume when deploying the Stack.
         * <p>
         * You must supply this if you have given a non-standard name to the execution role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param cloudFormationExecutionRole The role CloudFormation will assume when deploying the Stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudFormationExecutionRole(final java.lang.String cloudFormationExecutionRole) {
            this.props().cloudFormationExecutionRole(cloudFormationExecutionRole);
            return this;
        }

        /**
         * (experimental) The role to assume to initiate a deployment in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param deployRoleArn The role to assume to initiate a deployment in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deployRoleArn(final java.lang.String deployRoleArn) {
            this.props().deployRoleArn(deployRoleArn);
            return this;
        }

        /**
         * (experimental) External ID to use when assuming role for cloudformation deployments.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param deployRoleExternalId External ID to use when assuming role for cloudformation deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deployRoleExternalId(final java.lang.String deployRoleExternalId) {
            this.props().deployRoleExternalId(deployRoleExternalId);
            return this;
        }

        /**
         * (experimental) External ID to use when assuming role for file asset publishing.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param fileAssetPublishingExternalId External ID to use when assuming role for file asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fileAssetPublishingExternalId(final java.lang.String fileAssetPublishingExternalId) {
            this.props().fileAssetPublishingExternalId(fileAssetPublishingExternalId);
            return this;
        }

        /**
         * (experimental) The role to use to publish file assets to the S3 bucket in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param fileAssetPublishingRoleArn The role to use to publish file assets to the S3 bucket in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fileAssetPublishingRoleArn(final java.lang.String fileAssetPublishingRoleArn) {
            this.props().fileAssetPublishingRoleArn(fileAssetPublishingRoleArn);
            return this;
        }

        /**
         * (experimental) Name of the S3 bucket to hold file assets.
         * <p>
         * You must supply this if you have given a non-standard name to the staging bucket.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
         * <p>
         * @return {@code this}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fileAssetsBucketName(final java.lang.String fileAssetsBucketName) {
            this.props().fileAssetsBucketName(fileAssetsBucketName);
            return this;
        }

        /**
         * (experimental) Whether to add a Rule to the stack template verifying the bootstrap stack version.
         * <p>
         * This generally should be left set to <code>true</code>, unless you explicitly
         * want to be able to deploy to an unbootstrapped environment.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param generateBootstrapVersionRule Whether to add a Rule to the stack template verifying the bootstrap stack version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generateBootstrapVersionRule(final java.lang.Boolean generateBootstrapVersionRule) {
            this.props().generateBootstrapVersionRule(generateBootstrapVersionRule);
            return this;
        }

        /**
         * (experimental) External ID to use when assuming role for image asset publishing.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param imageAssetPublishingExternalId External ID to use when assuming role for image asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageAssetPublishingExternalId(final java.lang.String imageAssetPublishingExternalId) {
            this.props().imageAssetPublishingExternalId(imageAssetPublishingExternalId);
            return this;
        }

        /**
         * (experimental) The role to use to publish image assets to the ECR repository in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param imageAssetPublishingRoleArn The role to use to publish image assets to the ECR repository in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageAssetPublishingRoleArn(final java.lang.String imageAssetPublishingRoleArn) {
            this.props().imageAssetPublishingRoleArn(imageAssetPublishingRoleArn);
            return this;
        }

        /**
         * (experimental) Name of the ECR repository to hold Docker Image assets.
         * <p>
         * You must supply this if you have given a non-standard name to the ECR repository.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
         * <p>
         * @return {@code this}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageAssetsRepositoryName(final java.lang.String imageAssetsRepositoryName) {
            this.props().imageAssetsRepositoryName(imageAssetsRepositoryName);
            return this;
        }

        /**
         * (experimental) The role to use to look up values from the target AWS account during synthesis.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param lookupRoleArn The role to use to look up values from the target AWS account during synthesis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lookupRoleArn(final java.lang.String lookupRoleArn) {
            this.props().lookupRoleArn(lookupRoleArn);
            return this;
        }

        /**
         * (experimental) Qualifier to disambiguate multiple environments in the same account.
         * <p>
         * You can use this and leave the other naming properties empty if you have deployed
         * the bootstrap environment with standard names but only differnet qualifiers.
         * <p>
         * Default: - Value of context key '
         * <p>
         * @return {@code this}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder qualifier(final java.lang.String qualifier) {
            this.props().qualifier(qualifier);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.DefaultStackSynthesizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.DefaultStackSynthesizer build() {
            return new software.amazon.awscdk.DefaultStackSynthesizer(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.DefaultStackSynthesizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.DefaultStackSynthesizerProps.Builder();
            }
            return this.props;
        }
    }
}
