package software.amazon.awscdk;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:50.207Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.DockerImageAssetSource")
@software.amazon.jsii.Jsii.Proxy(DockerImageAssetSource.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DockerImageAssetSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The hash of the contents of the docker build context.
     * <p>
     * This hash is used
     * throughout the system to identify this image and avoid duplicate work
     * in case the source did not change.
     * <p>
     * NOTE: this means that if you wish to update your docker image, you
     * must make a modification to the source (e.g. add some metadata to your Dockerfile).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceHash();

    /**
     * (experimental) The directory where the Dockerfile is stored, must be relative to the cloud assembly root.
     * <p>
     * Default: - Exactly one of `directoryName` and `executable` is required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDirectoryName() {
        return null;
    }

    /**
     * (experimental) Build args to pass to the `docker build` command.
     * <p>
     * Since Docker build arguments are resolved before deployment, keys and
     * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
     * <code>queue.queueUrl</code>).
     * <p>
     * Only allowed when <code>directoryName</code> is specified.
     * <p>
     * Default: - no build args are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs() {
        return null;
    }

    /**
     * (experimental) Docker target to build to.
     * <p>
     * Only allowed when <code>directoryName</code> is specified.
     * <p>
     * Default: - no target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerBuildTarget() {
        return null;
    }

    /**
     * (experimental) Path to the Dockerfile (relative to the directory).
     * <p>
     * Only allowed when <code>directoryName</code> is specified.
     * <p>
     * Default: - no file
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerFile() {
        return null;
    }

    /**
     * (experimental) An external command that will produce the packaged asset.
     * <p>
     * The command should produce the name of a local Docker image on <code>stdout</code>.
     * <p>
     * Default: - Exactly one of `directoryName` and `executable` is required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExecutable() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageAssetSource> {
        private java.lang.String sourceHash;
        private java.lang.String directoryName;
        private java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private java.lang.String dockerBuildTarget;
        private java.lang.String dockerFile;
        private java.util.List<java.lang.String> executable;

        /**
         * Sets the value of {@link DockerImageAssetSource#getSourceHash}
         * @param sourceHash The hash of the contents of the docker build context. This parameter is required.
         *                   This hash is used
         *                   throughout the system to identify this image and avoid duplicate work
         *                   in case the source did not change.
         *                   <p>
         *                   NOTE: this means that if you wish to update your docker image, you
         *                   must make a modification to the source (e.g. add some metadata to your Dockerfile).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceHash(java.lang.String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getDirectoryName}
         * @param directoryName The directory where the Dockerfile is stored, must be relative to the cloud assembly root.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder directoryName(java.lang.String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getDockerBuildArgs}
         * @param dockerBuildArgs Build args to pass to the `docker build` command.
         *                        Since Docker build arguments are resolved before deployment, keys and
         *                        values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         *                        <code>queue.queueUrl</code>).
         *                        <p>
         *                        Only allowed when <code>directoryName</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerBuildArgs(java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs) {
            this.dockerBuildArgs = dockerBuildArgs;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getDockerBuildTarget}
         * @param dockerBuildTarget Docker target to build to.
         *                          Only allowed when <code>directoryName</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerBuildTarget(java.lang.String dockerBuildTarget) {
            this.dockerBuildTarget = dockerBuildTarget;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getDockerFile}
         * @param dockerFile Path to the Dockerfile (relative to the directory).
         *                   Only allowed when <code>directoryName</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerFile(java.lang.String dockerFile) {
            this.dockerFile = dockerFile;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetSource#getExecutable}
         * @param executable An external command that will produce the packaged asset.
         *                   The command should produce the name of a local Docker image on <code>stdout</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executable(java.util.List<java.lang.String> executable) {
            this.executable = executable;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DockerImageAssetSource build() {
            return new Jsii$Proxy(sourceHash, directoryName, dockerBuildArgs, dockerBuildTarget, dockerFile, executable);
        }
    }

    /**
     * An implementation for {@link DockerImageAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageAssetSource {
        private final java.lang.String sourceHash;
        private final java.lang.String directoryName;
        private final java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private final java.lang.String dockerBuildTarget;
        private final java.lang.String dockerFile;
        private final java.util.List<java.lang.String> executable;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceHash = software.amazon.jsii.Kernel.get(this, "sourceHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directoryName = software.amazon.jsii.Kernel.get(this, "directoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerBuildArgs = software.amazon.jsii.Kernel.get(this, "dockerBuildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerBuildTarget = software.amazon.jsii.Kernel.get(this, "dockerBuildTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerFile = software.amazon.jsii.Kernel.get(this, "dockerFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executable = software.amazon.jsii.Kernel.get(this, "executable", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String sourceHash, final java.lang.String directoryName, final java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs, final java.lang.String dockerBuildTarget, final java.lang.String dockerFile, final java.util.List<java.lang.String> executable) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceHash = java.util.Objects.requireNonNull(sourceHash, "sourceHash is required");
            this.directoryName = directoryName;
            this.dockerBuildArgs = dockerBuildArgs;
            this.dockerBuildTarget = dockerBuildTarget;
            this.dockerFile = dockerFile;
            this.executable = executable;
        }

        @Override
        public final java.lang.String getSourceHash() {
            return this.sourceHash;
        }

        @Override
        public final java.lang.String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs() {
            return this.dockerBuildArgs;
        }

        @Override
        public final java.lang.String getDockerBuildTarget() {
            return this.dockerBuildTarget;
        }

        @Override
        public final java.lang.String getDockerFile() {
            return this.dockerFile;
        }

        @Override
        public final java.util.List<java.lang.String> getExecutable() {
            return this.executable;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceHash", om.valueToTree(this.getSourceHash()));
            if (this.getDirectoryName() != null) {
                data.set("directoryName", om.valueToTree(this.getDirectoryName()));
            }
            if (this.getDockerBuildArgs() != null) {
                data.set("dockerBuildArgs", om.valueToTree(this.getDockerBuildArgs()));
            }
            if (this.getDockerBuildTarget() != null) {
                data.set("dockerBuildTarget", om.valueToTree(this.getDockerBuildTarget()));
            }
            if (this.getDockerFile() != null) {
                data.set("dockerFile", om.valueToTree(this.getDockerFile()));
            }
            if (this.getExecutable() != null) {
                data.set("executable", om.valueToTree(this.getExecutable()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.DockerImageAssetSource"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageAssetSource.Jsii$Proxy that = (DockerImageAssetSource.Jsii$Proxy) o;

            if (!sourceHash.equals(that.sourceHash)) return false;
            if (this.directoryName != null ? !this.directoryName.equals(that.directoryName) : that.directoryName != null) return false;
            if (this.dockerBuildArgs != null ? !this.dockerBuildArgs.equals(that.dockerBuildArgs) : that.dockerBuildArgs != null) return false;
            if (this.dockerBuildTarget != null ? !this.dockerBuildTarget.equals(that.dockerBuildTarget) : that.dockerBuildTarget != null) return false;
            if (this.dockerFile != null ? !this.dockerFile.equals(that.dockerFile) : that.dockerFile != null) return false;
            return this.executable != null ? this.executable.equals(that.executable) : that.executable == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceHash.hashCode();
            result = 31 * result + (this.directoryName != null ? this.directoryName.hashCode() : 0);
            result = 31 * result + (this.dockerBuildArgs != null ? this.dockerBuildArgs.hashCode() : 0);
            result = 31 * result + (this.dockerBuildTarget != null ? this.dockerBuildTarget.hashCode() : 0);
            result = 31 * result + (this.dockerFile != null ? this.dockerFile.hashCode() : 0);
            result = 31 * result + (this.executable != null ? this.executable.hashCode() : 0);
            return result;
        }
    }
}
