package software.amazon.awscdk;

/**
 * (experimental) Represents the amount of digital storage.
 * <p>
 * The amount can be specified either as a literal value (e.g: <code>10</code>) which
 * cannot be negative, or as an unresolved number token.
 * <p>
 * When the amount is passed as a token, unit conversion is not possible.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:52.644Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Size")
public class Size extends software.amazon.jsii.JsiiObject {

    protected Size(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Size(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Create a Storage representing an amount gibibytes.
     * <p>
     * 1 GiB = 1024 MiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of gibibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size gibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "gibibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * (experimental) Create a Storage representing an amount kibibytes.
     * <p>
     * 1 KiB = 1024 bytes
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of kibibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size kibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "kibibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * (experimental) Create a Storage representing an amount mebibytes.
     * <p>
     * 1 MiB = 1024 KiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of mebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size mebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "mebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * (experimental) Create a Storage representing an amount pebibytes.
     * <p>
     * 1 PiB = 1024 TiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of pebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size pebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "pebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * (experimental) Create a Storage representing an amount tebibytes.
     * <p>
     * 1 TiB = 1024 GiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of tebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size tebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "tebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * (experimental) Return this storage as a total number of gibibytes.
     * <p>
     * @return the quantity of bytes expressed in gibibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toGibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * (experimental) Return this storage as a total number of gibibytes.
     * <p>
     * @return the quantity of bytes expressed in gibibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes() {
        return software.amazon.jsii.Kernel.call(this, "toGibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Return this storage as a total number of kibibytes.
     * <p>
     * @return the quantity of bytes expressed in kibibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toKibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * (experimental) Return this storage as a total number of kibibytes.
     * <p>
     * @return the quantity of bytes expressed in kibibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes() {
        return software.amazon.jsii.Kernel.call(this, "toKibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Return this storage as a total number of mebibytes.
     * <p>
     * @return the quantity of bytes expressed in mebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * (experimental) Return this storage as a total number of mebibytes.
     * <p>
     * @return the quantity of bytes expressed in mebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Return this storage as a total number of pebibytes.
     * <p>
     * @return the quantity of bytes expressed in pebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toPebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * (experimental) Return this storage as a total number of pebibytes.
     * <p>
     * @return the quantity of bytes expressed in pebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toPebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Return this storage as a total number of tebibytes.
     * <p>
     * @return the quantity of bytes expressed in tebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toTebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * (experimental) Return this storage as a total number of tebibytes.
     * <p>
     * @return the quantity of bytes expressed in tebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toTebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }
}
