package software.amazon.awscdk.cloudassembly.schema;

/**
 * (experimental) Artifact properties for the Asset Manifest.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.096Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.AssetManifestProperties")
@software.amazon.jsii.Jsii.Proxy(AssetManifestProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AssetManifestProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Filename of the asset manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getFile();

    /**
     * (experimental) SSM parameter where the bootstrap stack version number can be found.
     * <p>
     * <ul>
     * <li>If this value is not set, the bootstrap stack name must be known at
     * deployment time so the stack version can be looked up from the stack
     * outputs.</li>
     * <li>If this value is set, the bootstrap stack can have any name because
     * we won't need to look it up.</li>
     * </ul>
     * <p>
     * Default: - Bootstrap stack version number looked up
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return null;
    }

    /**
     * (experimental) Version of bootstrap stack required to deploy this stack.
     * <p>
     * Default: - Version 1 (basic modern bootstrap stack)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssetManifestProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetManifestProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AssetManifestProperties> {
        private java.lang.String file;
        private java.lang.String bootstrapStackVersionSsmParameter;
        private java.lang.Number requiresBootstrapStackVersion;

        /**
         * Sets the value of {@link AssetManifestProperties#getFile}
         * @param file Filename of the asset manifest. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link AssetManifestProperties#getBootstrapStackVersionSsmParameter}
         * @param bootstrapStackVersionSsmParameter SSM parameter where the bootstrap stack version number can be found.
         *                                          <ul>
         *                                          <li>If this value is not set, the bootstrap stack name must be known at
         *                                          deployment time so the stack version can be looked up from the stack
         *                                          outputs.</li>
         *                                          <li>If this value is set, the bootstrap stack can have any name because
         *                                          we won't need to look it up.</li>
         *                                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bootstrapStackVersionSsmParameter(java.lang.String bootstrapStackVersionSsmParameter) {
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            return this;
        }

        /**
         * Sets the value of {@link AssetManifestProperties#getRequiresBootstrapStackVersion}
         * @param requiresBootstrapStackVersion Version of bootstrap stack required to deploy this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requiresBootstrapStackVersion(java.lang.Number requiresBootstrapStackVersion) {
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetManifestProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AssetManifestProperties build() {
            return new Jsii$Proxy(file, bootstrapStackVersionSsmParameter, requiresBootstrapStackVersion);
        }
    }

    /**
     * An implementation for {@link AssetManifestProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetManifestProperties {
        private final java.lang.String file;
        private final java.lang.String bootstrapStackVersionSsmParameter;
        private final java.lang.Number requiresBootstrapStackVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bootstrapStackVersionSsmParameter = software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requiresBootstrapStackVersion = software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String file, final java.lang.String bootstrapStackVersionSsmParameter, final java.lang.Number requiresBootstrapStackVersion) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.file = java.util.Objects.requireNonNull(file, "file is required");
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
        }

        @Override
        public final java.lang.String getFile() {
            return this.file;
        }

        @Override
        public final java.lang.String getBootstrapStackVersionSsmParameter() {
            return this.bootstrapStackVersionSsmParameter;
        }

        @Override
        public final java.lang.Number getRequiresBootstrapStackVersion() {
            return this.requiresBootstrapStackVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("file", om.valueToTree(this.getFile()));
            if (this.getBootstrapStackVersionSsmParameter() != null) {
                data.set("bootstrapStackVersionSsmParameter", om.valueToTree(this.getBootstrapStackVersionSsmParameter()));
            }
            if (this.getRequiresBootstrapStackVersion() != null) {
                data.set("requiresBootstrapStackVersion", om.valueToTree(this.getRequiresBootstrapStackVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.AssetManifestProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetManifestProperties.Jsii$Proxy that = (AssetManifestProperties.Jsii$Proxy) o;

            if (!file.equals(that.file)) return false;
            if (this.bootstrapStackVersionSsmParameter != null ? !this.bootstrapStackVersionSsmParameter.equals(that.bootstrapStackVersionSsmParameter) : that.bootstrapStackVersionSsmParameter != null) return false;
            return this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.equals(that.requiresBootstrapStackVersion) : that.requiresBootstrapStackVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.file.hashCode();
            result = 31 * result + (this.bootstrapStackVersionSsmParameter != null ? this.bootstrapStackVersionSsmParameter.hashCode() : 0);
            result = 31 * result + (this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.hashCode() : 0);
            return result;
        }
    }
}
