package software.amazon.awscdk.pipelines;

/**
 * (experimental) Options for adding an application stage to a pipeline.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.153Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.AddStageOptions")
@software.amazon.jsii.Jsii.Proxy(AddStageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AddStageOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.pipelines.BaseStageOptions {

    /**
     * (experimental) Add room for extra actions.
     * <p>
     * You can use this to make extra room in the runOrder sequence between the
     * changeset 'prepare' and 'execute' actions and insert your own actions there.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getExtraRunOrderSpace() {
        return null;
    }

    /**
     * (experimental) Add manual approvals before executing change sets.
     * <p>
     * This gives humans the opportunity to confirm the change set looks alright
     * before deploying it.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getManualApprovals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddStageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddStageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AddStageOptions> {
        private java.lang.Number extraRunOrderSpace;
        private java.lang.Boolean manualApprovals;
        private java.lang.Boolean confirmBroadeningPermissions;
        private software.amazon.awscdk.services.sns.ITopic securityNotificationTopic;

        /**
         * Sets the value of {@link AddStageOptions#getExtraRunOrderSpace}
         * @param extraRunOrderSpace Add room for extra actions.
         *                           You can use this to make extra room in the runOrder sequence between the
         *                           changeset 'prepare' and 'execute' actions and insert your own actions there.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraRunOrderSpace(java.lang.Number extraRunOrderSpace) {
            this.extraRunOrderSpace = extraRunOrderSpace;
            return this;
        }

        /**
         * Sets the value of {@link AddStageOptions#getManualApprovals}
         * @param manualApprovals Add manual approvals before executing change sets.
         *                        This gives humans the opportunity to confirm the change set looks alright
         *                        before deploying it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder manualApprovals(java.lang.Boolean manualApprovals) {
            this.manualApprovals = manualApprovals;
            return this;
        }

        /**
         * Sets the value of {@link AddStageOptions#getConfirmBroadeningPermissions}
         * @param confirmBroadeningPermissions Runs a `cdk diff --security-only --fail` to pause the pipeline if there are any security changes.
         *                                     If the stage is configured with <code>confirmBroadeningPermissions</code> enabled, you can use this
         *                                     property to override the stage configuration. For example, Pipeline Stage
         *                                     "Prod" has confirmBroadeningPermissions enabled, with applications "A", "B", "C". All three
         *                                     applications will run a security check, but if we want to disable the one for "C",
         *                                     we run <code>stage.addApplication(C, { confirmBroadeningPermissions: false })</code> to override the pipeline
         *                                     stage behavior.
         *                                     <p>
         *                                     Adds 1 to the run order space.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder confirmBroadeningPermissions(java.lang.Boolean confirmBroadeningPermissions) {
            this.confirmBroadeningPermissions = confirmBroadeningPermissions;
            return this;
        }

        /**
         * Sets the value of {@link AddStageOptions#getSecurityNotificationTopic}
         * @param securityNotificationTopic Optional SNS topic to send notifications to when the security check registers changes within the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityNotificationTopic(software.amazon.awscdk.services.sns.ITopic securityNotificationTopic) {
            this.securityNotificationTopic = securityNotificationTopic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddStageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AddStageOptions build() {
            return new Jsii$Proxy(extraRunOrderSpace, manualApprovals, confirmBroadeningPermissions, securityNotificationTopic);
        }
    }

    /**
     * An implementation for {@link AddStageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddStageOptions {
        private final java.lang.Number extraRunOrderSpace;
        private final java.lang.Boolean manualApprovals;
        private final java.lang.Boolean confirmBroadeningPermissions;
        private final software.amazon.awscdk.services.sns.ITopic securityNotificationTopic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.extraRunOrderSpace = software.amazon.jsii.Kernel.get(this, "extraRunOrderSpace", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.manualApprovals = software.amazon.jsii.Kernel.get(this, "manualApprovals", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.confirmBroadeningPermissions = software.amazon.jsii.Kernel.get(this, "confirmBroadeningPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityNotificationTopic = software.amazon.jsii.Kernel.get(this, "securityNotificationTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number extraRunOrderSpace, final java.lang.Boolean manualApprovals, final java.lang.Boolean confirmBroadeningPermissions, final software.amazon.awscdk.services.sns.ITopic securityNotificationTopic) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.extraRunOrderSpace = extraRunOrderSpace;
            this.manualApprovals = manualApprovals;
            this.confirmBroadeningPermissions = confirmBroadeningPermissions;
            this.securityNotificationTopic = securityNotificationTopic;
        }

        @Override
        public final java.lang.Number getExtraRunOrderSpace() {
            return this.extraRunOrderSpace;
        }

        @Override
        public final java.lang.Boolean getManualApprovals() {
            return this.manualApprovals;
        }

        @Override
        public final java.lang.Boolean getConfirmBroadeningPermissions() {
            return this.confirmBroadeningPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getSecurityNotificationTopic() {
            return this.securityNotificationTopic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExtraRunOrderSpace() != null) {
                data.set("extraRunOrderSpace", om.valueToTree(this.getExtraRunOrderSpace()));
            }
            if (this.getManualApprovals() != null) {
                data.set("manualApprovals", om.valueToTree(this.getManualApprovals()));
            }
            if (this.getConfirmBroadeningPermissions() != null) {
                data.set("confirmBroadeningPermissions", om.valueToTree(this.getConfirmBroadeningPermissions()));
            }
            if (this.getSecurityNotificationTopic() != null) {
                data.set("securityNotificationTopic", om.valueToTree(this.getSecurityNotificationTopic()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.AddStageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddStageOptions.Jsii$Proxy that = (AddStageOptions.Jsii$Proxy) o;

            if (this.extraRunOrderSpace != null ? !this.extraRunOrderSpace.equals(that.extraRunOrderSpace) : that.extraRunOrderSpace != null) return false;
            if (this.manualApprovals != null ? !this.manualApprovals.equals(that.manualApprovals) : that.manualApprovals != null) return false;
            if (this.confirmBroadeningPermissions != null ? !this.confirmBroadeningPermissions.equals(that.confirmBroadeningPermissions) : that.confirmBroadeningPermissions != null) return false;
            return this.securityNotificationTopic != null ? this.securityNotificationTopic.equals(that.securityNotificationTopic) : that.securityNotificationTopic == null;
        }

        @Override
        public final int hashCode() {
            int result = this.extraRunOrderSpace != null ? this.extraRunOrderSpace.hashCode() : 0;
            result = 31 * result + (this.manualApprovals != null ? this.manualApprovals.hashCode() : 0);
            result = 31 * result + (this.confirmBroadeningPermissions != null ? this.confirmBroadeningPermissions.hashCode() : 0);
            result = 31 * result + (this.securityNotificationTopic != null ? this.securityNotificationTopic.hashCode() : 0);
            return result;
        }
    }
}
