package software.amazon.awscdk.pipelines;

/**
 * (experimental) Properties for a CdkPipeline.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.155Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CdkPipelineProps")
@software.amazon.jsii.Jsii.Proxy(CdkPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CdkPipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The artifact you have defined to be the artifact to hold the cloudAssemblyArtifact for the synth action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyArtifact();

    /**
     * (experimental) Custom BuildSpec that is merged with generated one (for asset publishing actions).
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getAssetBuildSpec() {
        return null;
    }

    /**
     * (experimental) Additional commands to run before installing cdk-assets during the asset publishing step Use this to setup proxies or npm mirrors.
     * <p>
     * Default: -
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAssetPreInstallCommands() {
        return null;
    }

    /**
     * (experimental) CDK CLI version to use in pipeline.
     * <p>
     * Some Actions in the pipeline will download and run a version of the CDK
     * CLI. Specify the version here.
     * <p>
     * Default: - Latest version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCdkCliVersion() {
        return null;
    }

    /**
     * (experimental) Existing CodePipeline to add deployment stages to.
     * <p>
     * Use this if you want more control over the CodePipeline that gets created.
     * You can choose to not pass this value, in which case a new CodePipeline is
     * created with default settings.
     * <p>
     * If you pass an existing CodePipeline, it should should have been created
     * with <code>restartExecutionOnUpdate: true</code>.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - A new CodePipeline is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Pipeline getCodePipeline() {
        return null;
    }

    /**
     * (experimental) Create KMS keys for cross-account deployments.
     * <p>
     * This controls whether the pipeline is enabled for cross-account deployments.
     * <p>
     * Can only be set if <code>codePipeline</code> is not set.
     * <p>
     * By default cross-account deployments are enabled, but this feature requires
     * that KMS Customer Master Keys are created which have a cost of $1/month.
     * <p>
     * If you do not need cross-account deployments, you can set this to <code>false</code> to
     * not create those keys and save on that cost (the artifact bucket will be
     * encrypted with an AWS-managed key). However, cross-account deployments will
     * no longer be possible.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCrossAccountKeys() {
        return null;
    }

    /**
     * (experimental) A list of credentials used to authenticate to Docker registries.
     * <p>
     * Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.DockerCredential> getDockerCredentials() {
        return null;
    }

    /**
     * (experimental) Name of the pipeline.
     * <p>
     * Can only be set if <code>codePipeline</code> is not set.
     * <p>
     * Default: - A name is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineName() {
        return null;
    }

    /**
     * (experimental) Whether the pipeline will update itself.
     * <p>
     * This needs to be set to <code>true</code> to allow the pipeline to reconfigure
     * itself when assets or stages are being added to it, and <code>true</code> is the
     * recommended setting.
     * <p>
     * You can temporarily set this to <code>false</code> while you are iterating
     * on the pipeline itself and prefer to deploy changes using <code>cdk deploy</code>.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSelfMutating() {
        return null;
    }

    /**
     * (experimental) Custom BuildSpec that is merged with generated one (for self-mutation stage).
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getSelfMutationBuildSpec() {
        return null;
    }

    /**
     * (experimental) Whether this pipeline creates one asset upload action per asset type or one asset upload per asset.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSinglePublisherPerType() {
        return null;
    }

    /**
     * (experimental) The CodePipeline action used to retrieve the CDK app's source.
     * <p>
     * Default: - Required unless `codePipeline` is given
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.IAction getSourceAction() {
        return null;
    }

    /**
     * (experimental) Which subnets to use.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - All private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * (experimental) Whether the pipeline needs to build Docker images in the UpdatePipeline stage.
     * <p>
     * If the UpdatePipeline stage tries to build a Docker image and this flag is not
     * set to <code>true</code>, the build step will run in non-privileged mode and consequently
     * will fail with a message like:
     * <p>
     * <blockquote>
     * <p>
     * Cannot connect to the Docker daemon at unix:///var/run/docker.sock.
     * Is the docker daemon running?
     * <p>
     * </blockquote>
     * <p>
     * This flag has an effect only if <code>selfMutating</code> is also <code>true</code>.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportDockerAssets() {
        return null;
    }

    /**
     * (experimental) The CodePipeline action build and synthesis step of the CDK app.
     * <p>
     * Default: - Required unless `codePipeline` or `sourceAction` is given
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.IAction getSynthAction() {
        return null;
    }

    /**
     * (experimental) The VPC where to execute the CdkPipeline actions.
     * <p>
     * Default: - No VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CdkPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CdkPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CdkPipelineProps> {
        private software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact;
        private software.amazon.awscdk.services.codebuild.BuildSpec assetBuildSpec;
        private java.util.List<java.lang.String> assetPreInstallCommands;
        private java.lang.String cdkCliVersion;
        private software.amazon.awscdk.services.codepipeline.Pipeline codePipeline;
        private java.lang.Boolean crossAccountKeys;
        private java.util.List<software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials;
        private java.lang.String pipelineName;
        private java.lang.Boolean selfMutating;
        private software.amazon.awscdk.services.codebuild.BuildSpec selfMutationBuildSpec;
        private java.lang.Boolean singlePublisherPerType;
        private software.amazon.awscdk.services.codepipeline.IAction sourceAction;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private java.lang.Boolean supportDockerAssets;
        private software.amazon.awscdk.services.codepipeline.IAction synthAction;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link CdkPipelineProps#getCloudAssemblyArtifact}
         * @param cloudAssemblyArtifact The artifact you have defined to be the artifact to hold the cloudAssemblyArtifact for the synth action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudAssemblyArtifact(software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact) {
            this.cloudAssemblyArtifact = cloudAssemblyArtifact;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getAssetBuildSpec}
         * @param assetBuildSpec Custom BuildSpec that is merged with generated one (for asset publishing actions).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetBuildSpec(software.amazon.awscdk.services.codebuild.BuildSpec assetBuildSpec) {
            this.assetBuildSpec = assetBuildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getAssetPreInstallCommands}
         * @param assetPreInstallCommands Additional commands to run before installing cdk-assets during the asset publishing step Use this to setup proxies or npm mirrors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetPreInstallCommands(java.util.List<java.lang.String> assetPreInstallCommands) {
            this.assetPreInstallCommands = assetPreInstallCommands;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getCdkCliVersion}
         * @param cdkCliVersion CDK CLI version to use in pipeline.
         *                      Some Actions in the pipeline will download and run a version of the CDK
         *                      CLI. Specify the version here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkCliVersion(java.lang.String cdkCliVersion) {
            this.cdkCliVersion = cdkCliVersion;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getCodePipeline}
         * @param codePipeline Existing CodePipeline to add deployment stages to.
         *                     Use this if you want more control over the CodePipeline that gets created.
         *                     You can choose to not pass this value, in which case a new CodePipeline is
         *                     created with default settings.
         *                     <p>
         *                     If you pass an existing CodePipeline, it should should have been created
         *                     with <code>restartExecutionOnUpdate: true</code>.
         *                     <p>
         *                     [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codePipeline(software.amazon.awscdk.services.codepipeline.Pipeline codePipeline) {
            this.codePipeline = codePipeline;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getCrossAccountKeys}
         * @param crossAccountKeys Create KMS keys for cross-account deployments.
         *                         This controls whether the pipeline is enabled for cross-account deployments.
         *                         <p>
         *                         Can only be set if <code>codePipeline</code> is not set.
         *                         <p>
         *                         By default cross-account deployments are enabled, but this feature requires
         *                         that KMS Customer Master Keys are created which have a cost of $1/month.
         *                         <p>
         *                         If you do not need cross-account deployments, you can set this to <code>false</code> to
         *                         not create those keys and save on that cost (the artifact bucket will be
         *                         encrypted with an AWS-managed key). However, cross-account deployments will
         *                         no longer be possible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder crossAccountKeys(java.lang.Boolean crossAccountKeys) {
            this.crossAccountKeys = crossAccountKeys;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getDockerCredentials}
         * @param dockerCredentials A list of credentials used to authenticate to Docker registries.
         *                          Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder dockerCredentials(java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials) {
            this.dockerCredentials = (java.util.List<software.amazon.awscdk.pipelines.DockerCredential>)dockerCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getPipelineName}
         * @param pipelineName Name of the pipeline.
         *                     Can only be set if <code>codePipeline</code> is not set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getSelfMutating}
         * @param selfMutating Whether the pipeline will update itself.
         *                     This needs to be set to <code>true</code> to allow the pipeline to reconfigure
         *                     itself when assets or stages are being added to it, and <code>true</code> is the
         *                     recommended setting.
         *                     <p>
         *                     You can temporarily set this to <code>false</code> while you are iterating
         *                     on the pipeline itself and prefer to deploy changes using <code>cdk deploy</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder selfMutating(java.lang.Boolean selfMutating) {
            this.selfMutating = selfMutating;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getSelfMutationBuildSpec}
         * @param selfMutationBuildSpec Custom BuildSpec that is merged with generated one (for self-mutation stage).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder selfMutationBuildSpec(software.amazon.awscdk.services.codebuild.BuildSpec selfMutationBuildSpec) {
            this.selfMutationBuildSpec = selfMutationBuildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getSinglePublisherPerType}
         * @param singlePublisherPerType Whether this pipeline creates one asset upload action per asset type or one asset upload per asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder singlePublisherPerType(java.lang.Boolean singlePublisherPerType) {
            this.singlePublisherPerType = singlePublisherPerType;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getSourceAction}
         * @param sourceAction The CodePipeline action used to retrieve the CDK app's source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceAction(software.amazon.awscdk.services.codepipeline.IAction sourceAction) {
            this.sourceAction = sourceAction;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getSubnetSelection}
         * @param subnetSelection Which subnets to use.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getSupportDockerAssets}
         * @param supportDockerAssets Whether the pipeline needs to build Docker images in the UpdatePipeline stage.
         *                            If the UpdatePipeline stage tries to build a Docker image and this flag is not
         *                            set to <code>true</code>, the build step will run in non-privileged mode and consequently
         *                            will fail with a message like:
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            Cannot connect to the Docker daemon at unix:///var/run/docker.sock.
         *                            Is the docker daemon running?
         *                            <p>
         *                            </blockquote>
         *                            <p>
         *                            This flag has an effect only if <code>selfMutating</code> is also <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportDockerAssets(java.lang.Boolean supportDockerAssets) {
            this.supportDockerAssets = supportDockerAssets;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getSynthAction}
         * @param synthAction The CodePipeline action build and synthesis step of the CDK app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder synthAction(software.amazon.awscdk.services.codepipeline.IAction synthAction) {
            this.synthAction = synthAction;
            return this;
        }

        /**
         * Sets the value of {@link CdkPipelineProps#getVpc}
         * @param vpc The VPC where to execute the CdkPipeline actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CdkPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CdkPipelineProps build() {
            return new Jsii$Proxy(cloudAssemblyArtifact, assetBuildSpec, assetPreInstallCommands, cdkCliVersion, codePipeline, crossAccountKeys, dockerCredentials, pipelineName, selfMutating, selfMutationBuildSpec, singlePublisherPerType, sourceAction, subnetSelection, supportDockerAssets, synthAction, vpc);
        }
    }

    /**
     * An implementation for {@link CdkPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdkPipelineProps {
        private final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact;
        private final software.amazon.awscdk.services.codebuild.BuildSpec assetBuildSpec;
        private final java.util.List<java.lang.String> assetPreInstallCommands;
        private final java.lang.String cdkCliVersion;
        private final software.amazon.awscdk.services.codepipeline.Pipeline codePipeline;
        private final java.lang.Boolean crossAccountKeys;
        private final java.util.List<software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials;
        private final java.lang.String pipelineName;
        private final java.lang.Boolean selfMutating;
        private final software.amazon.awscdk.services.codebuild.BuildSpec selfMutationBuildSpec;
        private final java.lang.Boolean singlePublisherPerType;
        private final software.amazon.awscdk.services.codepipeline.IAction sourceAction;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final java.lang.Boolean supportDockerAssets;
        private final software.amazon.awscdk.services.codepipeline.IAction synthAction;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudAssemblyArtifact = software.amazon.jsii.Kernel.get(this, "cloudAssemblyArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.assetBuildSpec = software.amazon.jsii.Kernel.get(this, "assetBuildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.assetPreInstallCommands = software.amazon.jsii.Kernel.get(this, "assetPreInstallCommands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cdkCliVersion = software.amazon.jsii.Kernel.get(this, "cdkCliVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codePipeline = software.amazon.jsii.Kernel.get(this, "codePipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Pipeline.class));
            this.crossAccountKeys = software.amazon.jsii.Kernel.get(this, "crossAccountKeys", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dockerCredentials = software.amazon.jsii.Kernel.get(this, "dockerCredentials", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.DockerCredential.class)));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.selfMutating = software.amazon.jsii.Kernel.get(this, "selfMutating", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.selfMutationBuildSpec = software.amazon.jsii.Kernel.get(this, "selfMutationBuildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.singlePublisherPerType = software.amazon.jsii.Kernel.get(this, "singlePublisherPerType", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sourceAction = software.amazon.jsii.Kernel.get(this, "sourceAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IAction.class));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.supportDockerAssets = software.amazon.jsii.Kernel.get(this, "supportDockerAssets", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.synthAction = software.amazon.jsii.Kernel.get(this, "synthAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IAction.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact, final software.amazon.awscdk.services.codebuild.BuildSpec assetBuildSpec, final java.util.List<java.lang.String> assetPreInstallCommands, final java.lang.String cdkCliVersion, final software.amazon.awscdk.services.codepipeline.Pipeline codePipeline, final java.lang.Boolean crossAccountKeys, final java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials, final java.lang.String pipelineName, final java.lang.Boolean selfMutating, final software.amazon.awscdk.services.codebuild.BuildSpec selfMutationBuildSpec, final java.lang.Boolean singlePublisherPerType, final software.amazon.awscdk.services.codepipeline.IAction sourceAction, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final java.lang.Boolean supportDockerAssets, final software.amazon.awscdk.services.codepipeline.IAction synthAction, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudAssemblyArtifact = java.util.Objects.requireNonNull(cloudAssemblyArtifact, "cloudAssemblyArtifact is required");
            this.assetBuildSpec = assetBuildSpec;
            this.assetPreInstallCommands = assetPreInstallCommands;
            this.cdkCliVersion = cdkCliVersion;
            this.codePipeline = codePipeline;
            this.crossAccountKeys = crossAccountKeys;
            this.dockerCredentials = (java.util.List<software.amazon.awscdk.pipelines.DockerCredential>)dockerCredentials;
            this.pipelineName = pipelineName;
            this.selfMutating = selfMutating;
            this.selfMutationBuildSpec = selfMutationBuildSpec;
            this.singlePublisherPerType = singlePublisherPerType;
            this.sourceAction = sourceAction;
            this.subnetSelection = subnetSelection;
            this.supportDockerAssets = supportDockerAssets;
            this.synthAction = synthAction;
            this.vpc = vpc;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyArtifact() {
            return this.cloudAssemblyArtifact;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getAssetBuildSpec() {
            return this.assetBuildSpec;
        }

        @Override
        public final java.util.List<java.lang.String> getAssetPreInstallCommands() {
            return this.assetPreInstallCommands;
        }

        @Override
        public final java.lang.String getCdkCliVersion() {
            return this.cdkCliVersion;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Pipeline getCodePipeline() {
            return this.codePipeline;
        }

        @Override
        public final java.lang.Boolean getCrossAccountKeys() {
            return this.crossAccountKeys;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.DockerCredential> getDockerCredentials() {
            return this.dockerCredentials;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final java.lang.Boolean getSelfMutating() {
            return this.selfMutating;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getSelfMutationBuildSpec() {
            return this.selfMutationBuildSpec;
        }

        @Override
        public final java.lang.Boolean getSinglePublisherPerType() {
            return this.singlePublisherPerType;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.IAction getSourceAction() {
            return this.sourceAction;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final java.lang.Boolean getSupportDockerAssets() {
            return this.supportDockerAssets;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.IAction getSynthAction() {
            return this.synthAction;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cloudAssemblyArtifact", om.valueToTree(this.getCloudAssemblyArtifact()));
            if (this.getAssetBuildSpec() != null) {
                data.set("assetBuildSpec", om.valueToTree(this.getAssetBuildSpec()));
            }
            if (this.getAssetPreInstallCommands() != null) {
                data.set("assetPreInstallCommands", om.valueToTree(this.getAssetPreInstallCommands()));
            }
            if (this.getCdkCliVersion() != null) {
                data.set("cdkCliVersion", om.valueToTree(this.getCdkCliVersion()));
            }
            if (this.getCodePipeline() != null) {
                data.set("codePipeline", om.valueToTree(this.getCodePipeline()));
            }
            if (this.getCrossAccountKeys() != null) {
                data.set("crossAccountKeys", om.valueToTree(this.getCrossAccountKeys()));
            }
            if (this.getDockerCredentials() != null) {
                data.set("dockerCredentials", om.valueToTree(this.getDockerCredentials()));
            }
            if (this.getPipelineName() != null) {
                data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            }
            if (this.getSelfMutating() != null) {
                data.set("selfMutating", om.valueToTree(this.getSelfMutating()));
            }
            if (this.getSelfMutationBuildSpec() != null) {
                data.set("selfMutationBuildSpec", om.valueToTree(this.getSelfMutationBuildSpec()));
            }
            if (this.getSinglePublisherPerType() != null) {
                data.set("singlePublisherPerType", om.valueToTree(this.getSinglePublisherPerType()));
            }
            if (this.getSourceAction() != null) {
                data.set("sourceAction", om.valueToTree(this.getSourceAction()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getSupportDockerAssets() != null) {
                data.set("supportDockerAssets", om.valueToTree(this.getSupportDockerAssets()));
            }
            if (this.getSynthAction() != null) {
                data.set("synthAction", om.valueToTree(this.getSynthAction()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.CdkPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CdkPipelineProps.Jsii$Proxy that = (CdkPipelineProps.Jsii$Proxy) o;

            if (!cloudAssemblyArtifact.equals(that.cloudAssemblyArtifact)) return false;
            if (this.assetBuildSpec != null ? !this.assetBuildSpec.equals(that.assetBuildSpec) : that.assetBuildSpec != null) return false;
            if (this.assetPreInstallCommands != null ? !this.assetPreInstallCommands.equals(that.assetPreInstallCommands) : that.assetPreInstallCommands != null) return false;
            if (this.cdkCliVersion != null ? !this.cdkCliVersion.equals(that.cdkCliVersion) : that.cdkCliVersion != null) return false;
            if (this.codePipeline != null ? !this.codePipeline.equals(that.codePipeline) : that.codePipeline != null) return false;
            if (this.crossAccountKeys != null ? !this.crossAccountKeys.equals(that.crossAccountKeys) : that.crossAccountKeys != null) return false;
            if (this.dockerCredentials != null ? !this.dockerCredentials.equals(that.dockerCredentials) : that.dockerCredentials != null) return false;
            if (this.pipelineName != null ? !this.pipelineName.equals(that.pipelineName) : that.pipelineName != null) return false;
            if (this.selfMutating != null ? !this.selfMutating.equals(that.selfMutating) : that.selfMutating != null) return false;
            if (this.selfMutationBuildSpec != null ? !this.selfMutationBuildSpec.equals(that.selfMutationBuildSpec) : that.selfMutationBuildSpec != null) return false;
            if (this.singlePublisherPerType != null ? !this.singlePublisherPerType.equals(that.singlePublisherPerType) : that.singlePublisherPerType != null) return false;
            if (this.sourceAction != null ? !this.sourceAction.equals(that.sourceAction) : that.sourceAction != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.supportDockerAssets != null ? !this.supportDockerAssets.equals(that.supportDockerAssets) : that.supportDockerAssets != null) return false;
            if (this.synthAction != null ? !this.synthAction.equals(that.synthAction) : that.synthAction != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudAssemblyArtifact.hashCode();
            result = 31 * result + (this.assetBuildSpec != null ? this.assetBuildSpec.hashCode() : 0);
            result = 31 * result + (this.assetPreInstallCommands != null ? this.assetPreInstallCommands.hashCode() : 0);
            result = 31 * result + (this.cdkCliVersion != null ? this.cdkCliVersion.hashCode() : 0);
            result = 31 * result + (this.codePipeline != null ? this.codePipeline.hashCode() : 0);
            result = 31 * result + (this.crossAccountKeys != null ? this.crossAccountKeys.hashCode() : 0);
            result = 31 * result + (this.dockerCredentials != null ? this.dockerCredentials.hashCode() : 0);
            result = 31 * result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            result = 31 * result + (this.selfMutating != null ? this.selfMutating.hashCode() : 0);
            result = 31 * result + (this.selfMutationBuildSpec != null ? this.selfMutationBuildSpec.hashCode() : 0);
            result = 31 * result + (this.singlePublisherPerType != null ? this.singlePublisherPerType.hashCode() : 0);
            result = 31 * result + (this.sourceAction != null ? this.sourceAction.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.supportDockerAssets != null ? this.supportDockerAssets.hashCode() : 0);
            result = 31 * result + (this.synthAction != null ? this.synthAction.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
