package software.amazon.awscdk.pipelines;

/**
 * (experimental) Stage in a CdkPipeline.
 * <p>
 * You don't need to instantiate this class directly. Use
 * <code>cdkPipeline.addStage()</code> instead.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.157Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CdkStage")
public class CdkStage extends software.constructs.Construct {

    protected CdkStage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CdkStage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CdkStage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CdkStageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Add one or more CodePipeline Actions.
     * <p>
     * You need to make sure it is created with the right runOrder. Call <code>nextSequentialRunOrder()</code>
     * for every action to get actions to execute in sequence.
     * <p>
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IAction... actions) {
        software.amazon.jsii.Kernel.call(this, "addActions", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * (experimental) Add all stacks in the application Stage to this stage.
     * <p>
     * The application construct should subclass <code>Stage</code> and can contain any
     * number of <code>Stacks</code> inside it that may have dependency relationships
     * on one another.
     * <p>
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     * <p>
     * @param appStage This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage appStage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.AddStageOptions options) {
        software.amazon.jsii.Kernel.call(this, "addApplication", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(appStage, "appStage is required"), options });
    }

    /**
     * (experimental) Add all stacks in the application Stage to this stage.
     * <p>
     * The application construct should subclass <code>Stage</code> and can contain any
     * number of <code>Stacks</code> inside it that may have dependency relationships
     * on one another.
     * <p>
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     * <p>
     * @param appStage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage appStage) {
        software.amazon.jsii.Kernel.call(this, "addApplication", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(appStage, "appStage is required") });
    }

    /**
     * (experimental) Add a manual approval action.
     * <p>
     * If you need more flexibility than what this method offers,
     * use <code>addAction</code> with a <code>ManualApprovalAction</code>.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addManualApprovalAction(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.AddManualApprovalOptions options) {
        software.amazon.jsii.Kernel.call(this, "addManualApprovalAction", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * (experimental) Add a manual approval action.
     * <p>
     * If you need more flexibility than what this method offers,
     * use <code>addAction</code> with a <code>ManualApprovalAction</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addManualApprovalAction() {
        software.amazon.jsii.Kernel.call(this, "addManualApprovalAction", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Add a deployment action based on a stack artifact.
     * <p>
     * @param stackArtifact This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addStackArtifactDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudFormationStackArtifact stackArtifact, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.AddStackOptions options) {
        software.amazon.jsii.Kernel.call(this, "addStackArtifactDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stackArtifact, "stackArtifact is required"), options });
    }

    /**
     * (experimental) Add a deployment action based on a stack artifact.
     * <p>
     * @param stackArtifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addStackArtifactDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudFormationStackArtifact stackArtifact) {
        software.amazon.jsii.Kernel.call(this, "addStackArtifactDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stackArtifact, "stackArtifact is required") });
    }

    /**
     * (experimental) Whether this Stage contains an action to deploy the given stack, identified by its artifact ID.
     * <p>
     * @param artifactId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean deploysStack(final @org.jetbrains.annotations.NotNull java.lang.String artifactId) {
        return software.amazon.jsii.Kernel.call(this, "deploysStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(artifactId, "artifactId is required") });
    }

    /**
     * (experimental) Return the runOrder number necessary to run the next Action in sequence with the rest.
     * <p>
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     * <p>
     * @param count
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number nextSequentialRunOrder(final @org.jetbrains.annotations.Nullable java.lang.Number count) {
        return software.amazon.jsii.Kernel.call(this, "nextSequentialRunOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { count });
    }

    /**
     * (experimental) Return the runOrder number necessary to run the next Action in sequence with the rest.
     * <p>
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number nextSequentialRunOrder() {
        return software.amazon.jsii.Kernel.call(this, "nextSequentialRunOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.pipelines.CdkStage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.CdkStage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.pipelines.CdkStageProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.pipelines.CdkStageProps.Builder();
        }

        /**
         * (experimental) The CodePipeline Artifact with the Cloud Assembly.
         * <p>
         * @return {@code this}
         * @param cloudAssemblyArtifact The CodePipeline Artifact with the Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudAssemblyArtifact(final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact) {
            this.props.cloudAssemblyArtifact(cloudAssemblyArtifact);
            return this;
        }

        /**
         * (experimental) Features the Stage needs from its environment.
         * <p>
         * @return {@code this}
         * @param host Features the Stage needs from its environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder host(final software.amazon.awscdk.pipelines.IStageHost host) {
            this.props.host(host);
            return this;
        }

        /**
         * (experimental) The underlying Pipeline Stage associated with thisCdkStage.
         * <p>
         * @return {@code this}
         * @param pipelineStage The underlying Pipeline Stage associated with thisCdkStage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pipelineStage(final software.amazon.awscdk.services.codepipeline.IStage pipelineStage) {
            this.props.pipelineStage(pipelineStage);
            return this;
        }

        /**
         * (experimental) Name of the stage that should be created.
         * <p>
         * @return {@code this}
         * @param stageName Name of the stage that should be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * (experimental) Run a security check before every application prepare/deploy actions.
         * <p>
         * Note: Stage level security check can be overriden per application as follows:
         * <code>stage.addApplication(app, { confirmBroadeningPermissions: false })</code>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param confirmBroadeningPermissions Run a security check before every application prepare/deploy actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder confirmBroadeningPermissions(final java.lang.Boolean confirmBroadeningPermissions) {
            this.props.confirmBroadeningPermissions(confirmBroadeningPermissions);
            return this;
        }

        /**
         * (experimental) Optional SNS topic to send notifications to when any security check registers changes within a application.
         * <p>
         * Note: The Stage Notification Topic can be overriden per application as follows:
         * <code>stage.addApplication(app, { securityNotificationTopic: newTopic })</code>
         * <p>
         * Default: undefined no stage level notification topic
         * <p>
         * @return {@code this}
         * @param securityNotificationTopic Optional SNS topic to send notifications to when any security check registers changes within a application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityNotificationTopic(final software.amazon.awscdk.services.sns.ITopic securityNotificationTopic) {
            this.props.securityNotificationTopic(securityNotificationTopic);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.pipelines.CdkStage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.pipelines.CdkStage build() {
            return new software.amazon.awscdk.pipelines.CdkStage(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
