package software.amazon.awscdk.pipelines;

/**
 * (experimental) Construction properties for a CdkStage.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.168Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CdkStageProps")
@software.amazon.jsii.Jsii.Proxy(CdkStageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CdkStageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The CodePipeline Artifact with the Cloud Assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyArtifact();

    /**
     * (experimental) Features the Stage needs from its environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.IStageHost getHost();

    /**
     * (experimental) The underlying Pipeline Stage associated with thisCdkStage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage getPipelineStage();

    /**
     * (experimental) Name of the stage that should be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getStageName();

    /**
     * (experimental) Run a security check before every application prepare/deploy actions.
     * <p>
     * Note: Stage level security check can be overriden per application as follows:
     * <code>stage.addApplication(app, { confirmBroadeningPermissions: false })</code>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getConfirmBroadeningPermissions() {
        return null;
    }

    /**
     * (experimental) Optional SNS topic to send notifications to when any security check registers changes within a application.
     * <p>
     * Note: The Stage Notification Topic can be overriden per application as follows:
     * <code>stage.addApplication(app, { securityNotificationTopic: newTopic })</code>
     * <p>
     * Default: undefined no stage level notification topic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getSecurityNotificationTopic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CdkStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CdkStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CdkStageProps> {
        private software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact;
        private software.amazon.awscdk.pipelines.IStageHost host;
        private software.amazon.awscdk.services.codepipeline.IStage pipelineStage;
        private java.lang.String stageName;
        private java.lang.Boolean confirmBroadeningPermissions;
        private software.amazon.awscdk.services.sns.ITopic securityNotificationTopic;

        /**
         * Sets the value of {@link CdkStageProps#getCloudAssemblyArtifact}
         * @param cloudAssemblyArtifact The CodePipeline Artifact with the Cloud Assembly. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudAssemblyArtifact(software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact) {
            this.cloudAssemblyArtifact = cloudAssemblyArtifact;
            return this;
        }

        /**
         * Sets the value of {@link CdkStageProps#getHost}
         * @param host Features the Stage needs from its environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder host(software.amazon.awscdk.pipelines.IStageHost host) {
            this.host = host;
            return this;
        }

        /**
         * Sets the value of {@link CdkStageProps#getPipelineStage}
         * @param pipelineStage The underlying Pipeline Stage associated with thisCdkStage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pipelineStage(software.amazon.awscdk.services.codepipeline.IStage pipelineStage) {
            this.pipelineStage = pipelineStage;
            return this;
        }

        /**
         * Sets the value of {@link CdkStageProps#getStageName}
         * @param stageName Name of the stage that should be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link CdkStageProps#getConfirmBroadeningPermissions}
         * @param confirmBroadeningPermissions Run a security check before every application prepare/deploy actions.
         *                                     Note: Stage level security check can be overriden per application as follows:
         *                                     <code>stage.addApplication(app, { confirmBroadeningPermissions: false })</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder confirmBroadeningPermissions(java.lang.Boolean confirmBroadeningPermissions) {
            this.confirmBroadeningPermissions = confirmBroadeningPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CdkStageProps#getSecurityNotificationTopic}
         * @param securityNotificationTopic Optional SNS topic to send notifications to when any security check registers changes within a application.
         *                                  Note: The Stage Notification Topic can be overriden per application as follows:
         *                                  <code>stage.addApplication(app, { securityNotificationTopic: newTopic })</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityNotificationTopic(software.amazon.awscdk.services.sns.ITopic securityNotificationTopic) {
            this.securityNotificationTopic = securityNotificationTopic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CdkStageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CdkStageProps build() {
            return new Jsii$Proxy(cloudAssemblyArtifact, host, pipelineStage, stageName, confirmBroadeningPermissions, securityNotificationTopic);
        }
    }

    /**
     * An implementation for {@link CdkStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdkStageProps {
        private final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact;
        private final software.amazon.awscdk.pipelines.IStageHost host;
        private final software.amazon.awscdk.services.codepipeline.IStage pipelineStage;
        private final java.lang.String stageName;
        private final java.lang.Boolean confirmBroadeningPermissions;
        private final software.amazon.awscdk.services.sns.ITopic securityNotificationTopic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudAssemblyArtifact = software.amazon.jsii.Kernel.get(this, "cloudAssemblyArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IStageHost.class));
            this.pipelineStage = software.amazon.jsii.Kernel.get(this, "pipelineStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.confirmBroadeningPermissions = software.amazon.jsii.Kernel.get(this, "confirmBroadeningPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityNotificationTopic = software.amazon.jsii.Kernel.get(this, "securityNotificationTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact, final software.amazon.awscdk.pipelines.IStageHost host, final software.amazon.awscdk.services.codepipeline.IStage pipelineStage, final java.lang.String stageName, final java.lang.Boolean confirmBroadeningPermissions, final software.amazon.awscdk.services.sns.ITopic securityNotificationTopic) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudAssemblyArtifact = java.util.Objects.requireNonNull(cloudAssemblyArtifact, "cloudAssemblyArtifact is required");
            this.host = java.util.Objects.requireNonNull(host, "host is required");
            this.pipelineStage = java.util.Objects.requireNonNull(pipelineStage, "pipelineStage is required");
            this.stageName = java.util.Objects.requireNonNull(stageName, "stageName is required");
            this.confirmBroadeningPermissions = confirmBroadeningPermissions;
            this.securityNotificationTopic = securityNotificationTopic;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyArtifact() {
            return this.cloudAssemblyArtifact;
        }

        @Override
        public final software.amazon.awscdk.pipelines.IStageHost getHost() {
            return this.host;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.IStage getPipelineStage() {
            return this.pipelineStage;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.lang.Boolean getConfirmBroadeningPermissions() {
            return this.confirmBroadeningPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getSecurityNotificationTopic() {
            return this.securityNotificationTopic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cloudAssemblyArtifact", om.valueToTree(this.getCloudAssemblyArtifact()));
            data.set("host", om.valueToTree(this.getHost()));
            data.set("pipelineStage", om.valueToTree(this.getPipelineStage()));
            data.set("stageName", om.valueToTree(this.getStageName()));
            if (this.getConfirmBroadeningPermissions() != null) {
                data.set("confirmBroadeningPermissions", om.valueToTree(this.getConfirmBroadeningPermissions()));
            }
            if (this.getSecurityNotificationTopic() != null) {
                data.set("securityNotificationTopic", om.valueToTree(this.getSecurityNotificationTopic()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.CdkStageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CdkStageProps.Jsii$Proxy that = (CdkStageProps.Jsii$Proxy) o;

            if (!cloudAssemblyArtifact.equals(that.cloudAssemblyArtifact)) return false;
            if (!host.equals(that.host)) return false;
            if (!pipelineStage.equals(that.pipelineStage)) return false;
            if (!stageName.equals(that.stageName)) return false;
            if (this.confirmBroadeningPermissions != null ? !this.confirmBroadeningPermissions.equals(that.confirmBroadeningPermissions) : that.confirmBroadeningPermissions != null) return false;
            return this.securityNotificationTopic != null ? this.securityNotificationTopic.equals(that.securityNotificationTopic) : that.securityNotificationTopic == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudAssemblyArtifact.hashCode();
            result = 31 * result + (this.host.hashCode());
            result = 31 * result + (this.pipelineStage.hashCode());
            result = 31 * result + (this.stageName.hashCode());
            result = 31 * result + (this.confirmBroadeningPermissions != null ? this.confirmBroadeningPermissions.hashCode() : 0);
            result = 31 * result + (this.securityNotificationTopic != null ? this.securityNotificationTopic.hashCode() : 0);
            return result;
        }
    }
}
