package software.amazon.awscdk.pipelines;

/**
 * (experimental) Action to deploy a CDK Stack.
 * <p>
 * Adds two CodePipeline Actions to the pipeline: one to create a ChangeSet
 * and one to execute it.
 * <p>
 * You do not need to instantiate this action yourself -- it will automatically
 * be added by the pipeline when you add stack artifacts or entire stages.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.789Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.DeployCdkStackAction")
public class DeployCdkStackAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.IAction {

    protected DeployCdkStackAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DeployCdkStackAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DeployCdkStackAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.DeployCdkStackActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Construct a DeployCdkStackAction from a Stack artifact.
     * <p>
     * @param scope This parameter is required.
     * @param artifact This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.DeployCdkStackAction fromStackArtifact(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudFormationStackArtifact artifact, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CdkStackActionFromArtifactOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.DeployCdkStackAction.class, "fromStackArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.DeployCdkStackAction.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(artifact, "artifact is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param name This parameter is required.
     * @param target
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleProps options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target, options });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param name This parameter is required.
     * @param target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Exists to implement IAction.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionProperties getActionProperties() {
        return software.amazon.jsii.Kernel.get(this, "actionProperties", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionProperties.class));
    }

    /**
     * (experimental) Artifact ids of the artifact this stack artifact depends on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDependencyStackArtifactIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencyStackArtifactIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) The runorder for the execute action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number getExecuteRunOrder() {
        return software.amazon.jsii.Kernel.get(this, "executeRunOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) The runorder for the prepare action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPrepareRunOrder() {
        return software.amazon.jsii.Kernel.get(this, "prepareRunOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Name of the deployed stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackName() {
        return software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Artifact id of the artifact this action was based on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getStackArtifactId() {
        return software.amazon.jsii.Kernel.get(this, "stackArtifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.pipelines.DeployCdkStackAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.DeployCdkStackAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.pipelines.DeployCdkStackActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.pipelines.DeployCdkStackActionProps.Builder();
        }

        /**
         * (experimental) The CodePipeline artifact that holds the Cloud Assembly.
         * <p>
         * @return {@code this}
         * @param cloudAssemblyInput The CodePipeline artifact that holds the Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudAssemblyInput(final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyInput) {
            this.props.cloudAssemblyInput(cloudAssemblyInput);
            return this;
        }

        /**
         * (experimental) Base name of the action.
         * <p>
         * Default: stackName
         * <p>
         * @return {@code this}
         * @param baseActionName Base name of the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder baseActionName(final java.lang.String baseActionName) {
            this.props.baseActionName(baseActionName);
            return this;
        }

        /**
         * (experimental) Name of the change set to create and deploy.
         * <p>
         * Default: 'PipelineChange'
         * <p>
         * @return {@code this}
         * @param changeSetName Name of the change set to create and deploy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder changeSetName(final java.lang.String changeSetName) {
            this.props.changeSetName(changeSetName);
            return this;
        }

        /**
         * (experimental) Run order for the Execute action.
         * <p>
         * Default: - prepareRunOrder + 1
         * <p>
         * @return {@code this}
         * @param executeRunOrder Run order for the Execute action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executeRunOrder(final java.lang.Number executeRunOrder) {
            this.props.executeRunOrder(executeRunOrder);
            return this;
        }

        /**
         * (experimental) Artifact to write Stack Outputs to.
         * <p>
         * Default: - No outputs
         * <p>
         * @return {@code this}
         * @param output Artifact to write Stack Outputs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * (experimental) Filename in output to write Stack outputs to.
         * <p>
         * Default: - Required when 'output' is set
         * <p>
         * @return {@code this}
         * @param outputFileName Filename in output to write Stack outputs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputFileName(final java.lang.String outputFileName) {
            this.props.outputFileName(outputFileName);
            return this;
        }

        /**
         * (experimental) Run order for the Prepare action.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param prepareRunOrder Run order for the Prepare action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prepareRunOrder(final java.lang.Number prepareRunOrder) {
            this.props.prepareRunOrder(prepareRunOrder);
            return this;
        }

        /**
         * (experimental) Role for the action to assume.
         * <p>
         * This controls the account to deploy into
         * <p>
         * @return {@code this}
         * @param actionRole Role for the action to assume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionRole(final software.amazon.awscdk.services.iam.IRole actionRole) {
            this.props.actionRole(actionRole);
            return this;
        }

        /**
         * (experimental) The name of the stack that should be created/updated.
         * <p>
         * @return {@code this}
         * @param stackName The name of the stack that should be created/updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackName(final java.lang.String stackName) {
            this.props.stackName(stackName);
            return this;
        }

        /**
         * (experimental) Relative path of template in the input artifact.
         * <p>
         * @return {@code this}
         * @param templatePath Relative path of template in the input artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder templatePath(final java.lang.String templatePath) {
            this.props.templatePath(templatePath);
            return this;
        }

        /**
         * (experimental) Role to execute CloudFormation under.
         * <p>
         * Default: - Execute CloudFormation using the action role
         * <p>
         * @return {@code this}
         * @param cloudFormationExecutionRole Role to execute CloudFormation under. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudFormationExecutionRole(final software.amazon.awscdk.services.iam.IRole cloudFormationExecutionRole) {
            this.props.cloudFormationExecutionRole(cloudFormationExecutionRole);
            return this;
        }

        /**
         * (experimental) Artifact ID for the stacks this stack depends on.
         * <p>
         * Used for pipeline order checking.
         * <p>
         * Default: - No dependencies
         * <p>
         * @return {@code this}
         * @param dependencyStackArtifactIds Artifact ID for the stacks this stack depends on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependencyStackArtifactIds(final java.util.List<java.lang.String> dependencyStackArtifactIds) {
            this.props.dependencyStackArtifactIds(dependencyStackArtifactIds);
            return this;
        }

        /**
         * (experimental) Region to deploy into.
         * <p>
         * Default: - Same region as pipeline
         * <p>
         * @return {@code this}
         * @param region Region to deploy into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * (experimental) Artifact ID for the stack deployed here.
         * <p>
         * Used for pipeline order checking.
         * <p>
         * Default: - Order will not be checked
         * <p>
         * @return {@code this}
         * @param stackArtifactId Artifact ID for the stack deployed here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackArtifactId(final java.lang.String stackArtifactId) {
            this.props.stackArtifactId(stackArtifactId);
            return this;
        }

        /**
         * (experimental) Template configuration path relative to the input artifact.
         * <p>
         * Default: - No template configuration
         * <p>
         * @return {@code this}
         * @param templateConfigurationPath Template configuration path relative to the input artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder templateConfigurationPath(final java.lang.String templateConfigurationPath) {
            this.props.templateConfigurationPath(templateConfigurationPath);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.pipelines.DeployCdkStackAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.pipelines.DeployCdkStackAction build() {
            return new software.amazon.awscdk.pipelines.DeployCdkStackAction(
                this.props.build()
            );
        }
    }
}
