package software.amazon.awscdk.pipelines;

/**
 * (experimental) Options for the `CodePipelineActionFactory.produce()` method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.807Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ProduceActionOptions")
@software.amazon.jsii.Jsii.Proxy(ProduceActionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ProduceActionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Name the action should get.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getActionName();

    /**
     * (experimental) Helper object to translate FileSets to CodePipeline Artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ArtifactMap getArtifacts();

    /**
     * (experimental) The pipeline the action is being generated for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipeline getPipeline();

    /**
     * (experimental) RunOrder the action should get.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getRunOrder();

    /**
     * (experimental) Scope in which to create constructs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.constructs.Construct getScope();

    /**
     * (experimental) Whether or not this action is inserted before self mutation.
     * <p>
     * If it is, the action should take care to reflect some part of
     * its own definition in the pipeline action definition, to
     * trigger a restart after self-mutation (if necessary).
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBeforeSelfMutation() {
        return null;
    }

    /**
     * (experimental) If this action factory creates a CodeBuild step, default options to inherit.
     * <p>
     * Default: - No CodeBuild project defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.CodeBuildOptions getCodeBuildDefaults() {
        return null;
    }

    /**
     * (experimental) An input artifact that CodeBuild projects that don't actually need an input artifact can use.
     * <p>
     * CodeBuild Projects MUST have an input artifact in order to be added to the Pipeline. If
     * the Project doesn't actually care about its input (it can be anything), it can use the
     * Artifact passed here.
     * <p>
     * Default: - A fallback artifact does not exist
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Artifact getFallbackArtifact() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProduceActionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProduceActionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ProduceActionOptions> {
        private java.lang.String actionName;
        private software.amazon.awscdk.pipelines.ArtifactMap artifacts;
        private software.amazon.awscdk.pipelines.CodePipeline pipeline;
        private java.lang.Number runOrder;
        private software.constructs.Construct scope;
        private java.lang.Boolean beforeSelfMutation;
        private software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults;
        private software.amazon.awscdk.services.codepipeline.Artifact fallbackArtifact;

        /**
         * Sets the value of {@link ProduceActionOptions#getActionName}
         * @param actionName Name the action should get. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link ProduceActionOptions#getArtifacts}
         * @param artifacts Helper object to translate FileSets to CodePipeline Artifacts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifacts(software.amazon.awscdk.pipelines.ArtifactMap artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        /**
         * Sets the value of {@link ProduceActionOptions#getPipeline}
         * @param pipeline The pipeline the action is being generated for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pipeline(software.amazon.awscdk.pipelines.CodePipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        /**
         * Sets the value of {@link ProduceActionOptions#getRunOrder}
         * @param runOrder RunOrder the action should get. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link ProduceActionOptions#getScope}
         * @param scope Scope in which to create constructs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scope(software.constructs.Construct scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link ProduceActionOptions#getBeforeSelfMutation}
         * @param beforeSelfMutation Whether or not this action is inserted before self mutation.
         *                           If it is, the action should take care to reflect some part of
         *                           its own definition in the pipeline action definition, to
         *                           trigger a restart after self-mutation (if necessary).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder beforeSelfMutation(java.lang.Boolean beforeSelfMutation) {
            this.beforeSelfMutation = beforeSelfMutation;
            return this;
        }

        /**
         * Sets the value of {@link ProduceActionOptions#getCodeBuildDefaults}
         * @param codeBuildDefaults If this action factory creates a CodeBuild step, default options to inherit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults) {
            this.codeBuildDefaults = codeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link ProduceActionOptions#getFallbackArtifact}
         * @param fallbackArtifact An input artifact that CodeBuild projects that don't actually need an input artifact can use.
         *                         CodeBuild Projects MUST have an input artifact in order to be added to the Pipeline. If
         *                         the Project doesn't actually care about its input (it can be anything), it can use the
         *                         Artifact passed here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fallbackArtifact(software.amazon.awscdk.services.codepipeline.Artifact fallbackArtifact) {
            this.fallbackArtifact = fallbackArtifact;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProduceActionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ProduceActionOptions build() {
            return new Jsii$Proxy(actionName, artifacts, pipeline, runOrder, scope, beforeSelfMutation, codeBuildDefaults, fallbackArtifact);
        }
    }

    /**
     * An implementation for {@link ProduceActionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProduceActionOptions {
        private final java.lang.String actionName;
        private final software.amazon.awscdk.pipelines.ArtifactMap artifacts;
        private final software.amazon.awscdk.pipelines.CodePipeline pipeline;
        private final java.lang.Number runOrder;
        private final software.constructs.Construct scope;
        private final java.lang.Boolean beforeSelfMutation;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults;
        private final software.amazon.awscdk.services.codepipeline.Artifact fallbackArtifact;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.artifacts = software.amazon.jsii.Kernel.get(this, "artifacts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.ArtifactMap.class));
            this.pipeline = software.amazon.jsii.Kernel.get(this, "pipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipeline.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class));
            this.beforeSelfMutation = software.amazon.jsii.Kernel.get(this, "beforeSelfMutation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.codeBuildDefaults = software.amazon.jsii.Kernel.get(this, "codeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.fallbackArtifact = software.amazon.jsii.Kernel.get(this, "fallbackArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String actionName, final software.amazon.awscdk.pipelines.ArtifactMap artifacts, final software.amazon.awscdk.pipelines.CodePipeline pipeline, final java.lang.Number runOrder, final software.constructs.Construct scope, final java.lang.Boolean beforeSelfMutation, final software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults, final software.amazon.awscdk.services.codepipeline.Artifact fallbackArtifact) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionName = java.util.Objects.requireNonNull(actionName, "actionName is required");
            this.artifacts = java.util.Objects.requireNonNull(artifacts, "artifacts is required");
            this.pipeline = java.util.Objects.requireNonNull(pipeline, "pipeline is required");
            this.runOrder = java.util.Objects.requireNonNull(runOrder, "runOrder is required");
            this.scope = java.util.Objects.requireNonNull(scope, "scope is required");
            this.beforeSelfMutation = beforeSelfMutation;
            this.codeBuildDefaults = codeBuildDefaults;
            this.fallbackArtifact = fallbackArtifact;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final software.amazon.awscdk.pipelines.ArtifactMap getArtifacts() {
            return this.artifacts;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodePipeline getPipeline() {
            return this.pipeline;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final software.constructs.Construct getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.Boolean getBeforeSelfMutation() {
            return this.beforeSelfMutation;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getCodeBuildDefaults() {
            return this.codeBuildDefaults;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getFallbackArtifact() {
            return this.fallbackArtifact;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionName", om.valueToTree(this.getActionName()));
            data.set("artifacts", om.valueToTree(this.getArtifacts()));
            data.set("pipeline", om.valueToTree(this.getPipeline()));
            data.set("runOrder", om.valueToTree(this.getRunOrder()));
            data.set("scope", om.valueToTree(this.getScope()));
            if (this.getBeforeSelfMutation() != null) {
                data.set("beforeSelfMutation", om.valueToTree(this.getBeforeSelfMutation()));
            }
            if (this.getCodeBuildDefaults() != null) {
                data.set("codeBuildDefaults", om.valueToTree(this.getCodeBuildDefaults()));
            }
            if (this.getFallbackArtifact() != null) {
                data.set("fallbackArtifact", om.valueToTree(this.getFallbackArtifact()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.ProduceActionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProduceActionOptions.Jsii$Proxy that = (ProduceActionOptions.Jsii$Proxy) o;

            if (!actionName.equals(that.actionName)) return false;
            if (!artifacts.equals(that.artifacts)) return false;
            if (!pipeline.equals(that.pipeline)) return false;
            if (!runOrder.equals(that.runOrder)) return false;
            if (!scope.equals(that.scope)) return false;
            if (this.beforeSelfMutation != null ? !this.beforeSelfMutation.equals(that.beforeSelfMutation) : that.beforeSelfMutation != null) return false;
            if (this.codeBuildDefaults != null ? !this.codeBuildDefaults.equals(that.codeBuildDefaults) : that.codeBuildDefaults != null) return false;
            return this.fallbackArtifact != null ? this.fallbackArtifact.equals(that.fallbackArtifact) : that.fallbackArtifact == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionName.hashCode();
            result = 31 * result + (this.artifacts.hashCode());
            result = 31 * result + (this.pipeline.hashCode());
            result = 31 * result + (this.runOrder.hashCode());
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.beforeSelfMutation != null ? this.beforeSelfMutation.hashCode() : 0);
            result = 31 * result + (this.codeBuildDefaults != null ? this.codeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.fallbackArtifact != null ? this.fallbackArtifact.hashCode() : 0);
            return result;
        }
    }
}
