package software.amazon.awscdk.pipelines;

/**
 * (experimental) Action to publish an asset in the pipeline.
 * <p>
 * Creates a CodeBuild project which will use the CDK CLI
 * to prepare and publish the asset.
 * <p>
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline when you add stacks that use assets.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.808Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.PublishAssetsAction")
public class PublishAssetsAction extends software.constructs.Construct implements software.amazon.awscdk.services.codepipeline.IAction {

    protected PublishAssetsAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublishAssetsAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PublishAssetsAction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.PublishAssetsActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Add a single publishing command.
     * <p>
     * Manifest path should be relative to the root Cloud Assembly.
     * <p>
     * @param relativeManifestPath This parameter is required.
     * @param assetSelector This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPublishCommand(final @org.jetbrains.annotations.NotNull java.lang.String relativeManifestPath, final @org.jetbrains.annotations.NotNull java.lang.String assetSelector) {
        software.amazon.jsii.Kernel.call(this, "addPublishCommand", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(relativeManifestPath, "relativeManifestPath is required"), java.util.Objects.requireNonNull(assetSelector, "assetSelector is required") });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param name This parameter is required.
     * @param target
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleProps options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target, options });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param name This parameter is required.
     * @param target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target });
    }

    /**
     * (experimental) Exists to implement IAction.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Exists to implement IAction.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionProperties getActionProperties() {
        return software.amazon.jsii.Kernel.get(this, "actionProperties", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionProperties.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.pipelines.PublishAssetsAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.PublishAssetsAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.pipelines.PublishAssetsActionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.pipelines.PublishAssetsActionProps.Builder();
        }

        /**
         * (experimental) Name of publishing action.
         * <p>
         * @return {@code this}
         * @param actionName Name of publishing action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * (experimental) AssetType we're publishing.
         * <p>
         * @return {@code this}
         * @param assetType AssetType we're publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetType(final software.amazon.awscdk.pipelines.AssetType assetType) {
            this.props.assetType(assetType);
            return this;
        }

        /**
         * (experimental) The CodePipeline artifact that holds the Cloud Assembly.
         * <p>
         * @return {@code this}
         * @param cloudAssemblyInput The CodePipeline artifact that holds the Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudAssemblyInput(final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyInput) {
            this.props.cloudAssemblyInput(cloudAssemblyInput);
            return this;
        }

        /**
         * (experimental) Custom BuildSpec that is merged with generated one.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param buildSpec Custom BuildSpec that is merged with generated one. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        /**
         * (experimental) Version of CDK CLI to 'npm install'.
         * <p>
         * Default: - Latest version
         * <p>
         * @return {@code this}
         * @param cdkCliVersion Version of CDK CLI to 'npm install'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkCliVersion(final java.lang.String cdkCliVersion) {
            this.props.cdkCliVersion(cdkCliVersion);
            return this;
        }

        /**
         * (experimental) Use a file buildspec written to the cloud assembly instead of an inline buildspec.
         * <p>
         * This prevents size limitation errors as inline specs have a max length of 25600 characters
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param createBuildspecFile Use a file buildspec written to the cloud assembly instead of an inline buildspec. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createBuildspecFile(final java.lang.Boolean createBuildspecFile) {
            this.props.createBuildspecFile(createBuildspecFile);
            return this;
        }

        /**
         * (experimental) Any Dependable construct that the CodeBuild project needs to take a dependency on.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param dependable Any Dependable construct that the CodeBuild project needs to take a dependency on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependable(final software.constructs.IDependable dependable) {
            this.props.dependable(dependable);
            return this;
        }

        /**
         * (experimental) Additional commands to run before installing cdk-assert Use this to setup proxies or npm mirrors.
         * <p>
         * Default: -
         * <p>
         * @return {@code this}
         * @param preInstallCommands Additional commands to run before installing cdk-assert Use this to setup proxies or npm mirrors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preInstallCommands(final java.util.List<java.lang.String> preInstallCommands) {
            this.props.preInstallCommands(preInstallCommands);
            return this;
        }

        /**
         * (experimental) Name of the CodeBuild project.
         * <p>
         * Default: - Automatically generated
         * <p>
         * @return {@code this}
         * @param projectName Name of the CodeBuild project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projectName(final java.lang.String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        /**
         * (experimental) Role to use for CodePipeline and CodeBuild to build and publish the assets.
         * <p>
         * Default: - Automatically generated
         * <p>
         * @return {@code this}
         * @param role Role to use for CodePipeline and CodeBuild to build and publish the assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) Which subnets to use.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - All private subnets.
         * <p>
         * @return {@code this}
         * @param subnetSelection Which subnets to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * (experimental) The VPC where to execute the PublishAssetsAction.
         * <p>
         * Default: - No VPC
         * <p>
         * @return {@code this}
         * @param vpc The VPC where to execute the PublishAssetsAction. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.pipelines.PublishAssetsAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.pipelines.PublishAssetsAction build() {
            return new software.amazon.awscdk.pipelines.PublishAssetsAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
