package software.amazon.awscdk.pipelines;

/**
 * (experimental) Props for a PublishAssetsAction.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.808Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.PublishAssetsActionProps")
@software.amazon.jsii.Jsii.Proxy(PublishAssetsActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PublishAssetsActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Name of publishing action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getActionName();

    /**
     * (experimental) AssetType we're publishing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.AssetType getAssetType();

    /**
     * (experimental) The CodePipeline artifact that holds the Cloud Assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyInput();

    /**
     * (experimental) Custom BuildSpec that is merged with generated one.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
        return null;
    }

    /**
     * (experimental) Version of CDK CLI to 'npm install'.
     * <p>
     * Default: - Latest version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCdkCliVersion() {
        return null;
    }

    /**
     * (experimental) Use a file buildspec written to the cloud assembly instead of an inline buildspec.
     * <p>
     * This prevents size limitation errors as inline specs have a max length of 25600 characters
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCreateBuildspecFile() {
        return null;
    }

    /**
     * (experimental) Any Dependable construct that the CodeBuild project needs to take a dependency on.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.constructs.IDependable getDependable() {
        return null;
    }

    /**
     * (experimental) Additional commands to run before installing cdk-assert Use this to setup proxies or npm mirrors.
     * <p>
     * Default: -
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreInstallCommands() {
        return null;
    }

    /**
     * (experimental) Name of the CodeBuild project.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return null;
    }

    /**
     * (experimental) Role to use for CodePipeline and CodeBuild to build and publish the assets.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) Which subnets to use.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - All private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * (experimental) The VPC where to execute the PublishAssetsAction.
     * <p>
     * Default: - No VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PublishAssetsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublishAssetsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PublishAssetsActionProps> {
        private java.lang.String actionName;
        private software.amazon.awscdk.pipelines.AssetType assetType;
        private software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyInput;
        private software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private java.lang.String cdkCliVersion;
        private java.lang.Boolean createBuildspecFile;
        private software.constructs.IDependable dependable;
        private java.util.List<java.lang.String> preInstallCommands;
        private java.lang.String projectName;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link PublishAssetsActionProps#getActionName}
         * @param actionName Name of publishing action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getAssetType}
         * @param assetType AssetType we're publishing. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetType(software.amazon.awscdk.pipelines.AssetType assetType) {
            this.assetType = assetType;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getCloudAssemblyInput}
         * @param cloudAssemblyInput The CodePipeline artifact that holds the Cloud Assembly. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudAssemblyInput(software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyInput) {
            this.cloudAssemblyInput = cloudAssemblyInput;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getBuildSpec}
         * @param buildSpec Custom BuildSpec that is merged with generated one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getCdkCliVersion}
         * @param cdkCliVersion Version of CDK CLI to 'npm install'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkCliVersion(java.lang.String cdkCliVersion) {
            this.cdkCliVersion = cdkCliVersion;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getCreateBuildspecFile}
         * @param createBuildspecFile Use a file buildspec written to the cloud assembly instead of an inline buildspec.
         *                            This prevents size limitation errors as inline specs have a max length of 25600 characters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createBuildspecFile(java.lang.Boolean createBuildspecFile) {
            this.createBuildspecFile = createBuildspecFile;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getDependable}
         * @param dependable Any Dependable construct that the CodeBuild project needs to take a dependency on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependable(software.constructs.IDependable dependable) {
            this.dependable = dependable;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getPreInstallCommands}
         * @param preInstallCommands Additional commands to run before installing cdk-assert Use this to setup proxies or npm mirrors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preInstallCommands(java.util.List<java.lang.String> preInstallCommands) {
            this.preInstallCommands = preInstallCommands;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getProjectName}
         * @param projectName Name of the CodeBuild project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getRole}
         * @param role Role to use for CodePipeline and CodeBuild to build and publish the assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getSubnetSelection}
         * @param subnetSelection Which subnets to use.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link PublishAssetsActionProps#getVpc}
         * @param vpc The VPC where to execute the PublishAssetsAction.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublishAssetsActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PublishAssetsActionProps build() {
            return new Jsii$Proxy(actionName, assetType, cloudAssemblyInput, buildSpec, cdkCliVersion, createBuildspecFile, dependable, preInstallCommands, projectName, role, subnetSelection, vpc);
        }
    }

    /**
     * An implementation for {@link PublishAssetsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublishAssetsActionProps {
        private final java.lang.String actionName;
        private final software.amazon.awscdk.pipelines.AssetType assetType;
        private final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyInput;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final java.lang.String cdkCliVersion;
        private final java.lang.Boolean createBuildspecFile;
        private final software.constructs.IDependable dependable;
        private final java.util.List<java.lang.String> preInstallCommands;
        private final java.lang.String projectName;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetType = software.amazon.jsii.Kernel.get(this, "assetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.AssetType.class));
            this.cloudAssemblyInput = software.amazon.jsii.Kernel.get(this, "cloudAssemblyInput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.cdkCliVersion = software.amazon.jsii.Kernel.get(this, "cdkCliVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.createBuildspecFile = software.amazon.jsii.Kernel.get(this, "createBuildspecFile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dependable = software.amazon.jsii.Kernel.get(this, "dependable", software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class));
            this.preInstallCommands = software.amazon.jsii.Kernel.get(this, "preInstallCommands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String actionName, final software.amazon.awscdk.pipelines.AssetType assetType, final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyInput, final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec, final java.lang.String cdkCliVersion, final java.lang.Boolean createBuildspecFile, final software.constructs.IDependable dependable, final java.util.List<java.lang.String> preInstallCommands, final java.lang.String projectName, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionName = java.util.Objects.requireNonNull(actionName, "actionName is required");
            this.assetType = java.util.Objects.requireNonNull(assetType, "assetType is required");
            this.cloudAssemblyInput = java.util.Objects.requireNonNull(cloudAssemblyInput, "cloudAssemblyInput is required");
            this.buildSpec = buildSpec;
            this.cdkCliVersion = cdkCliVersion;
            this.createBuildspecFile = createBuildspecFile;
            this.dependable = dependable;
            this.preInstallCommands = preInstallCommands;
            this.projectName = projectName;
            this.role = role;
            this.subnetSelection = subnetSelection;
            this.vpc = vpc;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final software.amazon.awscdk.pipelines.AssetType getAssetType() {
            return this.assetType;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyInput() {
            return this.cloudAssemblyInput;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final java.lang.String getCdkCliVersion() {
            return this.cdkCliVersion;
        }

        @Override
        public final java.lang.Boolean getCreateBuildspecFile() {
            return this.createBuildspecFile;
        }

        @Override
        public final software.constructs.IDependable getDependable() {
            return this.dependable;
        }

        @Override
        public final java.util.List<java.lang.String> getPreInstallCommands() {
            return this.preInstallCommands;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionName", om.valueToTree(this.getActionName()));
            data.set("assetType", om.valueToTree(this.getAssetType()));
            data.set("cloudAssemblyInput", om.valueToTree(this.getCloudAssemblyInput()));
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getCdkCliVersion() != null) {
                data.set("cdkCliVersion", om.valueToTree(this.getCdkCliVersion()));
            }
            if (this.getCreateBuildspecFile() != null) {
                data.set("createBuildspecFile", om.valueToTree(this.getCreateBuildspecFile()));
            }
            if (this.getDependable() != null) {
                data.set("dependable", om.valueToTree(this.getDependable()));
            }
            if (this.getPreInstallCommands() != null) {
                data.set("preInstallCommands", om.valueToTree(this.getPreInstallCommands()));
            }
            if (this.getProjectName() != null) {
                data.set("projectName", om.valueToTree(this.getProjectName()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.PublishAssetsActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublishAssetsActionProps.Jsii$Proxy that = (PublishAssetsActionProps.Jsii$Proxy) o;

            if (!actionName.equals(that.actionName)) return false;
            if (!assetType.equals(that.assetType)) return false;
            if (!cloudAssemblyInput.equals(that.cloudAssemblyInput)) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.cdkCliVersion != null ? !this.cdkCliVersion.equals(that.cdkCliVersion) : that.cdkCliVersion != null) return false;
            if (this.createBuildspecFile != null ? !this.createBuildspecFile.equals(that.createBuildspecFile) : that.createBuildspecFile != null) return false;
            if (this.dependable != null ? !this.dependable.equals(that.dependable) : that.dependable != null) return false;
            if (this.preInstallCommands != null ? !this.preInstallCommands.equals(that.preInstallCommands) : that.preInstallCommands != null) return false;
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionName.hashCode();
            result = 31 * result + (this.assetType.hashCode());
            result = 31 * result + (this.cloudAssemblyInput.hashCode());
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.cdkCliVersion != null ? this.cdkCliVersion.hashCode() : 0);
            result = 31 * result + (this.createBuildspecFile != null ? this.createBuildspecFile.hashCode() : 0);
            result = 31 * result + (this.dependable != null ? this.dependable.hashCode() : 0);
            result = 31 * result + (this.preInstallCommands != null ? this.preInstallCommands.hashCode() : 0);
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
