package software.amazon.awscdk.pipelines;

/**
 * (experimental) Options for S3 sources.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.809Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.S3SourceOptions")
@software.amazon.jsii.Jsii.Proxy(S3SourceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface S3SourceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The action name used for this source in the CodePipeline.
     * <p>
     * Default: - The bucket name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getActionName() {
        return null;
    }

    /**
     * (experimental) How should CodePipeline detect source changes for this Action.
     * <p>
     * Note that if this is S3Trigger.EVENTS, you need to make sure to include the source Bucket in a CloudTrail Trail,
     * as otherwise the CloudWatch Events will not be emitted.
     * <p>
     * Default: S3Trigger.POLL
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.S3Trigger getTrigger() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3SourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3SourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<S3SourceOptions> {
        private java.lang.String actionName;
        private software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger;

        /**
         * Sets the value of {@link S3SourceOptions#getActionName}
         * @param actionName The action name used for this source in the CodePipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link S3SourceOptions#getTrigger}
         * @param trigger How should CodePipeline detect source changes for this Action.
         *                Note that if this is S3Trigger.EVENTS, you need to make sure to include the source Bucket in a CloudTrail Trail,
         *                as otherwise the CloudWatch Events will not be emitted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trigger(software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3SourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public S3SourceOptions build() {
            return new Jsii$Proxy(actionName, trigger);
        }
    }

    /**
     * An implementation for {@link S3SourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourceOptions {
        private final java.lang.String actionName;
        private final software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.S3Trigger.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String actionName, final software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionName = actionName;
            this.trigger = trigger;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.S3Trigger getTrigger() {
            return this.trigger;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActionName() != null) {
                data.set("actionName", om.valueToTree(this.getActionName()));
            }
            if (this.getTrigger() != null) {
                data.set("trigger", om.valueToTree(this.getTrigger()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.S3SourceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3SourceOptions.Jsii$Proxy that = (S3SourceOptions.Jsii$Proxy) o;

            if (this.actionName != null ? !this.actionName.equals(that.actionName) : that.actionName != null) return false;
            return this.trigger != null ? this.trigger.equals(that.trigger) : that.trigger == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionName != null ? this.actionName.hashCode() : 0;
            result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
            return result;
        }
    }
}
