package software.amazon.awscdk.pipelines;

/**
 * (experimental) Configuration options for a SimpleSynth.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.SimpleSynthOptions")
@software.amazon.jsii.Jsii.Proxy(SimpleSynthOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SimpleSynthOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The artifact where the CloudAssembly should be emitted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyArtifact();

    /**
     * (experimental) The source artifact of the CodePipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getSourceArtifact();

    /**
     * (experimental) Name of the build action.
     * <p>
     * Default: 'Synth'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getActionName() {
        return null;
    }

    /**
     * (experimental) Produce additional output artifacts after the build based on the given directories.
     * <p>
     * Can be used to produce additional artifacts during the build step,
     * separate from the cloud assembly, which can be used further on in the
     * pipeline.
     * <p>
     * Directories are evaluated with respect to <code>subdirectory</code>.
     * <p>
     * Default: - No additional artifacts generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.AdditionalArtifact> getAdditionalArtifacts() {
        return null;
    }

    /**
     * (experimental) custom BuildSpec that is merged with the generated one.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
        return null;
    }

    /**
     * (experimental) Environment variables to copy over from parent env.
     * <p>
     * These are environment variables that are being used by the build.
     * <p>
     * Default: - No environment variables copied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCopyEnvironmentVariables() {
        return null;
    }

    /**
     * (experimental) Build environment to use for CodeBuild job.
     * <p>
     * Default: BuildEnvironment.LinuxBuildImage.STANDARD_5_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildEnvironment getEnvironment() {
        return null;
    }

    /**
     * (experimental) Environment variables to send into build.
     * <p>
     * NOTE: You may run into the 1000-character limit for the Action configuration if you have a large
     * number of variables or if their names or values are very long.
     * If you do, pass them to the underlying CodeBuild project directly in <code>environment</code> instead.
     * However, you will not be able to use CodePipeline Variables in this case.
     * <p>
     * Default: - No additional environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
        return null;
    }

    /**
     * (experimental) Name of the CodeBuild project.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return null;
    }

    /**
     * (experimental) Policy statements to add to role used during the synth.
     * <p>
     * Can be used to add acces to a CodeArtifact repository etc.
     * <p>
     * Default: - No policy statements added to CodeBuild Project Role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicyStatements() {
        return null;
    }

    /**
     * (experimental) Directory inside the source where package.json and cdk.json are located.
     * <p>
     * Default: - Repository root
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * (experimental) Which subnets to use.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - All private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * (experimental) The VPC where to execute the SimpleSynth.
     * <p>
     * Default: - No VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SimpleSynthOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SimpleSynthOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SimpleSynthOptions> {
        private software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact;
        private software.amazon.awscdk.services.codepipeline.Artifact sourceArtifact;
        private java.lang.String actionName;
        private java.util.List<software.amazon.awscdk.pipelines.AdditionalArtifact> additionalArtifacts;
        private software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private java.util.List<java.lang.String> copyEnvironmentVariables;
        private software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private java.lang.String projectName;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements;
        private java.lang.String subdirectory;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link SimpleSynthOptions#getCloudAssemblyArtifact}
         * @param cloudAssemblyArtifact The artifact where the CloudAssembly should be emitted. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudAssemblyArtifact(software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact) {
            this.cloudAssemblyArtifact = cloudAssemblyArtifact;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getSourceArtifact}
         * @param sourceArtifact The source artifact of the CodePipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceArtifact(software.amazon.awscdk.services.codepipeline.Artifact sourceArtifact) {
            this.sourceArtifact = sourceArtifact;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getActionName}
         * @param actionName Name of the build action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getAdditionalArtifacts}
         * @param additionalArtifacts Produce additional output artifacts after the build based on the given directories.
         *                            Can be used to produce additional artifacts during the build step,
         *                            separate from the cloud assembly, which can be used further on in the
         *                            pipeline.
         *                            <p>
         *                            Directories are evaluated with respect to <code>subdirectory</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder additionalArtifacts(java.util.List<? extends software.amazon.awscdk.pipelines.AdditionalArtifact> additionalArtifacts) {
            this.additionalArtifacts = (java.util.List<software.amazon.awscdk.pipelines.AdditionalArtifact>)additionalArtifacts;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getBuildSpec}
         * @param buildSpec custom BuildSpec that is merged with the generated one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getCopyEnvironmentVariables}
         * @param copyEnvironmentVariables Environment variables to copy over from parent env.
         *                                 These are environment variables that are being used by the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder copyEnvironmentVariables(java.util.List<java.lang.String> copyEnvironmentVariables) {
            this.copyEnvironmentVariables = copyEnvironmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getEnvironment}
         * @param environment Build environment to use for CodeBuild job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(software.amazon.awscdk.services.codebuild.BuildEnvironment environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getEnvironmentVariables}
         * @param environmentVariables Environment variables to send into build.
         *                             NOTE: You may run into the 1000-character limit for the Action configuration if you have a large
         *                             number of variables or if their names or values are very long.
         *                             If you do, pass them to the underlying CodeBuild project directly in <code>environment</code> instead.
         *                             However, you will not be able to use CodePipeline Variables in this case.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder environmentVariables(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getProjectName}
         * @param projectName Name of the CodeBuild project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getRolePolicyStatements}
         * @param rolePolicyStatements Policy statements to add to role used during the synth.
         *                             Can be used to add acces to a CodeArtifact repository etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder rolePolicyStatements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements) {
            this.rolePolicyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)rolePolicyStatements;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getSubdirectory}
         * @param subdirectory Directory inside the source where package.json and cdk.json are located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getSubnetSelection}
         * @param subnetSelection Which subnets to use.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link SimpleSynthOptions#getVpc}
         * @param vpc The VPC where to execute the SimpleSynth.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SimpleSynthOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SimpleSynthOptions build() {
            return new Jsii$Proxy(cloudAssemblyArtifact, sourceArtifact, actionName, additionalArtifacts, buildSpec, copyEnvironmentVariables, environment, environmentVariables, projectName, rolePolicyStatements, subdirectory, subnetSelection, vpc);
        }
    }

    /**
     * An implementation for {@link SimpleSynthOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimpleSynthOptions {
        private final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact;
        private final software.amazon.awscdk.services.codepipeline.Artifact sourceArtifact;
        private final java.lang.String actionName;
        private final java.util.List<software.amazon.awscdk.pipelines.AdditionalArtifact> additionalArtifacts;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final java.util.List<java.lang.String> copyEnvironmentVariables;
        private final software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private final java.lang.String projectName;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements;
        private final java.lang.String subdirectory;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudAssemblyArtifact = software.amazon.jsii.Kernel.get(this, "cloudAssemblyArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.sourceArtifact = software.amazon.jsii.Kernel.get(this, "sourceArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalArtifacts = software.amazon.jsii.Kernel.get(this, "additionalArtifacts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.AdditionalArtifact.class)));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.copyEnvironmentVariables = software.amazon.jsii.Kernel.get(this, "copyEnvironmentVariables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironment.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable.class)));
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rolePolicyStatements = software.amazon.jsii.Kernel.get(this, "rolePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.codepipeline.Artifact cloudAssemblyArtifact, final software.amazon.awscdk.services.codepipeline.Artifact sourceArtifact, final java.lang.String actionName, final java.util.List<? extends software.amazon.awscdk.pipelines.AdditionalArtifact> additionalArtifacts, final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec, final java.util.List<java.lang.String> copyEnvironmentVariables, final software.amazon.awscdk.services.codebuild.BuildEnvironment environment, final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables, final java.lang.String projectName, final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements, final java.lang.String subdirectory, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudAssemblyArtifact = java.util.Objects.requireNonNull(cloudAssemblyArtifact, "cloudAssemblyArtifact is required");
            this.sourceArtifact = java.util.Objects.requireNonNull(sourceArtifact, "sourceArtifact is required");
            this.actionName = actionName;
            this.additionalArtifacts = (java.util.List<software.amazon.awscdk.pipelines.AdditionalArtifact>)additionalArtifacts;
            this.buildSpec = buildSpec;
            this.copyEnvironmentVariables = copyEnvironmentVariables;
            this.environment = environment;
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)environmentVariables;
            this.projectName = projectName;
            this.rolePolicyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)rolePolicyStatements;
            this.subdirectory = subdirectory;
            this.subnetSelection = subnetSelection;
            this.vpc = vpc;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getCloudAssemblyArtifact() {
            return this.cloudAssemblyArtifact;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getSourceArtifact() {
            return this.sourceArtifact;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.AdditionalArtifact> getAdditionalArtifacts() {
            return this.additionalArtifacts;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final java.util.List<java.lang.String> getCopyEnvironmentVariables() {
            return this.copyEnvironmentVariables;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicyStatements() {
            return this.rolePolicyStatements;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cloudAssemblyArtifact", om.valueToTree(this.getCloudAssemblyArtifact()));
            data.set("sourceArtifact", om.valueToTree(this.getSourceArtifact()));
            if (this.getActionName() != null) {
                data.set("actionName", om.valueToTree(this.getActionName()));
            }
            if (this.getAdditionalArtifacts() != null) {
                data.set("additionalArtifacts", om.valueToTree(this.getAdditionalArtifacts()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getCopyEnvironmentVariables() != null) {
                data.set("copyEnvironmentVariables", om.valueToTree(this.getCopyEnvironmentVariables()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getProjectName() != null) {
                data.set("projectName", om.valueToTree(this.getProjectName()));
            }
            if (this.getRolePolicyStatements() != null) {
                data.set("rolePolicyStatements", om.valueToTree(this.getRolePolicyStatements()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.SimpleSynthOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SimpleSynthOptions.Jsii$Proxy that = (SimpleSynthOptions.Jsii$Proxy) o;

            if (!cloudAssemblyArtifact.equals(that.cloudAssemblyArtifact)) return false;
            if (!sourceArtifact.equals(that.sourceArtifact)) return false;
            if (this.actionName != null ? !this.actionName.equals(that.actionName) : that.actionName != null) return false;
            if (this.additionalArtifacts != null ? !this.additionalArtifacts.equals(that.additionalArtifacts) : that.additionalArtifacts != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.copyEnvironmentVariables != null ? !this.copyEnvironmentVariables.equals(that.copyEnvironmentVariables) : that.copyEnvironmentVariables != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) return false;
            if (this.rolePolicyStatements != null ? !this.rolePolicyStatements.equals(that.rolePolicyStatements) : that.rolePolicyStatements != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudAssemblyArtifact.hashCode();
            result = 31 * result + (this.sourceArtifact.hashCode());
            result = 31 * result + (this.actionName != null ? this.actionName.hashCode() : 0);
            result = 31 * result + (this.additionalArtifacts != null ? this.additionalArtifacts.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.copyEnvironmentVariables != null ? this.copyEnvironmentVariables.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.rolePolicyStatements != null ? this.rolePolicyStatements.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
