package software.amazon.awscdk.pipelines;

/**
 * (experimental) An asset used by a Stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.814Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.StackAsset")
@software.amazon.jsii.Jsii.Proxy(StackAsset.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StackAsset extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Asset identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetId();

    /**
     * (experimental) Absolute asset manifest path.
     * <p>
     * This needs to be made relative at a later point in time, but when this
     * information is parsed we don't know about the root cloud assembly yet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetManifestPath();

    /**
     * (experimental) Asset selector to pass to `cdk-assets`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetSelector();

    /**
     * (experimental) Type of asset to publish.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.AssetType getAssetType();

    /**
     * (experimental) Does this asset represent the CloudFormation template for the stack.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getIsTemplate();

    /**
     * (experimental) Role ARN to assume to publish.
     * <p>
     * Default: - No need to assume any role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetPublishingRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StackAsset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StackAsset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<StackAsset> {
        private java.lang.String assetId;
        private java.lang.String assetManifestPath;
        private java.lang.String assetSelector;
        private software.amazon.awscdk.pipelines.AssetType assetType;
        private java.lang.Boolean isTemplate;
        private java.lang.String assetPublishingRoleArn;

        /**
         * Sets the value of {@link StackAsset#getAssetId}
         * @param assetId Asset identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetId(java.lang.String assetId) {
            this.assetId = assetId;
            return this;
        }

        /**
         * Sets the value of {@link StackAsset#getAssetManifestPath}
         * @param assetManifestPath Absolute asset manifest path. This parameter is required.
         *                          This needs to be made relative at a later point in time, but when this
         *                          information is parsed we don't know about the root cloud assembly yet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetManifestPath(java.lang.String assetManifestPath) {
            this.assetManifestPath = assetManifestPath;
            return this;
        }

        /**
         * Sets the value of {@link StackAsset#getAssetSelector}
         * @param assetSelector Asset selector to pass to `cdk-assets`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetSelector(java.lang.String assetSelector) {
            this.assetSelector = assetSelector;
            return this;
        }

        /**
         * Sets the value of {@link StackAsset#getAssetType}
         * @param assetType Type of asset to publish. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetType(software.amazon.awscdk.pipelines.AssetType assetType) {
            this.assetType = assetType;
            return this;
        }

        /**
         * Sets the value of {@link StackAsset#getIsTemplate}
         * @param isTemplate Does this asset represent the CloudFormation template for the stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder isTemplate(java.lang.Boolean isTemplate) {
            this.isTemplate = isTemplate;
            return this;
        }

        /**
         * Sets the value of {@link StackAsset#getAssetPublishingRoleArn}
         * @param assetPublishingRoleArn Role ARN to assume to publish.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetPublishingRoleArn(java.lang.String assetPublishingRoleArn) {
            this.assetPublishingRoleArn = assetPublishingRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StackAsset}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public StackAsset build() {
            return new Jsii$Proxy(assetId, assetManifestPath, assetSelector, assetType, isTemplate, assetPublishingRoleArn);
        }
    }

    /**
     * An implementation for {@link StackAsset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackAsset {
        private final java.lang.String assetId;
        private final java.lang.String assetManifestPath;
        private final java.lang.String assetSelector;
        private final software.amazon.awscdk.pipelines.AssetType assetType;
        private final java.lang.Boolean isTemplate;
        private final java.lang.String assetPublishingRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetId = software.amazon.jsii.Kernel.get(this, "assetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetManifestPath = software.amazon.jsii.Kernel.get(this, "assetManifestPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetSelector = software.amazon.jsii.Kernel.get(this, "assetSelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetType = software.amazon.jsii.Kernel.get(this, "assetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.AssetType.class));
            this.isTemplate = software.amazon.jsii.Kernel.get(this, "isTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.assetPublishingRoleArn = software.amazon.jsii.Kernel.get(this, "assetPublishingRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String assetId, final java.lang.String assetManifestPath, final java.lang.String assetSelector, final software.amazon.awscdk.pipelines.AssetType assetType, final java.lang.Boolean isTemplate, final java.lang.String assetPublishingRoleArn) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetId = java.util.Objects.requireNonNull(assetId, "assetId is required");
            this.assetManifestPath = java.util.Objects.requireNonNull(assetManifestPath, "assetManifestPath is required");
            this.assetSelector = java.util.Objects.requireNonNull(assetSelector, "assetSelector is required");
            this.assetType = java.util.Objects.requireNonNull(assetType, "assetType is required");
            this.isTemplate = java.util.Objects.requireNonNull(isTemplate, "isTemplate is required");
            this.assetPublishingRoleArn = assetPublishingRoleArn;
        }

        @Override
        public final java.lang.String getAssetId() {
            return this.assetId;
        }

        @Override
        public final java.lang.String getAssetManifestPath() {
            return this.assetManifestPath;
        }

        @Override
        public final java.lang.String getAssetSelector() {
            return this.assetSelector;
        }

        @Override
        public final software.amazon.awscdk.pipelines.AssetType getAssetType() {
            return this.assetType;
        }

        @Override
        public final java.lang.Boolean getIsTemplate() {
            return this.isTemplate;
        }

        @Override
        public final java.lang.String getAssetPublishingRoleArn() {
            return this.assetPublishingRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assetId", om.valueToTree(this.getAssetId()));
            data.set("assetManifestPath", om.valueToTree(this.getAssetManifestPath()));
            data.set("assetSelector", om.valueToTree(this.getAssetSelector()));
            data.set("assetType", om.valueToTree(this.getAssetType()));
            data.set("isTemplate", om.valueToTree(this.getIsTemplate()));
            if (this.getAssetPublishingRoleArn() != null) {
                data.set("assetPublishingRoleArn", om.valueToTree(this.getAssetPublishingRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.StackAsset"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StackAsset.Jsii$Proxy that = (StackAsset.Jsii$Proxy) o;

            if (!assetId.equals(that.assetId)) return false;
            if (!assetManifestPath.equals(that.assetManifestPath)) return false;
            if (!assetSelector.equals(that.assetSelector)) return false;
            if (!assetType.equals(that.assetType)) return false;
            if (!isTemplate.equals(that.isTemplate)) return false;
            return this.assetPublishingRoleArn != null ? this.assetPublishingRoleArn.equals(that.assetPublishingRoleArn) : that.assetPublishingRoleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetId.hashCode();
            result = 31 * result + (this.assetManifestPath.hashCode());
            result = 31 * result + (this.assetSelector.hashCode());
            result = 31 * result + (this.assetType.hashCode());
            result = 31 * result + (this.isTemplate.hashCode());
            result = 31 * result + (this.assetPublishingRoleArn != null ? this.assetPublishingRoleArn.hashCode() : 0);
            return result;
        }
    }
}
