package software.amazon.awscdk.pipelines;

/**
 * (experimental) Deployment of a single `Stage`.
 * <p>
 * A <code>Stage</code> consists of one or more <code>Stacks</code>, which will be
 * deployed in dependency order.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:57.446Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.StageDeployment")
public class StageDeployment extends software.amazon.jsii.JsiiObject {

    protected StageDeployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StageDeployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Create a new `StageDeployment` from a `Stage`.
     * <p>
     * Synthesizes the target stage, and deployes the stacks found inside
     * in dependency order.
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment fromStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.StageDeploymentProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.StageDeployment.class, "fromStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * (experimental) Create a new `StageDeployment` from a `Stage`.
     * <p>
     * Synthesizes the target stage, and deployes the stacks found inside
     * in dependency order.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment fromStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.StageDeployment.class, "fromStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * (experimental) Add an additional step to run after all of the stacks in this stage.
     * <p>
     * @param steps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPost(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step... steps) {
        software.amazon.jsii.Kernel.call(this, "addPost", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * (experimental) Add an additional step to run before any of the stacks in this stage.
     * <p>
     * @param steps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPre(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step... steps) {
        software.amazon.jsii.Kernel.call(this, "addPre", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * (experimental) Additional steps that are run after all of the stacks in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * (experimental) Additional steps that are run before any of the stacks in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "pre", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * (experimental) The stacks deployed in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StackDeployment> getStacks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackDeployment.class))));
    }

    /**
     * (experimental) The display name of this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
