package software.amazon.awscdk.services.apigateway;

/**
 * (experimental) This type of integration lets an API expose AWS service actions.
 * <p>
 * It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:53.922Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.AwsIntegration")
public class AwsIntegration extends software.amazon.awscdk.services.apigateway.Integration {

    protected AwsIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AwsIntegration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AwsIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     * <p>
     * @param method This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Method method) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(method, "method is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigateway.AwsIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.AwsIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.apigateway.AwsIntegrationProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.apigateway.AwsIntegrationProps.Builder();
        }

        /**
         * (experimental) The name of the integrated AWS service (e.g. `s3`).
         * <p>
         * @return {@code this}
         * @param service The name of the integrated AWS service (e.g. `s3`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder service(final java.lang.String service) {
            this.props.service(service);
            return this;
        }

        /**
         * (experimental) The AWS action to perform in the integration.
         * <p>
         * Use <code>actionParams</code> to specify key-value params for the action.
         * <p>
         * Mutually exclusive with <code>path</code>.
         * <p>
         * @return {@code this}
         * @param action The AWS action to perform in the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * (experimental) Parameters for the action.
         * <p>
         * <code>action</code> must be set, and <code>path</code> must be undefined.
         * The action params will be URL encoded.
         * <p>
         * @return {@code this}
         * @param actionParameters Parameters for the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionParameters(final java.util.Map<java.lang.String, java.lang.String> actionParameters) {
            this.props.actionParameters(actionParameters);
            return this;
        }

        /**
         * (experimental) The integration's HTTP method type.
         * <p>
         * Default: POST
         * <p>
         * @return {@code this}
         * @param integrationHttpMethod The integration's HTTP method type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationHttpMethod(final java.lang.String integrationHttpMethod) {
            this.props.integrationHttpMethod(integrationHttpMethod);
            return this;
        }

        /**
         * (experimental) Integration options, such as content handling, request/response mapping, etc.
         * <p>
         * @return {@code this}
         * @param options Integration options, such as content handling, request/response mapping, etc. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder options(final software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.props.options(options);
            return this;
        }

        /**
         * (experimental) The path to use for path-base APIs.
         * <p>
         * For example, for S3 GET, you can set path to <code>bucket/key</code>.
         * For lambda, you can set path to <code>2015-03-31/functions/${function-arn}/invocations</code>
         * <p>
         * Mutually exclusive with the <code>action</code> options.
         * <p>
         * @return {@code this}
         * @param path The path to use for path-base APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * (experimental) Use AWS_PROXY integration.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param proxy Use AWS_PROXY integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder proxy(final java.lang.Boolean proxy) {
            this.props.proxy(proxy);
            return this;
        }

        /**
         * (experimental) The region of the integrated AWS service.
         * <p>
         * Default: - same region as the stack
         * <p>
         * @return {@code this}
         * @param region The region of the integrated AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * (experimental) A designated subdomain supported by certain AWS service for fast host-name lookup.
         * <p>
         * @return {@code this}
         * @param subdomain A designated subdomain supported by certain AWS service for fast host-name lookup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subdomain(final java.lang.String subdomain) {
            this.props.subdomain(subdomain);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.AwsIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigateway.AwsIntegration build() {
            return new software.amazon.awscdk.services.apigateway.AwsIntegration(
                this.props.build()
            );
        }
    }
}
