package software.amazon.awscdk.services.apprunner;

/**
 * A CloudFormation `AWS::AppRunner::Service`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:59.699Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService")
public class CfnService extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apprunner.CfnService.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppRunner::Service`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.CfnServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceId() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::AppRunner::Service.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::AppRunner::Service.SourceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppRunner::Service.SourceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", java.util.Objects.requireNonNull(value, "sourceConfiguration is required"));
    }

    /**
     * `AWS::AppRunner::Service.SourceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", java.util.Objects.requireNonNull(value, "sourceConfiguration is required"));
    }

    /**
     * `AWS::AppRunner::Service.AutoScalingConfigurationArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::AppRunner::Service.AutoScalingConfigurationArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingConfigurationArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingConfigurationArn", value);
    }

    /**
     * `AWS::AppRunner::Service.EncryptionConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppRunner::Service.EncryptionConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.EncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionConfiguration", value);
    }

    /**
     * `AWS::AppRunner::Service.EncryptionConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionConfiguration", value);
    }

    /**
     * `AWS::AppRunner::Service.HealthCheckConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppRunner::Service.HealthCheckConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.HealthCheckConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfiguration", value);
    }

    /**
     * `AWS::AppRunner::Service.HealthCheckConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfiguration", value);
    }

    /**
     * `AWS::AppRunner::Service.InstanceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "instanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppRunner::Service.InstanceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.InstanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "instanceConfiguration", value);
    }

    /**
     * `AWS::AppRunner::Service.InstanceConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceConfiguration", value);
    }

    /**
     * `AWS::AppRunner::Service.ServiceName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::AppRunner::Service.ServiceName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceName", value);
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.AuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.AuthenticationConfigurationProperty.AccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessRoleArn() {
            return null;
        }

        /**
         * `CfnService.AuthenticationConfigurationProperty.ConnectionArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticationConfigurationProperty> {
            private java.lang.String accessRoleArn;
            private java.lang.String connectionArn;

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getAccessRoleArn}
             * @param accessRoleArn `CfnService.AuthenticationConfigurationProperty.AccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessRoleArn(java.lang.String accessRoleArn) {
                this.accessRoleArn = accessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getConnectionArn}
             * @param connectionArn `CfnService.AuthenticationConfigurationProperty.ConnectionArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionArn(java.lang.String connectionArn) {
                this.connectionArn = connectionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticationConfigurationProperty build() {
                return new Jsii$Proxy(accessRoleArn, connectionArn);
            }
        }

        /**
         * An implementation for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticationConfigurationProperty {
            private final java.lang.String accessRoleArn;
            private final java.lang.String connectionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessRoleArn = software.amazon.jsii.Kernel.get(this, "accessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String accessRoleArn, final java.lang.String connectionArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessRoleArn = accessRoleArn;
                this.connectionArn = connectionArn;
            }

            @Override
            public final java.lang.String getAccessRoleArn() {
                return this.accessRoleArn;
            }

            @Override
            public final java.lang.String getConnectionArn() {
                return this.connectionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessRoleArn() != null) {
                    data.set("accessRoleArn", om.valueToTree(this.getAccessRoleArn()));
                }
                if (this.getConnectionArn() != null) {
                    data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.AuthenticationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticationConfigurationProperty.Jsii$Proxy that = (AuthenticationConfigurationProperty.Jsii$Proxy) o;

                if (this.accessRoleArn != null ? !this.accessRoleArn.equals(that.accessRoleArn) : that.accessRoleArn != null) return false;
                return this.connectionArn != null ? this.connectionArn.equals(that.connectionArn) : that.connectionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessRoleArn != null ? this.accessRoleArn.hashCode() : 0;
                result = 31 * result + (this.connectionArn != null ? this.connectionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.CodeConfigurationProperty.ConfigurationSource`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConfigurationSource();

        /**
         * `CfnService.CodeConfigurationProperty.CodeConfigurationValues`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeConfigurationValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeConfigurationProperty> {
            private java.lang.String configurationSource;
            private java.lang.Object codeConfigurationValues;

            /**
             * Sets the value of {@link CodeConfigurationProperty#getConfigurationSource}
             * @param configurationSource `CfnService.CodeConfigurationProperty.ConfigurationSource`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationSource(java.lang.String configurationSource) {
                this.configurationSource = configurationSource;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationProperty#getCodeConfigurationValues}
             * @param codeConfigurationValues `CfnService.CodeConfigurationProperty.CodeConfigurationValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfigurationValues(software.amazon.awscdk.services.apprunner.CfnService.CodeConfigurationValuesProperty codeConfigurationValues) {
                this.codeConfigurationValues = codeConfigurationValues;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationProperty#getCodeConfigurationValues}
             * @param codeConfigurationValues `CfnService.CodeConfigurationProperty.CodeConfigurationValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfigurationValues(software.amazon.awscdk.IResolvable codeConfigurationValues) {
                this.codeConfigurationValues = codeConfigurationValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeConfigurationProperty build() {
                return new Jsii$Proxy(configurationSource, codeConfigurationValues);
            }
        }

        /**
         * An implementation for {@link CodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfigurationProperty {
            private final java.lang.String configurationSource;
            private final java.lang.Object codeConfigurationValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationSource = software.amazon.jsii.Kernel.get(this, "configurationSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codeConfigurationValues = software.amazon.jsii.Kernel.get(this, "codeConfigurationValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String configurationSource, final java.lang.Object codeConfigurationValues) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationSource = java.util.Objects.requireNonNull(configurationSource, "configurationSource is required");
                this.codeConfigurationValues = codeConfigurationValues;
            }

            @Override
            public final java.lang.String getConfigurationSource() {
                return this.configurationSource;
            }

            @Override
            public final java.lang.Object getCodeConfigurationValues() {
                return this.codeConfigurationValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("configurationSource", om.valueToTree(this.getConfigurationSource()));
                if (this.getCodeConfigurationValues() != null) {
                    data.set("codeConfigurationValues", om.valueToTree(this.getCodeConfigurationValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeConfigurationProperty.Jsii$Proxy that = (CodeConfigurationProperty.Jsii$Proxy) o;

                if (!configurationSource.equals(that.configurationSource)) return false;
                return this.codeConfigurationValues != null ? this.codeConfigurationValues.equals(that.codeConfigurationValues) : that.codeConfigurationValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationSource.hashCode();
                result = 31 * result + (this.codeConfigurationValues != null ? this.codeConfigurationValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeConfigurationValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeConfigurationValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.CodeConfigurationValuesProperty.Runtime`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuntime();

        /**
         * `CfnService.CodeConfigurationValuesProperty.BuildCommand`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBuildCommand() {
            return null;
        }

        /**
         * `CfnService.CodeConfigurationValuesProperty.Port`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * `CfnService.CodeConfigurationValuesProperty.RuntimeEnvironmentVariables`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeEnvironmentVariables() {
            return null;
        }

        /**
         * `CfnService.CodeConfigurationValuesProperty.StartCommand`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartCommand() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeConfigurationValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeConfigurationValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeConfigurationValuesProperty> {
            private java.lang.String runtime;
            private java.lang.String buildCommand;
            private java.lang.String port;
            private java.lang.Object runtimeEnvironmentVariables;
            private java.lang.String startCommand;

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntime}
             * @param runtime `CfnService.CodeConfigurationValuesProperty.Runtime`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtime(java.lang.String runtime) {
                this.runtime = runtime;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getBuildCommand}
             * @param buildCommand `CfnService.CodeConfigurationValuesProperty.BuildCommand`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildCommand(java.lang.String buildCommand) {
                this.buildCommand = buildCommand;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getPort}
             * @param port `CfnService.CodeConfigurationValuesProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables `CfnService.CodeConfigurationValuesProperty.RuntimeEnvironmentVariables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(software.amazon.awscdk.IResolvable runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables `CfnService.CodeConfigurationValuesProperty.RuntimeEnvironmentVariables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(java.util.List<? extends java.lang.Object> runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getStartCommand}
             * @param startCommand `CfnService.CodeConfigurationValuesProperty.StartCommand`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startCommand(java.lang.String startCommand) {
                this.startCommand = startCommand;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeConfigurationValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeConfigurationValuesProperty build() {
                return new Jsii$Proxy(runtime, buildCommand, port, runtimeEnvironmentVariables, startCommand);
            }
        }

        /**
         * An implementation for {@link CodeConfigurationValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfigurationValuesProperty {
            private final java.lang.String runtime;
            private final java.lang.String buildCommand;
            private final java.lang.String port;
            private final java.lang.Object runtimeEnvironmentVariables;
            private final java.lang.String startCommand;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.buildCommand = software.amazon.jsii.Kernel.get(this, "buildCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtimeEnvironmentVariables = software.amazon.jsii.Kernel.get(this, "runtimeEnvironmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startCommand = software.amazon.jsii.Kernel.get(this, "startCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String runtime, final java.lang.String buildCommand, final java.lang.String port, final java.lang.Object runtimeEnvironmentVariables, final java.lang.String startCommand) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.runtime = java.util.Objects.requireNonNull(runtime, "runtime is required");
                this.buildCommand = buildCommand;
                this.port = port;
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                this.startCommand = startCommand;
            }

            @Override
            public final java.lang.String getRuntime() {
                return this.runtime;
            }

            @Override
            public final java.lang.String getBuildCommand() {
                return this.buildCommand;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getRuntimeEnvironmentVariables() {
                return this.runtimeEnvironmentVariables;
            }

            @Override
            public final java.lang.String getStartCommand() {
                return this.startCommand;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("runtime", om.valueToTree(this.getRuntime()));
                if (this.getBuildCommand() != null) {
                    data.set("buildCommand", om.valueToTree(this.getBuildCommand()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRuntimeEnvironmentVariables() != null) {
                    data.set("runtimeEnvironmentVariables", om.valueToTree(this.getRuntimeEnvironmentVariables()));
                }
                if (this.getStartCommand() != null) {
                    data.set("startCommand", om.valueToTree(this.getStartCommand()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeConfigurationValuesProperty.Jsii$Proxy that = (CodeConfigurationValuesProperty.Jsii$Proxy) o;

                if (!runtime.equals(that.runtime)) return false;
                if (this.buildCommand != null ? !this.buildCommand.equals(that.buildCommand) : that.buildCommand != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.runtimeEnvironmentVariables != null ? !this.runtimeEnvironmentVariables.equals(that.runtimeEnvironmentVariables) : that.runtimeEnvironmentVariables != null) return false;
                return this.startCommand != null ? this.startCommand.equals(that.startCommand) : that.startCommand == null;
            }

            @Override
            public final int hashCode() {
                int result = this.runtime.hashCode();
                result = 31 * result + (this.buildCommand != null ? this.buildCommand.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.runtimeEnvironmentVariables != null ? this.runtimeEnvironmentVariables.hashCode() : 0);
                result = 31 * result + (this.startCommand != null ? this.startCommand.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.CodeRepositoryProperty.RepositoryUrl`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

        /**
         * `CfnService.CodeRepositoryProperty.SourceCodeVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceCodeVersion();

        /**
         * `CfnService.CodeRepositoryProperty.CodeConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            private java.lang.String repositoryUrl;
            private java.lang.Object sourceCodeVersion;
            private java.lang.Object codeConfiguration;

            /**
             * Sets the value of {@link CodeRepositoryProperty#getRepositoryUrl}
             * @param repositoryUrl `CfnService.CodeRepositoryProperty.RepositoryUrl`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryUrl(java.lang.String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getSourceCodeVersion}
             * @param sourceCodeVersion `CfnService.CodeRepositoryProperty.SourceCodeVersion`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceCodeVersion(software.amazon.awscdk.services.apprunner.CfnService.SourceCodeVersionProperty sourceCodeVersion) {
                this.sourceCodeVersion = sourceCodeVersion;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getSourceCodeVersion}
             * @param sourceCodeVersion `CfnService.CodeRepositoryProperty.SourceCodeVersion`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceCodeVersion(software.amazon.awscdk.IResolvable sourceCodeVersion) {
                this.sourceCodeVersion = sourceCodeVersion;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getCodeConfiguration}
             * @param codeConfiguration `CfnService.CodeRepositoryProperty.CodeConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfiguration(software.amazon.awscdk.services.apprunner.CfnService.CodeConfigurationProperty codeConfiguration) {
                this.codeConfiguration = codeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getCodeConfiguration}
             * @param codeConfiguration `CfnService.CodeRepositoryProperty.CodeConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfiguration(software.amazon.awscdk.IResolvable codeConfiguration) {
                this.codeConfiguration = codeConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeRepositoryProperty build() {
                return new Jsii$Proxy(repositoryUrl, sourceCodeVersion, codeConfiguration);
            }
        }

        /**
         * An implementation for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeRepositoryProperty {
            private final java.lang.String repositoryUrl;
            private final java.lang.Object sourceCodeVersion;
            private final java.lang.Object codeConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryUrl = software.amazon.jsii.Kernel.get(this, "repositoryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceCodeVersion = software.amazon.jsii.Kernel.get(this, "sourceCodeVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeConfiguration = software.amazon.jsii.Kernel.get(this, "codeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String repositoryUrl, final java.lang.Object sourceCodeVersion, final java.lang.Object codeConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryUrl = java.util.Objects.requireNonNull(repositoryUrl, "repositoryUrl is required");
                this.sourceCodeVersion = java.util.Objects.requireNonNull(sourceCodeVersion, "sourceCodeVersion is required");
                this.codeConfiguration = codeConfiguration;
            }

            @Override
            public final java.lang.String getRepositoryUrl() {
                return this.repositoryUrl;
            }

            @Override
            public final java.lang.Object getSourceCodeVersion() {
                return this.sourceCodeVersion;
            }

            @Override
            public final java.lang.Object getCodeConfiguration() {
                return this.codeConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));
                data.set("sourceCodeVersion", om.valueToTree(this.getSourceCodeVersion()));
                if (this.getCodeConfiguration() != null) {
                    data.set("codeConfiguration", om.valueToTree(this.getCodeConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.CodeRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeRepositoryProperty.Jsii$Proxy that = (CodeRepositoryProperty.Jsii$Proxy) o;

                if (!repositoryUrl.equals(that.repositoryUrl)) return false;
                if (!sourceCodeVersion.equals(that.sourceCodeVersion)) return false;
                return this.codeConfiguration != null ? this.codeConfiguration.equals(that.codeConfiguration) : that.codeConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.repositoryUrl.hashCode();
                result = 31 * result + (this.sourceCodeVersion.hashCode());
                result = 31 * result + (this.codeConfiguration != null ? this.codeConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.EncryptionConfigurationProperty.KmsKey`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKmsKey();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            private java.lang.String kmsKey;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey `CfnService.EncryptionConfigurationProperty.KmsKey`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(kmsKey);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String kmsKey) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKey = java.util.Objects.requireNonNull(kmsKey, "kmsKey is required");
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsKey", om.valueToTree(this.getKmsKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKey.equals(that.kmsKey);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKey.hashCode();
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.HealthCheckConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.HealthCheckConfigurationProperty.HealthyThreshold`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHealthyThreshold() {
            return null;
        }

        /**
         * `CfnService.HealthCheckConfigurationProperty.Interval`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * `CfnService.HealthCheckConfigurationProperty.Path`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * `CfnService.HealthCheckConfigurationProperty.Protocol`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * `CfnService.HealthCheckConfigurationProperty.Timeout`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * `CfnService.HealthCheckConfigurationProperty.UnhealthyThreshold`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUnhealthyThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckConfigurationProperty> {
            private java.lang.Number healthyThreshold;
            private java.lang.Number interval;
            private java.lang.String path;
            private java.lang.String protocol;
            private java.lang.Number timeout;
            private java.lang.Number unhealthyThreshold;

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getHealthyThreshold}
             * @param healthyThreshold `CfnService.HealthCheckConfigurationProperty.HealthyThreshold`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthyThreshold(java.lang.Number healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getInterval}
             * @param interval `CfnService.HealthCheckConfigurationProperty.Interval`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getPath}
             * @param path `CfnService.HealthCheckConfigurationProperty.Path`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getProtocol}
             * @param protocol `CfnService.HealthCheckConfigurationProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getTimeout}
             * @param timeout `CfnService.HealthCheckConfigurationProperty.Timeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getUnhealthyThreshold}
             * @param unhealthyThreshold `CfnService.HealthCheckConfigurationProperty.UnhealthyThreshold`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unhealthyThreshold(java.lang.Number unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckConfigurationProperty build() {
                return new Jsii$Proxy(healthyThreshold, interval, path, protocol, timeout, unhealthyThreshold);
            }
        }

        /**
         * An implementation for {@link HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckConfigurationProperty {
            private final java.lang.Number healthyThreshold;
            private final java.lang.Number interval;
            private final java.lang.String path;
            private final java.lang.String protocol;
            private final java.lang.Number timeout;
            private final java.lang.Number unhealthyThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthyThreshold = software.amazon.jsii.Kernel.get(this, "healthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unhealthyThreshold = software.amazon.jsii.Kernel.get(this, "unhealthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number healthyThreshold, final java.lang.Number interval, final java.lang.String path, final java.lang.String protocol, final java.lang.Number timeout, final java.lang.Number unhealthyThreshold) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthyThreshold = healthyThreshold;
                this.interval = interval;
                this.path = path;
                this.protocol = protocol;
                this.timeout = timeout;
                this.unhealthyThreshold = unhealthyThreshold;
            }

            @Override
            public final java.lang.Number getHealthyThreshold() {
                return this.healthyThreshold;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            public final java.lang.Number getUnhealthyThreshold() {
                return this.unhealthyThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHealthyThreshold() != null) {
                    data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }
                if (this.getUnhealthyThreshold() != null) {
                    data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.HealthCheckConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckConfigurationProperty.Jsii$Proxy that = (HealthCheckConfigurationProperty.Jsii$Proxy) o;

                if (this.healthyThreshold != null ? !this.healthyThreshold.equals(that.healthyThreshold) : that.healthyThreshold != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
                return this.unhealthyThreshold != null ? this.unhealthyThreshold.equals(that.unhealthyThreshold) : that.unhealthyThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthyThreshold != null ? this.healthyThreshold.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                result = 31 * result + (this.unhealthyThreshold != null ? this.unhealthyThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.ImageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.ImageConfigurationProperty.Port`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * `CfnService.ImageConfigurationProperty.RuntimeEnvironmentVariables`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeEnvironmentVariables() {
            return null;
        }

        /**
         * `CfnService.ImageConfigurationProperty.StartCommand`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartCommand() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageConfigurationProperty> {
            private java.lang.String port;
            private java.lang.Object runtimeEnvironmentVariables;
            private java.lang.String startCommand;

            /**
             * Sets the value of {@link ImageConfigurationProperty#getPort}
             * @param port `CfnService.ImageConfigurationProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables `CfnService.ImageConfigurationProperty.RuntimeEnvironmentVariables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(software.amazon.awscdk.IResolvable runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables `CfnService.ImageConfigurationProperty.RuntimeEnvironmentVariables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(java.util.List<? extends java.lang.Object> runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getStartCommand}
             * @param startCommand `CfnService.ImageConfigurationProperty.StartCommand`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startCommand(java.lang.String startCommand) {
                this.startCommand = startCommand;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageConfigurationProperty build() {
                return new Jsii$Proxy(port, runtimeEnvironmentVariables, startCommand);
            }
        }

        /**
         * An implementation for {@link ImageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageConfigurationProperty {
            private final java.lang.String port;
            private final java.lang.Object runtimeEnvironmentVariables;
            private final java.lang.String startCommand;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtimeEnvironmentVariables = software.amazon.jsii.Kernel.get(this, "runtimeEnvironmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startCommand = software.amazon.jsii.Kernel.get(this, "startCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String port, final java.lang.Object runtimeEnvironmentVariables, final java.lang.String startCommand) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = port;
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                this.startCommand = startCommand;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getRuntimeEnvironmentVariables() {
                return this.runtimeEnvironmentVariables;
            }

            @Override
            public final java.lang.String getStartCommand() {
                return this.startCommand;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRuntimeEnvironmentVariables() != null) {
                    data.set("runtimeEnvironmentVariables", om.valueToTree(this.getRuntimeEnvironmentVariables()));
                }
                if (this.getStartCommand() != null) {
                    data.set("startCommand", om.valueToTree(this.getStartCommand()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.ImageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageConfigurationProperty.Jsii$Proxy that = (ImageConfigurationProperty.Jsii$Proxy) o;

                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.runtimeEnvironmentVariables != null ? !this.runtimeEnvironmentVariables.equals(that.runtimeEnvironmentVariables) : that.runtimeEnvironmentVariables != null) return false;
                return this.startCommand != null ? this.startCommand.equals(that.startCommand) : that.startCommand == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port != null ? this.port.hashCode() : 0;
                result = 31 * result + (this.runtimeEnvironmentVariables != null ? this.runtimeEnvironmentVariables.hashCode() : 0);
                result = 31 * result + (this.startCommand != null ? this.startCommand.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.ImageRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.ImageRepositoryProperty.ImageIdentifier`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageIdentifier();

        /**
         * `CfnService.ImageRepositoryProperty.ImageRepositoryType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageRepositoryType();

        /**
         * `CfnService.ImageRepositoryProperty.ImageConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageRepositoryProperty> {
            private java.lang.String imageIdentifier;
            private java.lang.String imageRepositoryType;
            private java.lang.Object imageConfiguration;

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageIdentifier}
             * @param imageIdentifier `CfnService.ImageRepositoryProperty.ImageIdentifier`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageIdentifier(java.lang.String imageIdentifier) {
                this.imageIdentifier = imageIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageRepositoryType}
             * @param imageRepositoryType `CfnService.ImageRepositoryProperty.ImageRepositoryType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageRepositoryType(java.lang.String imageRepositoryType) {
                this.imageRepositoryType = imageRepositoryType;
                return this;
            }

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageConfiguration}
             * @param imageConfiguration `CfnService.ImageRepositoryProperty.ImageConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageConfiguration(software.amazon.awscdk.services.apprunner.CfnService.ImageConfigurationProperty imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageConfiguration}
             * @param imageConfiguration `CfnService.ImageRepositoryProperty.ImageConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageConfiguration(software.amazon.awscdk.IResolvable imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageRepositoryProperty build() {
                return new Jsii$Proxy(imageIdentifier, imageRepositoryType, imageConfiguration);
            }
        }

        /**
         * An implementation for {@link ImageRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageRepositoryProperty {
            private final java.lang.String imageIdentifier;
            private final java.lang.String imageRepositoryType;
            private final java.lang.Object imageConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageIdentifier = software.amazon.jsii.Kernel.get(this, "imageIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageRepositoryType = software.amazon.jsii.Kernel.get(this, "imageRepositoryType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageConfiguration = software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String imageIdentifier, final java.lang.String imageRepositoryType, final java.lang.Object imageConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageIdentifier = java.util.Objects.requireNonNull(imageIdentifier, "imageIdentifier is required");
                this.imageRepositoryType = java.util.Objects.requireNonNull(imageRepositoryType, "imageRepositoryType is required");
                this.imageConfiguration = imageConfiguration;
            }

            @Override
            public final java.lang.String getImageIdentifier() {
                return this.imageIdentifier;
            }

            @Override
            public final java.lang.String getImageRepositoryType() {
                return this.imageRepositoryType;
            }

            @Override
            public final java.lang.Object getImageConfiguration() {
                return this.imageConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageIdentifier", om.valueToTree(this.getImageIdentifier()));
                data.set("imageRepositoryType", om.valueToTree(this.getImageRepositoryType()));
                if (this.getImageConfiguration() != null) {
                    data.set("imageConfiguration", om.valueToTree(this.getImageConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.ImageRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageRepositoryProperty.Jsii$Proxy that = (ImageRepositoryProperty.Jsii$Proxy) o;

                if (!imageIdentifier.equals(that.imageIdentifier)) return false;
                if (!imageRepositoryType.equals(that.imageRepositoryType)) return false;
                return this.imageConfiguration != null ? this.imageConfiguration.equals(that.imageConfiguration) : that.imageConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageIdentifier.hashCode();
                result = 31 * result + (this.imageRepositoryType.hashCode());
                result = 31 * result + (this.imageConfiguration != null ? this.imageConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.InstanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.InstanceConfigurationProperty.Cpu`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
            return null;
        }

        /**
         * `CfnService.InstanceConfigurationProperty.InstanceRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceRoleArn() {
            return null;
        }

        /**
         * `CfnService.InstanceConfigurationProperty.Memory`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceConfigurationProperty> {
            private java.lang.String cpu;
            private java.lang.String instanceRoleArn;
            private java.lang.String memory;

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getCpu}
             * @param cpu `CfnService.InstanceConfigurationProperty.Cpu`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getInstanceRoleArn}
             * @param instanceRoleArn `CfnService.InstanceConfigurationProperty.InstanceRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRoleArn(java.lang.String instanceRoleArn) {
                this.instanceRoleArn = instanceRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getMemory}
             * @param memory `CfnService.InstanceConfigurationProperty.Memory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceConfigurationProperty build() {
                return new Jsii$Proxy(cpu, instanceRoleArn, memory);
            }
        }

        /**
         * An implementation for {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceConfigurationProperty {
            private final java.lang.String cpu;
            private final java.lang.String instanceRoleArn;
            private final java.lang.String memory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceRoleArn = software.amazon.jsii.Kernel.get(this, "instanceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String cpu, final java.lang.String instanceRoleArn, final java.lang.String memory) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpu = cpu;
                this.instanceRoleArn = instanceRoleArn;
                this.memory = memory;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.String getInstanceRoleArn() {
                return this.instanceRoleArn;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpu() != null) {
                    data.set("cpu", om.valueToTree(this.getCpu()));
                }
                if (this.getInstanceRoleArn() != null) {
                    data.set("instanceRoleArn", om.valueToTree(this.getInstanceRoleArn()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.InstanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceConfigurationProperty.Jsii$Proxy that = (InstanceConfigurationProperty.Jsii$Proxy) o;

                if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
                if (this.instanceRoleArn != null ? !this.instanceRoleArn.equals(that.instanceRoleArn) : that.instanceRoleArn != null) return false;
                return this.memory != null ? this.memory.equals(that.memory) : that.memory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpu != null ? this.cpu.hashCode() : 0;
                result = 31 * result + (this.instanceRoleArn != null ? this.instanceRoleArn.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.KeyValuePairProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyValuePairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyValuePairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.KeyValuePairProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * `CfnService.KeyValuePairProperty.Value`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyValuePairProperty> {
            private java.lang.String name;
            private java.lang.String value;

            /**
             * Sets the value of {@link KeyValuePairProperty#getName}
             * @param name `CfnService.KeyValuePairProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link KeyValuePairProperty#getValue}
             * @param value `CfnService.KeyValuePairProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyValuePairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyValuePairProperty build() {
                return new Jsii$Proxy(name, value);
            }
        }

        /**
         * An implementation for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValuePairProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String name, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = name;
                this.value = value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.KeyValuePairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyValuePairProperty.Jsii$Proxy that = (KeyValuePairProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.SourceCodeVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceCodeVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceCodeVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.SourceCodeVersionProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnService.SourceCodeVersionProperty.Value`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SourceCodeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceCodeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceCodeVersionProperty> {
            private java.lang.String type;
            private java.lang.String value;

            /**
             * Sets the value of {@link SourceCodeVersionProperty#getType}
             * @param type `CfnService.SourceCodeVersionProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceCodeVersionProperty#getValue}
             * @param value `CfnService.SourceCodeVersionProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceCodeVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceCodeVersionProperty build() {
                return new Jsii$Proxy(type, value);
            }
        }

        /**
         * An implementation for {@link SourceCodeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceCodeVersionProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String type, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.SourceCodeVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceCodeVersionProperty.Jsii$Proxy that = (SourceCodeVersionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.SourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnService.SourceConfigurationProperty.AuthenticationConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationConfiguration() {
            return null;
        }

        /**
         * `CfnService.SourceConfigurationProperty.AutoDeploymentsEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoDeploymentsEnabled() {
            return null;
        }

        /**
         * `CfnService.SourceConfigurationProperty.CodeRepository`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeRepository() {
            return null;
        }

        /**
         * `CfnService.SourceConfigurationProperty.ImageRepository`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageRepository() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConfigurationProperty> {
            private java.lang.Object authenticationConfiguration;
            private java.lang.Object autoDeploymentsEnabled;
            private java.lang.Object codeRepository;
            private java.lang.Object imageRepository;

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration `CfnService.SourceConfigurationProperty.AuthenticationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.services.apprunner.CfnService.AuthenticationConfigurationProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration `CfnService.SourceConfigurationProperty.AuthenticationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAutoDeploymentsEnabled}
             * @param autoDeploymentsEnabled `CfnService.SourceConfigurationProperty.AutoDeploymentsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoDeploymentsEnabled(java.lang.Boolean autoDeploymentsEnabled) {
                this.autoDeploymentsEnabled = autoDeploymentsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAutoDeploymentsEnabled}
             * @param autoDeploymentsEnabled `CfnService.SourceConfigurationProperty.AutoDeploymentsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoDeploymentsEnabled(software.amazon.awscdk.IResolvable autoDeploymentsEnabled) {
                this.autoDeploymentsEnabled = autoDeploymentsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getCodeRepository}
             * @param codeRepository `CfnService.SourceConfigurationProperty.CodeRepository`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepository(software.amazon.awscdk.services.apprunner.CfnService.CodeRepositoryProperty codeRepository) {
                this.codeRepository = codeRepository;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getCodeRepository}
             * @param codeRepository `CfnService.SourceConfigurationProperty.CodeRepository`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepository(software.amazon.awscdk.IResolvable codeRepository) {
                this.codeRepository = codeRepository;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getImageRepository}
             * @param imageRepository `CfnService.SourceConfigurationProperty.ImageRepository`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageRepository(software.amazon.awscdk.services.apprunner.CfnService.ImageRepositoryProperty imageRepository) {
                this.imageRepository = imageRepository;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getImageRepository}
             * @param imageRepository `CfnService.SourceConfigurationProperty.ImageRepository`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageRepository(software.amazon.awscdk.IResolvable imageRepository) {
                this.imageRepository = imageRepository;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConfigurationProperty build() {
                return new Jsii$Proxy(authenticationConfiguration, autoDeploymentsEnabled, codeRepository, imageRepository);
            }
        }

        /**
         * An implementation for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigurationProperty {
            private final java.lang.Object authenticationConfiguration;
            private final java.lang.Object autoDeploymentsEnabled;
            private final java.lang.Object codeRepository;
            private final java.lang.Object imageRepository;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoDeploymentsEnabled = software.amazon.jsii.Kernel.get(this, "autoDeploymentsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeRepository = software.amazon.jsii.Kernel.get(this, "codeRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageRepository = software.amazon.jsii.Kernel.get(this, "imageRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object authenticationConfiguration, final java.lang.Object autoDeploymentsEnabled, final java.lang.Object codeRepository, final java.lang.Object imageRepository) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationConfiguration = authenticationConfiguration;
                this.autoDeploymentsEnabled = autoDeploymentsEnabled;
                this.codeRepository = codeRepository;
                this.imageRepository = imageRepository;
            }

            @Override
            public final java.lang.Object getAuthenticationConfiguration() {
                return this.authenticationConfiguration;
            }

            @Override
            public final java.lang.Object getAutoDeploymentsEnabled() {
                return this.autoDeploymentsEnabled;
            }

            @Override
            public final java.lang.Object getCodeRepository() {
                return this.codeRepository;
            }

            @Override
            public final java.lang.Object getImageRepository() {
                return this.imageRepository;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthenticationConfiguration() != null) {
                    data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                }
                if (this.getAutoDeploymentsEnabled() != null) {
                    data.set("autoDeploymentsEnabled", om.valueToTree(this.getAutoDeploymentsEnabled()));
                }
                if (this.getCodeRepository() != null) {
                    data.set("codeRepository", om.valueToTree(this.getCodeRepository()));
                }
                if (this.getImageRepository() != null) {
                    data.set("imageRepository", om.valueToTree(this.getImageRepository()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.SourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigurationProperty.Jsii$Proxy that = (SourceConfigurationProperty.Jsii$Proxy) o;

                if (this.authenticationConfiguration != null ? !this.authenticationConfiguration.equals(that.authenticationConfiguration) : that.authenticationConfiguration != null) return false;
                if (this.autoDeploymentsEnabled != null ? !this.autoDeploymentsEnabled.equals(that.autoDeploymentsEnabled) : that.autoDeploymentsEnabled != null) return false;
                if (this.codeRepository != null ? !this.codeRepository.equals(that.codeRepository) : that.codeRepository != null) return false;
                return this.imageRepository != null ? this.imageRepository.equals(that.imageRepository) : that.imageRepository == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationConfiguration != null ? this.authenticationConfiguration.hashCode() : 0;
                result = 31 * result + (this.autoDeploymentsEnabled != null ? this.autoDeploymentsEnabled.hashCode() : 0);
                result = 31 * result + (this.codeRepository != null ? this.codeRepository.hashCode() : 0);
                result = 31 * result + (this.imageRepository != null ? this.imageRepository.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apprunner.CfnService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apprunner.CfnService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apprunner.CfnServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apprunner.CfnServiceProps.Builder();
        }

        /**
         * `AWS::AppRunner::Service.SourceConfiguration`.
         * <p>
         * @return {@code this}
         * @param sourceConfiguration `AWS::AppRunner::Service.SourceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }
        /**
         * `AWS::AppRunner::Service.SourceConfiguration`.
         * <p>
         * @return {@code this}
         * @param sourceConfiguration `AWS::AppRunner::Service.SourceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.IResolvable sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        /**
         * `AWS::AppRunner::Service.AutoScalingConfigurationArn`.
         * <p>
         * @return {@code this}
         * @param autoScalingConfigurationArn `AWS::AppRunner::Service.AutoScalingConfigurationArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingConfigurationArn(final java.lang.String autoScalingConfigurationArn) {
            this.props.autoScalingConfigurationArn(autoScalingConfigurationArn);
            return this;
        }

        /**
         * `AWS::AppRunner::Service.EncryptionConfiguration`.
         * <p>
         * @return {@code this}
         * @param encryptionConfiguration `AWS::AppRunner::Service.EncryptionConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.EncryptionConfigurationProperty encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }
        /**
         * `AWS::AppRunner::Service.EncryptionConfiguration`.
         * <p>
         * @return {@code this}
         * @param encryptionConfiguration `AWS::AppRunner::Service.EncryptionConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(final software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        /**
         * `AWS::AppRunner::Service.HealthCheckConfiguration`.
         * <p>
         * @return {@code this}
         * @param healthCheckConfiguration `AWS::AppRunner::Service.HealthCheckConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.HealthCheckConfigurationProperty healthCheckConfiguration) {
            this.props.healthCheckConfiguration(healthCheckConfiguration);
            return this;
        }
        /**
         * `AWS::AppRunner::Service.HealthCheckConfiguration`.
         * <p>
         * @return {@code this}
         * @param healthCheckConfiguration `AWS::AppRunner::Service.HealthCheckConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfiguration(final software.amazon.awscdk.IResolvable healthCheckConfiguration) {
            this.props.healthCheckConfiguration(healthCheckConfiguration);
            return this;
        }

        /**
         * `AWS::AppRunner::Service.InstanceConfiguration`.
         * <p>
         * @return {@code this}
         * @param instanceConfiguration `AWS::AppRunner::Service.InstanceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.InstanceConfigurationProperty instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }
        /**
         * `AWS::AppRunner::Service.InstanceConfiguration`.
         * <p>
         * @return {@code this}
         * @param instanceConfiguration `AWS::AppRunner::Service.InstanceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(final software.amazon.awscdk.IResolvable instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }

        /**
         * `AWS::AppRunner::Service.ServiceName`.
         * <p>
         * @return {@code this}
         * @param serviceName `AWS::AppRunner::Service.ServiceName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * `AWS::AppRunner::Service.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::AppRunner::Service.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apprunner.CfnService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apprunner.CfnService build() {
            return new software.amazon.awscdk.services.apprunner.CfnService(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
