package software.amazon.awscdk.services.appsync;

/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:59.730Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi")
public class CfnGraphQLApi extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnGraphQLApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGraphQLApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.CfnGraphQLApi.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppSync::GraphQLApi`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGraphQLApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnGraphQLApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApiId() {
        return software.amazon.jsii.Kernel.get(this, "attrApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGraphQlUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrGraphQlUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::AppSync::GraphQLApi.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.AuthenticationType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType() {
        return software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.AuthenticationType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authenticationType", java.util.Objects.requireNonNull(value, "authenticationType is required"));
    }

    /**
     * `AWS::AppSync::GraphQLApi.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalAuthenticationProviders() {
        return software.amazon.jsii.Kernel.get(this, "additionalAuthenticationProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalAuthenticationProviders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalAuthenticationProviders", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalAuthenticationProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "additionalAuthenticationProviders", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.LambdaAuthorizerConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
        return software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.LambdaAuthorizerConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "lambdaAuthorizerConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.LambdaAuthorizerConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lambdaAuthorizerConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.LogConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogConfig() {
        return software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.LogConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "logConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.LogConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
        return software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "openIdConnectConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openIdConnectConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.UserPoolConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
        return software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.UserPoolConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "userPoolConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.UserPoolConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userPoolConfig", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.XrayEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getXrayEnabled() {
        return software.amazon.jsii.Kernel.get(this, "xrayEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::AppSync::GraphQLApi.XrayEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXrayEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "xrayEnabled", value);
    }

    /**
     * `AWS::AppSync::GraphQLApi.XrayEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXrayEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "xrayEnabled", value);
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(AdditionalAuthenticationProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdditionalAuthenticationProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.AuthenticationType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

        /**
         * `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.LambdaAuthorizerConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
            return null;
        }

        /**
         * `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.OpenIDConnectConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
            return null;
        }

        /**
         * `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.UserPoolConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdditionalAuthenticationProviderProperty> {
            private java.lang.String authenticationType;
            private java.lang.Object lambdaAuthorizerConfig;
            private java.lang.Object openIdConnectConfig;
            private java.lang.Object userPoolConfig;

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getAuthenticationType}
             * @param authenticationType `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.AuthenticationType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.LambdaAuthorizerConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.LambdaAuthorizerConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.OpenIDConnectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.OpenIDConnectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.IResolvable openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getUserPoolConfig}
             * @param userPoolConfig `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.UserPoolConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty userPoolConfig) {
                this.userPoolConfig = userPoolConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getUserPoolConfig}
             * @param userPoolConfig `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.UserPoolConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolConfig(software.amazon.awscdk.IResolvable userPoolConfig) {
                this.userPoolConfig = userPoolConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdditionalAuthenticationProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdditionalAuthenticationProviderProperty build() {
                return new Jsii$Proxy(authenticationType, lambdaAuthorizerConfig, openIdConnectConfig, userPoolConfig);
            }
        }

        /**
         * An implementation for {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdditionalAuthenticationProviderProperty {
            private final java.lang.String authenticationType;
            private final java.lang.Object lambdaAuthorizerConfig;
            private final java.lang.Object openIdConnectConfig;
            private final java.lang.Object userPoolConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userPoolConfig = software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String authenticationType, final java.lang.Object lambdaAuthorizerConfig, final java.lang.Object openIdConnectConfig, final java.lang.Object userPoolConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = java.util.Objects.requireNonNull(authenticationType, "authenticationType is required");
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                this.openIdConnectConfig = openIdConnectConfig;
                this.userPoolConfig = userPoolConfig;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getLambdaAuthorizerConfig() {
                return this.lambdaAuthorizerConfig;
            }

            @Override
            public final java.lang.Object getOpenIdConnectConfig() {
                return this.openIdConnectConfig;
            }

            @Override
            public final java.lang.Object getUserPoolConfig() {
                return this.userPoolConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                if (this.getLambdaAuthorizerConfig() != null) {
                    data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
                }
                if (this.getOpenIdConnectConfig() != null) {
                    data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
                }
                if (this.getUserPoolConfig() != null) {
                    data.set("userPoolConfig", om.valueToTree(this.getUserPoolConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdditionalAuthenticationProviderProperty.Jsii$Proxy that = (AdditionalAuthenticationProviderProperty.Jsii$Proxy) o;

                if (!authenticationType.equals(that.authenticationType)) return false;
                if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
                if (this.openIdConnectConfig != null ? !this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig != null) return false;
                return this.userPoolConfig != null ? this.userPoolConfig.equals(that.userPoolConfig) : that.userPoolConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType.hashCode();
                result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
                result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
                result = 31 * result + (this.userPoolConfig != null ? this.userPoolConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoUserPoolConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoUserPoolConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnGraphQLApi.CognitoUserPoolConfigProperty.AppIdClientRegex`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
            return null;
        }

        /**
         * `CfnGraphQLApi.CognitoUserPoolConfigProperty.AwsRegion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * `CfnGraphQLApi.CognitoUserPoolConfigProperty.UserPoolId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoUserPoolConfigProperty> {
            private java.lang.String appIdClientRegex;
            private java.lang.String awsRegion;
            private java.lang.String userPoolId;

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getAppIdClientRegex}
             * @param appIdClientRegex `CfnGraphQLApi.CognitoUserPoolConfigProperty.AppIdClientRegex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getAwsRegion}
             * @param awsRegion `CfnGraphQLApi.CognitoUserPoolConfigProperty.AwsRegion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getUserPoolId}
             * @param userPoolId `CfnGraphQLApi.CognitoUserPoolConfigProperty.UserPoolId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoUserPoolConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoUserPoolConfigProperty build() {
                return new Jsii$Proxy(appIdClientRegex, awsRegion, userPoolId);
            }
        }

        /**
         * An implementation for {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoUserPoolConfigProperty {
            private final java.lang.String appIdClientRegex;
            private final java.lang.String awsRegion;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String appIdClientRegex, final java.lang.String awsRegion, final java.lang.String userPoolId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIdClientRegex = appIdClientRegex;
                this.awsRegion = awsRegion;
                this.userPoolId = userPoolId;
            }

            @Override
            public final java.lang.String getAppIdClientRegex() {
                return this.appIdClientRegex;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppIdClientRegex() != null) {
                    data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoUserPoolConfigProperty.Jsii$Proxy that = (CognitoUserPoolConfigProperty.Jsii$Proxy) o;

                if (this.appIdClientRegex != null ? !this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex != null) return false;
                if (this.awsRegion != null ? !this.awsRegion.equals(that.awsRegion) : that.awsRegion != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0;
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaAuthorizerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaAuthorizerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnGraphQLApi.LambdaAuthorizerConfigProperty.AuthorizerResultTtlInSeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthorizerResultTtlInSeconds() {
            return null;
        }

        /**
         * `CfnGraphQLApi.LambdaAuthorizerConfigProperty.AuthorizerUri`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
            return null;
        }

        /**
         * `CfnGraphQLApi.LambdaAuthorizerConfigProperty.IdentityValidationExpression`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityValidationExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaAuthorizerConfigProperty> {
            private java.lang.Number authorizerResultTtlInSeconds;
            private java.lang.String authorizerUri;
            private java.lang.String identityValidationExpression;

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerResultTtlInSeconds}
             * @param authorizerResultTtlInSeconds `CfnGraphQLApi.LambdaAuthorizerConfigProperty.AuthorizerResultTtlInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerResultTtlInSeconds(java.lang.Number authorizerResultTtlInSeconds) {
                this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerUri}
             * @param authorizerUri `CfnGraphQLApi.LambdaAuthorizerConfigProperty.AuthorizerUri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerUri(java.lang.String authorizerUri) {
                this.authorizerUri = authorizerUri;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getIdentityValidationExpression}
             * @param identityValidationExpression `CfnGraphQLApi.LambdaAuthorizerConfigProperty.IdentityValidationExpression`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityValidationExpression(java.lang.String identityValidationExpression) {
                this.identityValidationExpression = identityValidationExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaAuthorizerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaAuthorizerConfigProperty build() {
                return new Jsii$Proxy(authorizerResultTtlInSeconds, authorizerUri, identityValidationExpression);
            }
        }

        /**
         * An implementation for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaAuthorizerConfigProperty {
            private final java.lang.Number authorizerResultTtlInSeconds;
            private final java.lang.String authorizerUri;
            private final java.lang.String identityValidationExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizerResultTtlInSeconds = software.amazon.jsii.Kernel.get(this, "authorizerResultTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityValidationExpression = software.amazon.jsii.Kernel.get(this, "identityValidationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number authorizerResultTtlInSeconds, final java.lang.String authorizerUri, final java.lang.String identityValidationExpression) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
                this.authorizerUri = authorizerUri;
                this.identityValidationExpression = identityValidationExpression;
            }

            @Override
            public final java.lang.Number getAuthorizerResultTtlInSeconds() {
                return this.authorizerResultTtlInSeconds;
            }

            @Override
            public final java.lang.String getAuthorizerUri() {
                return this.authorizerUri;
            }

            @Override
            public final java.lang.String getIdentityValidationExpression() {
                return this.identityValidationExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizerResultTtlInSeconds() != null) {
                    data.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
                }
                if (this.getAuthorizerUri() != null) {
                    data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
                }
                if (this.getIdentityValidationExpression() != null) {
                    data.set("identityValidationExpression", om.valueToTree(this.getIdentityValidationExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaAuthorizerConfigProperty.Jsii$Proxy that = (LambdaAuthorizerConfigProperty.Jsii$Proxy) o;

                if (this.authorizerResultTtlInSeconds != null ? !this.authorizerResultTtlInSeconds.equals(that.authorizerResultTtlInSeconds) : that.authorizerResultTtlInSeconds != null) return false;
                if (this.authorizerUri != null ? !this.authorizerUri.equals(that.authorizerUri) : that.authorizerUri != null) return false;
                return this.identityValidationExpression != null ? this.identityValidationExpression.equals(that.identityValidationExpression) : that.identityValidationExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizerResultTtlInSeconds != null ? this.authorizerResultTtlInSeconds.hashCode() : 0;
                result = 31 * result + (this.authorizerUri != null ? this.authorizerUri.hashCode() : 0);
                result = 31 * result + (this.identityValidationExpression != null ? this.identityValidationExpression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.LogConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnGraphQLApi.LogConfigProperty.CloudWatchLogsRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsRoleArn() {
            return null;
        }

        /**
         * `CfnGraphQLApi.LogConfigProperty.ExcludeVerboseContent`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeVerboseContent() {
            return null;
        }

        /**
         * `CfnGraphQLApi.LogConfigProperty.FieldLogLevel`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLogLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigProperty> {
            private java.lang.String cloudWatchLogsRoleArn;
            private java.lang.Object excludeVerboseContent;
            private java.lang.String fieldLogLevel;

            /**
             * Sets the value of {@link LogConfigProperty#getCloudWatchLogsRoleArn}
             * @param cloudWatchLogsRoleArn `CfnGraphQLApi.LogConfigProperty.CloudWatchLogsRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsRoleArn(java.lang.String cloudWatchLogsRoleArn) {
                this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getExcludeVerboseContent}
             * @param excludeVerboseContent `CfnGraphQLApi.LogConfigProperty.ExcludeVerboseContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVerboseContent(java.lang.Boolean excludeVerboseContent) {
                this.excludeVerboseContent = excludeVerboseContent;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getExcludeVerboseContent}
             * @param excludeVerboseContent `CfnGraphQLApi.LogConfigProperty.ExcludeVerboseContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVerboseContent(software.amazon.awscdk.IResolvable excludeVerboseContent) {
                this.excludeVerboseContent = excludeVerboseContent;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getFieldLogLevel}
             * @param fieldLogLevel `CfnGraphQLApi.LogConfigProperty.FieldLogLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLogLevel(java.lang.String fieldLogLevel) {
                this.fieldLogLevel = fieldLogLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigProperty build() {
                return new Jsii$Proxy(cloudWatchLogsRoleArn, excludeVerboseContent, fieldLogLevel);
            }
        }

        /**
         * An implementation for {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigProperty {
            private final java.lang.String cloudWatchLogsRoleArn;
            private final java.lang.Object excludeVerboseContent;
            private final java.lang.String fieldLogLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsRoleArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeVerboseContent = software.amazon.jsii.Kernel.get(this, "excludeVerboseContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldLogLevel = software.amazon.jsii.Kernel.get(this, "fieldLogLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String cloudWatchLogsRoleArn, final java.lang.Object excludeVerboseContent, final java.lang.String fieldLogLevel) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
                this.excludeVerboseContent = excludeVerboseContent;
                this.fieldLogLevel = fieldLogLevel;
            }

            @Override
            public final java.lang.String getCloudWatchLogsRoleArn() {
                return this.cloudWatchLogsRoleArn;
            }

            @Override
            public final java.lang.Object getExcludeVerboseContent() {
                return this.excludeVerboseContent;
            }

            @Override
            public final java.lang.String getFieldLogLevel() {
                return this.fieldLogLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsRoleArn() != null) {
                    data.set("cloudWatchLogsRoleArn", om.valueToTree(this.getCloudWatchLogsRoleArn()));
                }
                if (this.getExcludeVerboseContent() != null) {
                    data.set("excludeVerboseContent", om.valueToTree(this.getExcludeVerboseContent()));
                }
                if (this.getFieldLogLevel() != null) {
                    data.set("fieldLogLevel", om.valueToTree(this.getFieldLogLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.LogConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigProperty.Jsii$Proxy that = (LogConfigProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsRoleArn != null ? !this.cloudWatchLogsRoleArn.equals(that.cloudWatchLogsRoleArn) : that.cloudWatchLogsRoleArn != null) return false;
                if (this.excludeVerboseContent != null ? !this.excludeVerboseContent.equals(that.excludeVerboseContent) : that.excludeVerboseContent != null) return false;
                return this.fieldLogLevel != null ? this.fieldLogLevel.equals(that.fieldLogLevel) : that.fieldLogLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsRoleArn != null ? this.cloudWatchLogsRoleArn.hashCode() : 0;
                result = 31 * result + (this.excludeVerboseContent != null ? this.excludeVerboseContent.hashCode() : 0);
                result = 31 * result + (this.fieldLogLevel != null ? this.fieldLogLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.OpenIDConnectConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIDConnectConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIDConnectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.AuthTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthTtl() {
            return null;
        }

        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.ClientId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.IatTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIatTtl() {
            return null;
        }

        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.Issuer`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIssuer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIDConnectConfigProperty> {
            private java.lang.Number authTtl;
            private java.lang.String clientId;
            private java.lang.Number iatTtl;
            private java.lang.String issuer;

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getAuthTtl}
             * @param authTtl `CfnGraphQLApi.OpenIDConnectConfigProperty.AuthTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authTtl(java.lang.Number authTtl) {
                this.authTtl = authTtl;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getClientId}
             * @param clientId `CfnGraphQLApi.OpenIDConnectConfigProperty.ClientId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIatTtl}
             * @param iatTtl `CfnGraphQLApi.OpenIDConnectConfigProperty.IatTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iatTtl(java.lang.Number iatTtl) {
                this.iatTtl = iatTtl;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIssuer}
             * @param issuer `CfnGraphQLApi.OpenIDConnectConfigProperty.Issuer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIDConnectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIDConnectConfigProperty build() {
                return new Jsii$Proxy(authTtl, clientId, iatTtl, issuer);
            }
        }

        /**
         * An implementation for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIDConnectConfigProperty {
            private final java.lang.Number authTtl;
            private final java.lang.String clientId;
            private final java.lang.Number iatTtl;
            private final java.lang.String issuer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authTtl = software.amazon.jsii.Kernel.get(this, "authTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iatTtl = software.amazon.jsii.Kernel.get(this, "iatTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number authTtl, final java.lang.String clientId, final java.lang.Number iatTtl, final java.lang.String issuer) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authTtl = authTtl;
                this.clientId = clientId;
                this.iatTtl = iatTtl;
                this.issuer = issuer;
            }

            @Override
            public final java.lang.Number getAuthTtl() {
                return this.authTtl;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.Number getIatTtl() {
                return this.iatTtl;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthTtl() != null) {
                    data.set("authTtl", om.valueToTree(this.getAuthTtl()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getIatTtl() != null) {
                    data.set("iatTtl", om.valueToTree(this.getIatTtl()));
                }
                if (this.getIssuer() != null) {
                    data.set("issuer", om.valueToTree(this.getIssuer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.OpenIDConnectConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIDConnectConfigProperty.Jsii$Proxy that = (OpenIDConnectConfigProperty.Jsii$Proxy) o;

                if (this.authTtl != null ? !this.authTtl.equals(that.authTtl) : that.authTtl != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.iatTtl != null ? !this.iatTtl.equals(that.iatTtl) : that.iatTtl != null) return false;
                return this.issuer != null ? this.issuer.equals(that.issuer) : that.issuer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authTtl != null ? this.authTtl.hashCode() : 0;
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.iatTtl != null ? this.iatTtl.hashCode() : 0);
                result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.UserPoolConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPoolConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPoolConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.AppIdClientRegex`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
            return null;
        }

        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.AwsRegion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.DefaultAction`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAction() {
            return null;
        }

        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.UserPoolId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPoolConfigProperty> {
            private java.lang.String appIdClientRegex;
            private java.lang.String awsRegion;
            private java.lang.String defaultAction;
            private java.lang.String userPoolId;

            /**
             * Sets the value of {@link UserPoolConfigProperty#getAppIdClientRegex}
             * @param appIdClientRegex `CfnGraphQLApi.UserPoolConfigProperty.AppIdClientRegex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getAwsRegion}
             * @param awsRegion `CfnGraphQLApi.UserPoolConfigProperty.AwsRegion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getDefaultAction}
             * @param defaultAction `CfnGraphQLApi.UserPoolConfigProperty.DefaultAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultAction(java.lang.String defaultAction) {
                this.defaultAction = defaultAction;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getUserPoolId}
             * @param userPoolId `CfnGraphQLApi.UserPoolConfigProperty.UserPoolId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPoolConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPoolConfigProperty build() {
                return new Jsii$Proxy(appIdClientRegex, awsRegion, defaultAction, userPoolId);
            }
        }

        /**
         * An implementation for {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolConfigProperty {
            private final java.lang.String appIdClientRegex;
            private final java.lang.String awsRegion;
            private final java.lang.String defaultAction;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String appIdClientRegex, final java.lang.String awsRegion, final java.lang.String defaultAction, final java.lang.String userPoolId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIdClientRegex = appIdClientRegex;
                this.awsRegion = awsRegion;
                this.defaultAction = defaultAction;
                this.userPoolId = userPoolId;
            }

            @Override
            public final java.lang.String getAppIdClientRegex() {
                return this.appIdClientRegex;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getDefaultAction() {
                return this.defaultAction;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppIdClientRegex() != null) {
                    data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }
                if (this.getDefaultAction() != null) {
                    data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.UserPoolConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPoolConfigProperty.Jsii$Proxy that = (UserPoolConfigProperty.Jsii$Proxy) o;

                if (this.appIdClientRegex != null ? !this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex != null) return false;
                if (this.awsRegion != null ? !this.awsRegion.equals(that.awsRegion) : that.awsRegion != null) return false;
                if (this.defaultAction != null ? !this.defaultAction.equals(that.defaultAction) : that.defaultAction != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0;
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                result = 31 * result + (this.defaultAction != null ? this.defaultAction.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.CfnGraphQLApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.CfnGraphQLApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.CfnGraphQLApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.CfnGraphQLApiProps.Builder();
        }

        /**
         * `AWS::AppSync::GraphQLApi.AuthenticationType`.
         * <p>
         * @return {@code this}
         * @param authenticationType `AWS::AppSync::GraphQLApi.AuthenticationType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(final java.lang.String authenticationType) {
            this.props.authenticationType(authenticationType);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::AppSync::GraphQLApi.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`.
         * <p>
         * @return {@code this}
         * @param additionalAuthenticationProviders `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(final software.amazon.awscdk.IResolvable additionalAuthenticationProviders) {
            this.props.additionalAuthenticationProviders(additionalAuthenticationProviders);
            return this;
        }
        /**
         * `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`.
         * <p>
         * @return {@code this}
         * @param additionalAuthenticationProviders `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(final java.util.List<? extends java.lang.Object> additionalAuthenticationProviders) {
            this.props.additionalAuthenticationProviders(additionalAuthenticationProviders);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.LambdaAuthorizerConfig`.
         * <p>
         * @return {@code this}
         * @param lambdaAuthorizerConfig `AWS::AppSync::GraphQLApi.LambdaAuthorizerConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
            this.props.lambdaAuthorizerConfig(lambdaAuthorizerConfig);
            return this;
        }
        /**
         * `AWS::AppSync::GraphQLApi.LambdaAuthorizerConfig`.
         * <p>
         * @return {@code this}
         * @param lambdaAuthorizerConfig `AWS::AppSync::GraphQLApi.LambdaAuthorizerConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(final software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
            this.props.lambdaAuthorizerConfig(lambdaAuthorizerConfig);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.LogConfig`.
         * <p>
         * @return {@code this}
         * @param logConfig `AWS::AppSync::GraphQLApi.LogConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }
        /**
         * `AWS::AppSync::GraphQLApi.LogConfig`.
         * <p>
         * @return {@code this}
         * @param logConfig `AWS::AppSync::GraphQLApi.LogConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.IResolvable logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`.
         * <p>
         * @return {@code this}
         * @param openIdConnectConfig `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
            this.props.openIdConnectConfig(openIdConnectConfig);
            return this;
        }
        /**
         * `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`.
         * <p>
         * @return {@code this}
         * @param openIdConnectConfig `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(final software.amazon.awscdk.IResolvable openIdConnectConfig) {
            this.props.openIdConnectConfig(openIdConnectConfig);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::AppSync::GraphQLApi.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final software.amazon.awscdk.IResolvable tags) {
            this.props.tags(tags);
            return this;
        }
        /**
         * `AWS::AppSync::GraphQLApi.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::AppSync::GraphQLApi.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends java.lang.Object> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.UserPoolConfig`.
         * <p>
         * @return {@code this}
         * @param userPoolConfig `AWS::AppSync::GraphQLApi.UserPoolConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty userPoolConfig) {
            this.props.userPoolConfig(userPoolConfig);
            return this;
        }
        /**
         * `AWS::AppSync::GraphQLApi.UserPoolConfig`.
         * <p>
         * @return {@code this}
         * @param userPoolConfig `AWS::AppSync::GraphQLApi.UserPoolConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(final software.amazon.awscdk.IResolvable userPoolConfig) {
            this.props.userPoolConfig(userPoolConfig);
            return this;
        }

        /**
         * `AWS::AppSync::GraphQLApi.XrayEnabled`.
         * <p>
         * @return {@code this}
         * @param xrayEnabled `AWS::AppSync::GraphQLApi.XrayEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(final java.lang.Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }
        /**
         * `AWS::AppSync::GraphQLApi.XrayEnabled`.
         * <p>
         * @return {@code this}
         * @param xrayEnabled `AWS::AppSync::GraphQLApi.XrayEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(final software.amazon.awscdk.IResolvable xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.CfnGraphQLApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.CfnGraphQLApi build() {
            return new software.amazon.awscdk.services.appsync.CfnGraphQLApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
