package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Properties for a scheduled action on an AutoScalingGroup.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:59.794Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.ScheduledActionProps")
@software.amazon.jsii.Jsii.Proxy(ScheduledActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ScheduledActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.autoscaling.BasicScheduledActionProps {

    /**
     * (experimental) The AutoScalingGroup to apply the scheduled actions to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup();

    /**
     * @return a {@link Builder} of {@link ScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledActionProps> {
        private software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private software.amazon.awscdk.services.autoscaling.Schedule schedule;
        private java.lang.Number desiredCapacity;
        private java.time.Instant endTime;
        private java.lang.Number maxCapacity;
        private java.lang.Number minCapacity;
        private java.time.Instant startTime;

        /**
         * Sets the value of {@link ScheduledActionProps#getAutoScalingGroup}
         * @param autoScalingGroup The AutoScalingGroup to apply the scheduled actions to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledActionProps#getSchedule}
         * @param schedule When to perform this action. This parameter is required.
         *                 Supports cron expressions.
         *                 <p>
         *                 For more information about cron expressions, see https://en.wikipedia.org/wiki/Cron.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder schedule(software.amazon.awscdk.services.autoscaling.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledActionProps#getDesiredCapacity}
         * @param desiredCapacity The new desired capacity.
         *                        At the scheduled time, set the desired capacity to the given capacity.
         *                        <p>
         *                        At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder desiredCapacity(java.lang.Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledActionProps#getEndTime}
         * @param endTime When this scheduled action expires.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endTime(java.time.Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledActionProps#getMaxCapacity}
         * @param maxCapacity The new maximum capacity.
         *                    At the scheduled time, set the maximum capacity to the given capacity.
         *                    <p>
         *                    At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledActionProps#getMinCapacity}
         * @param minCapacity The new minimum capacity.
         *                    At the scheduled time, set the minimum capacity to the given capacity.
         *                    <p>
         *                    At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledActionProps#getStartTime}
         * @param startTime When this scheduled action becomes active.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder startTime(java.time.Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ScheduledActionProps build() {
            return new Jsii$Proxy(autoScalingGroup, schedule, desiredCapacity, endTime, maxCapacity, minCapacity, startTime);
        }
    }

    /**
     * An implementation for {@link ScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledActionProps {
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private final software.amazon.awscdk.services.autoscaling.Schedule schedule;
        private final java.lang.Number desiredCapacity;
        private final java.time.Instant endTime;
        private final java.lang.Number maxCapacity;
        private final java.lang.Number minCapacity;
        private final java.time.Instant startTime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroup = software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Schedule.class));
            this.desiredCapacity = software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup, final software.amazon.awscdk.services.autoscaling.Schedule schedule, final java.lang.Number desiredCapacity, final java.time.Instant endTime, final java.lang.Number maxCapacity, final java.lang.Number minCapacity, final java.time.Instant startTime) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroup = java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required");
            this.schedule = java.util.Objects.requireNonNull(schedule, "schedule is required");
            this.desiredCapacity = desiredCapacity;
            this.endTime = endTime;
            this.maxCapacity = maxCapacity;
            this.minCapacity = minCapacity;
            this.startTime = startTime;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.Number getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final java.time.Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.time.Instant getStartTime() {
            return this.startTime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroup", om.valueToTree(this.getAutoScalingGroup()));
            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getEndTime() != null) {
                data.set("endTime", om.valueToTree(this.getEndTime()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getStartTime() != null) {
                data.set("startTime", om.valueToTree(this.getStartTime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.ScheduledActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledActionProps.Jsii$Proxy that = (ScheduledActionProps.Jsii$Proxy) o;

            if (!autoScalingGroup.equals(that.autoScalingGroup)) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            return this.startTime != null ? this.startTime.equals(that.startTime) : that.startTime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroup.hashCode();
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
            return result;
        }
    }
}
