package software.amazon.awscdk.services.cloudfront.origins;

/**
 * (experimental) An Origin that is backed by an S3 bucket.
 * <p>
 * If the bucket is configured for website hosting, this origin will be configured to use the bucket as an
 * HTTP server origin and will use the bucket's configured website redirects and error handling. Otherwise,
 * the origin is created as a bucket origin and will use CloudFront's redirect and error handling.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:59.936Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.S3Origin")
public class S3Origin extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudfront.IOrigin {

    protected S3Origin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Origin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3Origin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.S3OriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3Origin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * (experimental) The method called when a given Origin is added (for the first time) to a Distribution.
     * <p>
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginBindConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginBindConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudfront.origins.S3Origin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.origins.S3Origin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param bucket This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.s3.IBucket bucket) {
            return new Builder(bucket);
        }

        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private software.amazon.awscdk.services.cloudfront.origins.S3OriginProps.Builder props;

        private Builder(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
        }

        /**
         * (experimental) An optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
         * <p>
         * Default: - An Origin Access Identity will be created.
         * <p>
         * @return {@code this}
         * @param originAccessIdentity An optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originAccessIdentity(final software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity) {
            this.props().originAccessIdentity(originAccessIdentity);
            return this;
        }

        /**
         * (experimental) An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         * <p>
         * Must begin, but not end, with '/' (e.g., '/production/images').
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originPath(final java.lang.String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.origins.S3Origin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudfront.origins.S3Origin build() {
            return new software.amazon.awscdk.services.cloudfront.origins.S3Origin(
                this.bucket,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.origins.S3OriginProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.origins.S3OriginProps.Builder();
            }
            return this.props;
        }
    }
}
