package software.amazon.awscdk.services.cloudtrail;

/**
 * (experimental) Selecting an S3 bucket and an optional prefix to be logged for data events.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:59.939Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.S3EventSelector")
@software.amazon.jsii.Jsii.Proxy(S3EventSelector.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface S3EventSelector extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * (experimental) Data events for objects whose key matches this prefix will be logged.
     * <p>
     * Default: - all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectPrefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3EventSelector}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3EventSelector}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<S3EventSelector> {
        private software.amazon.awscdk.services.s3.IBucket bucket;
        private java.lang.String objectPrefix;

        /**
         * Sets the value of {@link S3EventSelector#getBucket}
         * @param bucket S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3EventSelector#getObjectPrefix}
         * @param objectPrefix Data events for objects whose key matches this prefix will be logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder objectPrefix(java.lang.String objectPrefix) {
            this.objectPrefix = objectPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3EventSelector}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public S3EventSelector build() {
            return new Jsii$Proxy(bucket, objectPrefix);
        }
    }

    /**
     * An implementation for {@link S3EventSelector}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EventSelector {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String objectPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.objectPrefix = software.amazon.jsii.Kernel.get(this, "objectPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket bucket, final java.lang.String objectPrefix) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
            this.objectPrefix = objectPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getObjectPrefix() {
            return this.objectPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getObjectPrefix() != null) {
                data.set("objectPrefix", om.valueToTree(this.getObjectPrefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.S3EventSelector"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3EventSelector.Jsii$Proxy that = (S3EventSelector.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            return this.objectPrefix != null ? this.objectPrefix.equals(that.objectPrefix) : that.objectPrefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.objectPrefix != null ? this.objectPrefix.hashCode() : 0);
            return result;
        }
    }
}
