package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) A math expression built with metric(s) emitted by a service.
 * <p>
 * The math expression is a combination of an expression (x+y) and metrics to apply expression on.
 * It also contains metadata which is used only in graphs, such as color and label.
 * It makes sense to embed this in here, so that compound constructs can attach
 * that metadata to metrics they expose.
 * <p>
 * This class does not represent a resource, so hence is not a construct. Instead,
 * MathExpression is an abstraction that makes it easy to specify metrics for use in both
 * alarms and graphs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:25:59.970Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.MathExpression")
public class MathExpression extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IMetric {

    protected MathExpression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MathExpression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public MathExpression(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MathExpressionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Make a new Alarm for this metric.
     * <p>
     * Combines both properties that may adjust the metric (aggregation) as well
     * as alarm properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Alarm createAlarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions props) {
        return software.amazon.jsii.Kernel.call(this, "createAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Alarm.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Inspect the details of the metric object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MetricConfig toMetricConfig() {
        return software.amazon.jsii.Kernel.call(this, "toMetricConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MetricConfig.class));
    }

    /**
     * (experimental) Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Return a copy of Metric with properties changed.
     * <p>
     * All properties except namespace and metricName can be changed.
     * <p>
     * @param props The set of properties to change. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MathExpression with(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MathExpressionOptions props) {
        return software.amazon.jsii.Kernel.call(this, "with", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MathExpression.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The expression defining the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getExpression() {
        return software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Aggregation period of this metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getPeriod() {
        return software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * (experimental) The metrics used in the expression as KeyValuePair <id, metric>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "usingMetrics", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class))));
    }

    /**
     * (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Label for this metric when added to a Graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.MathExpression}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.MathExpression> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.MathExpressionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.MathExpressionProps.Builder();
        }

        /**
         * (experimental) Color for this metric when added to a Graph in a Dashboard.
         * <p>
         * Default: - Automatic color
         * <p>
         * @return {@code this}
         * @param color Color for this metric when added to a Graph in a Dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder color(final java.lang.String color) {
            this.props.color(color);
            return this;
        }

        /**
         * (experimental) Label for this metric when added to a Graph in a Dashboard.
         * <p>
         * Default: - Expression value is used as label
         * <p>
         * @return {@code this}
         * @param label Label for this metric when added to a Graph in a Dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder label(final java.lang.String label) {
            this.props.label(label);
            return this;
        }

        /**
         * (experimental) The period over which the expression's statistics are applied.
         * <p>
         * This period overrides all periods in the metrics used in this
         * math expression.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param period The period over which the expression's statistics are applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * (experimental) The expression defining the metric.
         * <p>
         * @return {@code this}
         * @param expression The expression defining the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expression(final java.lang.String expression) {
            this.props.expression(expression);
            return this;
        }

        /**
         * (experimental) The metrics used in the expression, in a map.
         * <p>
         * The key is the identifier that represents the given metric in the
         * expression, and the value is the actual Metric object.
         * <p>
         * @return {@code this}
         * @param usingMetrics The metrics used in the expression, in a map. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder usingMetrics(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics) {
            this.props.usingMetrics(usingMetrics);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.MathExpression}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudwatch.MathExpression build() {
            return new software.amazon.awscdk.services.cloudwatch.MathExpression(
                this.props.build()
            );
        }
    }
}
