package software.amazon.awscdk.services.codebuild;

/**
 * (experimental) Construction properties for {@link GitHubEnterpriseSource}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:03.403Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.GitHubEnterpriseSourceProps")
@software.amazon.jsii.Jsii.Proxy(GitHubEnterpriseSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GitHubEnterpriseSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.SourceProps {

    /**
     * (experimental) The HTTPS URL of the repository in your GitHub Enterprise installation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpsCloneUrl();

    /**
     * (experimental) The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
     * <p>
     * Default: the default branch's HEAD commit ID is used
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * "mybranch";}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranchOrRef() {
        return null;
    }

    /**
     * (experimental) The depth of history to download.
     * <p>
     * Minimum value is 0.
     * If this value is 0, greater than 25, or not provided,
     * then the full history is downloaded with each build of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCloneDepth() {
        return null;
    }

    /**
     * (experimental) Whether to fetch submodules while cloning git repo.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFetchSubmodules() {
        return null;
    }

    /**
     * (experimental) Whether to ignore SSL errors when connecting to the repository.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreSslErrors() {
        return null;
    }

    /**
     * (experimental) Whether to send notifications on your build's start and end.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReportBuildStatus() {
        return null;
    }

    /**
     * (experimental) Whether to create a webhook that will trigger a build every time an event happens in the repository.
     * <p>
     * Default: true if any `webhookFilters` were provided, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWebhook() {
        return null;
    }

    /**
     * (experimental) A list of webhook filters that can constraint what events in the repository will trigger a build.
     * <p>
     * A build is triggered if any of the provided filter groups match.
     * Only valid if <code>webhook</code> was not provided as false.
     * <p>
     * Default: every push and every Pull Request (create or update) triggers a build
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> getWebhookFilters() {
        return null;
    }

    /**
     * (experimental) Trigger a batch build from a webhook instead of a standard one.
     * <p>
     * Enabling this will enable batch builds on the CodeBuild project.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWebhookTriggersBatchBuild() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitHubEnterpriseSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitHubEnterpriseSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GitHubEnterpriseSourceProps> {
        private java.lang.String httpsCloneUrl;
        private java.lang.String branchOrRef;
        private java.lang.Number cloneDepth;
        private java.lang.Boolean fetchSubmodules;
        private java.lang.Boolean ignoreSslErrors;
        private java.lang.Boolean reportBuildStatus;
        private java.lang.Boolean webhook;
        private java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters;
        private java.lang.Boolean webhookTriggersBatchBuild;
        private java.lang.String identifier;

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getHttpsCloneUrl}
         * @param httpsCloneUrl The HTTPS URL of the repository in your GitHub Enterprise installation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpsCloneUrl(java.lang.String httpsCloneUrl) {
            this.httpsCloneUrl = httpsCloneUrl;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getBranchOrRef}
         * @param branchOrRef The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branchOrRef(java.lang.String branchOrRef) {
            this.branchOrRef = branchOrRef;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getCloneDepth}
         * @param cloneDepth The depth of history to download.
         *                   Minimum value is 0.
         *                   If this value is 0, greater than 25, or not provided,
         *                   then the full history is downloaded with each build of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloneDepth(java.lang.Number cloneDepth) {
            this.cloneDepth = cloneDepth;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getFetchSubmodules}
         * @param fetchSubmodules Whether to fetch submodules while cloning git repo.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fetchSubmodules(java.lang.Boolean fetchSubmodules) {
            this.fetchSubmodules = fetchSubmodules;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getIgnoreSslErrors}
         * @param ignoreSslErrors Whether to ignore SSL errors when connecting to the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignoreSslErrors(java.lang.Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getReportBuildStatus}
         * @param reportBuildStatus Whether to send notifications on your build's start and end.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reportBuildStatus(java.lang.Boolean reportBuildStatus) {
            this.reportBuildStatus = reportBuildStatus;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getWebhook}
         * @param webhook Whether to create a webhook that will trigger a build every time an event happens in the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder webhook(java.lang.Boolean webhook) {
            this.webhook = webhook;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getWebhookFilters}
         * @param webhookFilters A list of webhook filters that can constraint what events in the repository will trigger a build.
         *                       A build is triggered if any of the provided filter groups match.
         *                       Only valid if <code>webhook</code> was not provided as false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder webhookFilters(java.util.List<? extends software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters) {
            this.webhookFilters = (java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup>)webhookFilters;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getWebhookTriggersBatchBuild}
         * @param webhookTriggersBatchBuild Trigger a batch build from a webhook instead of a standard one.
         *                                  Enabling this will enable batch builds on the CodeBuild project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder webhookTriggersBatchBuild(java.lang.Boolean webhookTriggersBatchBuild) {
            this.webhookTriggersBatchBuild = webhookTriggersBatchBuild;
            return this;
        }

        /**
         * Sets the value of {@link GitHubEnterpriseSourceProps#getIdentifier}
         * @param identifier The source identifier.
         *                   This property is required on secondary sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitHubEnterpriseSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GitHubEnterpriseSourceProps build() {
            return new Jsii$Proxy(httpsCloneUrl, branchOrRef, cloneDepth, fetchSubmodules, ignoreSslErrors, reportBuildStatus, webhook, webhookFilters, webhookTriggersBatchBuild, identifier);
        }
    }

    /**
     * An implementation for {@link GitHubEnterpriseSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubEnterpriseSourceProps {
        private final java.lang.String httpsCloneUrl;
        private final java.lang.String branchOrRef;
        private final java.lang.Number cloneDepth;
        private final java.lang.Boolean fetchSubmodules;
        private final java.lang.Boolean ignoreSslErrors;
        private final java.lang.Boolean reportBuildStatus;
        private final java.lang.Boolean webhook;
        private final java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters;
        private final java.lang.Boolean webhookTriggersBatchBuild;
        private final java.lang.String identifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpsCloneUrl = software.amazon.jsii.Kernel.get(this, "httpsCloneUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.branchOrRef = software.amazon.jsii.Kernel.get(this, "branchOrRef", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloneDepth = software.amazon.jsii.Kernel.get(this, "cloneDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.fetchSubmodules = software.amazon.jsii.Kernel.get(this, "fetchSubmodules", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreSslErrors = software.amazon.jsii.Kernel.get(this, "ignoreSslErrors", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reportBuildStatus = software.amazon.jsii.Kernel.get(this, "reportBuildStatus", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.webhook = software.amazon.jsii.Kernel.get(this, "webhook", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.webhookFilters = software.amazon.jsii.Kernel.get(this, "webhookFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class)));
            this.webhookTriggersBatchBuild = software.amazon.jsii.Kernel.get(this, "webhookTriggersBatchBuild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String httpsCloneUrl, final java.lang.String branchOrRef, final java.lang.Number cloneDepth, final java.lang.Boolean fetchSubmodules, final java.lang.Boolean ignoreSslErrors, final java.lang.Boolean reportBuildStatus, final java.lang.Boolean webhook, final java.util.List<? extends software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters, final java.lang.Boolean webhookTriggersBatchBuild, final java.lang.String identifier) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpsCloneUrl = java.util.Objects.requireNonNull(httpsCloneUrl, "httpsCloneUrl is required");
            this.branchOrRef = branchOrRef;
            this.cloneDepth = cloneDepth;
            this.fetchSubmodules = fetchSubmodules;
            this.ignoreSslErrors = ignoreSslErrors;
            this.reportBuildStatus = reportBuildStatus;
            this.webhook = webhook;
            this.webhookFilters = (java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup>)webhookFilters;
            this.webhookTriggersBatchBuild = webhookTriggersBatchBuild;
            this.identifier = identifier;
        }

        @Override
        public final java.lang.String getHttpsCloneUrl() {
            return this.httpsCloneUrl;
        }

        @Override
        public final java.lang.String getBranchOrRef() {
            return this.branchOrRef;
        }

        @Override
        public final java.lang.Number getCloneDepth() {
            return this.cloneDepth;
        }

        @Override
        public final java.lang.Boolean getFetchSubmodules() {
            return this.fetchSubmodules;
        }

        @Override
        public final java.lang.Boolean getIgnoreSslErrors() {
            return this.ignoreSslErrors;
        }

        @Override
        public final java.lang.Boolean getReportBuildStatus() {
            return this.reportBuildStatus;
        }

        @Override
        public final java.lang.Boolean getWebhook() {
            return this.webhook;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> getWebhookFilters() {
            return this.webhookFilters;
        }

        @Override
        public final java.lang.Boolean getWebhookTriggersBatchBuild() {
            return this.webhookTriggersBatchBuild;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpsCloneUrl", om.valueToTree(this.getHttpsCloneUrl()));
            if (this.getBranchOrRef() != null) {
                data.set("branchOrRef", om.valueToTree(this.getBranchOrRef()));
            }
            if (this.getCloneDepth() != null) {
                data.set("cloneDepth", om.valueToTree(this.getCloneDepth()));
            }
            if (this.getFetchSubmodules() != null) {
                data.set("fetchSubmodules", om.valueToTree(this.getFetchSubmodules()));
            }
            if (this.getIgnoreSslErrors() != null) {
                data.set("ignoreSslErrors", om.valueToTree(this.getIgnoreSslErrors()));
            }
            if (this.getReportBuildStatus() != null) {
                data.set("reportBuildStatus", om.valueToTree(this.getReportBuildStatus()));
            }
            if (this.getWebhook() != null) {
                data.set("webhook", om.valueToTree(this.getWebhook()));
            }
            if (this.getWebhookFilters() != null) {
                data.set("webhookFilters", om.valueToTree(this.getWebhookFilters()));
            }
            if (this.getWebhookTriggersBatchBuild() != null) {
                data.set("webhookTriggersBatchBuild", om.valueToTree(this.getWebhookTriggersBatchBuild()));
            }
            if (this.getIdentifier() != null) {
                data.set("identifier", om.valueToTree(this.getIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.GitHubEnterpriseSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitHubEnterpriseSourceProps.Jsii$Proxy that = (GitHubEnterpriseSourceProps.Jsii$Proxy) o;

            if (!httpsCloneUrl.equals(that.httpsCloneUrl)) return false;
            if (this.branchOrRef != null ? !this.branchOrRef.equals(that.branchOrRef) : that.branchOrRef != null) return false;
            if (this.cloneDepth != null ? !this.cloneDepth.equals(that.cloneDepth) : that.cloneDepth != null) return false;
            if (this.fetchSubmodules != null ? !this.fetchSubmodules.equals(that.fetchSubmodules) : that.fetchSubmodules != null) return false;
            if (this.ignoreSslErrors != null ? !this.ignoreSslErrors.equals(that.ignoreSslErrors) : that.ignoreSslErrors != null) return false;
            if (this.reportBuildStatus != null ? !this.reportBuildStatus.equals(that.reportBuildStatus) : that.reportBuildStatus != null) return false;
            if (this.webhook != null ? !this.webhook.equals(that.webhook) : that.webhook != null) return false;
            if (this.webhookFilters != null ? !this.webhookFilters.equals(that.webhookFilters) : that.webhookFilters != null) return false;
            if (this.webhookTriggersBatchBuild != null ? !this.webhookTriggersBatchBuild.equals(that.webhookTriggersBatchBuild) : that.webhookTriggersBatchBuild != null) return false;
            return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpsCloneUrl.hashCode();
            result = 31 * result + (this.branchOrRef != null ? this.branchOrRef.hashCode() : 0);
            result = 31 * result + (this.cloneDepth != null ? this.cloneDepth.hashCode() : 0);
            result = 31 * result + (this.fetchSubmodules != null ? this.fetchSubmodules.hashCode() : 0);
            result = 31 * result + (this.ignoreSslErrors != null ? this.ignoreSslErrors.hashCode() : 0);
            result = 31 * result + (this.reportBuildStatus != null ? this.reportBuildStatus.hashCode() : 0);
            result = 31 * result + (this.webhook != null ? this.webhook.hashCode() : 0);
            result = 31 * result + (this.webhookFilters != null ? this.webhookFilters.hashCode() : 0);
            result = 31 * result + (this.webhookTriggersBatchBuild != null ? this.webhookTriggersBatchBuild.hashCode() : 0);
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }
    }
}
